/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.util.ZooZap;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class UpgradeUtil
implements KeywordExecutable {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeUtil.class);

    public String keyword() {
        return "upgrade";
    }

    public String description() {
        return "utility used to perform various upgrade steps for an Accumulo instance";
    }

    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(this.keyword(), args, new Object[0]);
        if (!opts.prepare) {
            new JCommander((Object)opts).usage();
            return;
        }
        SiteConfiguration siteConf = SiteConfiguration.auto();
        if (siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            SecurityUtil.serverLogin((AccumuloConfiguration)siteConf);
        }
        String volDir = (String)VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConf).iterator().next();
        Path instanceDir = new Path(volDir, "instance_id");
        InstanceId iid = VolumeManager.getInstanceIDFromHdfs(instanceDir, new Configuration());
        ZooReaderWriter zoo = new ZooReaderWriter((AccumuloConfiguration)siteConf);
        if (opts.prepare) {
            String zUpgradepath = "/accumulo/" + String.valueOf(iid) + "/upgrade_ready";
            try {
                if (zoo.exists(zUpgradepath)) {
                    zoo.delete(zUpgradepath);
                }
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException("Error creating or checking for " + zUpgradepath + " node in zookeeper: " + e.getMessage(), e);
            }
            LOG.info("Upgrade specified, validating that Manager is stopped");
            ServiceLock.ServiceLockPath mgrPath = ServiceLock.path((String)("/accumulo/" + String.valueOf(iid) + "/managers/lock"));
            try {
                if (ServiceLock.getLockData((ZooKeeper)zoo.getZooKeeper(), (ServiceLock.ServiceLockPath)mgrPath) != null) {
                    throw new IllegalStateException("Manager is running, shut it down and retry this operation");
                }
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException("Error trying to determine if Manager lock is held", e);
            }
            LOG.info("Checking for existing fate transactions");
            try {
                if (!zoo.getChildren("/accumulo/" + String.valueOf(iid) + "/fate").isEmpty()) {
                    throw new IllegalStateException("Cannot complete upgrade preparation because FATE transactions exist. You can start a tserver, but not the Manager, then use the shell to delete completed transactions and fail pending or in-progress transactions. Once all of the FATE transactions have been removed you can retry this operation.");
                }
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException("Error checking for existing FATE transactions", e);
            }
            LOG.info("Creating {} node in zookeeper, servers will be prevented from starting while this node exists", (Object)zUpgradepath);
            try {
                zoo.putPersistentData(zUpgradepath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException("Error creating " + zUpgradepath + " node in zookeeper. Check for any issues and retry.", e);
            }
            LOG.info("Forcing removal of all server locks");
            new ZooZap().zap(siteConf, "-manager", "-compaction-coordinators", "-tservers", "-compactors", "-sservers", "--monitor", "--gc");
            LOG.info("Instance {} prepared for upgrade. Server processes will not start while in this state. To undo this state and abort upgrade preparations delete the zookeeper node: {}. If you abort and restart the instance, then you  should re-run this utility before upgrading.", (Object)iid.canonical(), (Object)zUpgradepath);
        }
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(names={"--prepare"}, description="prepare an older version instance for an upgrade to a newer non-bugfix release. This command should be run using the older version of software after the instance is shut down.")
        boolean prepare = false;

        Opts() {
        }
    }
}

