/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.authz;

import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.shiro.authz.Action;

public class DestinationAction
implements Action {
    private final ConnectionContext connectionContext;
    private final ActiveMQDestination destination;
    private final String verb;

    public DestinationAction(ConnectionContext connectionContext, ActiveMQDestination destination, String verb) {
        if (connectionContext == null) {
            throw new IllegalArgumentException("ConnectionContext argument cannot be null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("ActiveMQDestination argument cannot be null.");
        }
        if (verb == null) {
            throw new IllegalArgumentException("verb argument cannot be null.");
        }
        this.connectionContext = connectionContext;
        this.destination = destination;
        this.verb = verb;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public String getVerb() {
        return this.verb;
    }

    @Override
    public String toString() {
        return this.verb + " destination: " + String.valueOf(this.destination);
    }
}

