/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.StreamCacheException;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.util.ObjectHelper;

final class StreamCachingHelper {
    private StreamCachingHelper() {
    }

    public static StreamCache convertToStreamCache(StreamCachingStrategy strategy, Exchange exchange, Message message) {
        try {
            Object body = message.getBody();
            if (body == null) {
                return null;
            }
            if (body instanceof StreamCache) {
                StreamCache sc = (StreamCache)body;
                sc.reset();
                return sc;
            }
        }
        catch (Exception e) {
            StreamCachingHelper.handleException(exchange, null, e);
        }
        Throwable cause = exchange.getException();
        if (cause == null) {
            cause = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
        }
        return StreamCachingHelper.tryStreamCache(strategy, exchange, message, cause);
    }

    private static StreamCache tryStreamCache(StreamCachingStrategy strategy, Exchange exchange, Message inMessage, Throwable cause) {
        boolean failed;
        boolean bl = failed = cause != null && ObjectHelper.getException(StreamCacheException.class, (Throwable)cause) != null;
        if (!failed) {
            boolean disabled = exchange.getExchangeExtension().isStreamCacheDisabled();
            if (disabled) {
                return null;
            }
            try {
                StreamCache sc = strategy.cache(exchange);
                if (sc != null) {
                    inMessage.setBody((Object)sc);
                }
                return sc;
            }
            catch (Exception e) {
                StreamCachingHelper.handleException(exchange, e);
            }
        }
        return null;
    }

    private static void handleException(Exchange exchange, Exception e) {
        StreamCachingHelper.handleException(exchange, exchange.getMessage().getBody(), e);
    }

    private static void handleException(Exchange exchange, Object value, Exception e) {
        StreamCacheException tce = new StreamCacheException(value, (Throwable)e);
        exchange.setException((Throwable)tce);
        exchange.getExchangeExtension().setRedeliveryExhausted(true);
    }
}

