/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicSession;
import jakarta.jms.TransactionInProgressException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.SessionProxy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TransactionAwareConnectionFactoryProxy
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    @Nullable
    private ConnectionFactory targetConnectionFactory;
    private boolean synchedLocalTransactionAllowed = false;

    public TransactionAwareConnectionFactoryProxy() {
    }

    public TransactionAwareConnectionFactoryProxy(ConnectionFactory targetConnectionFactory) {
        this.setTargetConnectionFactory(targetConnectionFactory);
    }

    public final void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, "'targetConnectionFactory' must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    protected ConnectionFactory getTargetConnectionFactory() {
        ConnectionFactory target = this.targetConnectionFactory;
        Assert.state(target != null, "'targetConnectionFactory' is required");
        return target;
    }

    public void setSynchedLocalTransactionAllowed(boolean synchedLocalTransactionAllowed) {
        this.synchedLocalTransactionAllowed = synchedLocalTransactionAllowed;
    }

    protected boolean isSynchedLocalTransactionAllowed() {
        return this.synchedLocalTransactionAllowed;
    }

    @Override
    public Connection createConnection() throws JMSException {
        Connection targetConnection = this.getTargetConnectionFactory().createConnection();
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    @Override
    public Connection createConnection(String username, String password) throws JMSException {
        Connection targetConnection = this.getTargetConnectionFactory().createConnection(username, password);
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    @Override
    public QueueConnection createQueueConnection() throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)target;
        QueueConnection targetConnection = queueFactory.createQueueConnection();
        return (QueueConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    @Override
    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)target;
        QueueConnection targetConnection = queueFactory.createQueueConnection(username, password);
        return (QueueConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    @Override
    public TopicConnection createTopicConnection() throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnectionFactory topicFactory = (TopicConnectionFactory)target;
        TopicConnection targetConnection = topicFactory.createTopicConnection();
        return (TopicConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    @Override
    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnectionFactory topicFactory = (TopicConnectionFactory)target;
        TopicConnection targetConnection = topicFactory.createTopicConnection(username, password);
        return (TopicConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    @Override
    public JMSContext createContext() {
        return this.getTargetConnectionFactory().createContext();
    }

    @Override
    public JMSContext createContext(String userName, String password) {
        return this.getTargetConnectionFactory().createContext(userName, password);
    }

    @Override
    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.getTargetConnectionFactory().createContext(userName, password, sessionMode);
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        return this.getTargetConnectionFactory().createContext(sessionMode);
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target) {
        ArrayList classes = new ArrayList(3);
        classes.add(Connection.class);
        if (target instanceof QueueConnection) {
            classes.add(QueueConnection.class);
        }
        if (target instanceof TopicConnection) {
            classes.add(TopicConnection.class);
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), ClassUtils.toClassArray(classes), (InvocationHandler)new TransactionAwareConnectionInvocationHandler(target));
    }

    private class TransactionAwareConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public TransactionAwareConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Session session;
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
            }
            if (Session.class == method.getReturnType() ? (session = ConnectionFactoryUtils.getTransactionalSession(TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null : (QueueSession.class == method.getReturnType() ? (session = ConnectionFactoryUtils.getTransactionalQueueSession((QueueConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (QueueConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null : TopicSession.class == method.getReturnType() && (session = ConnectionFactoryUtils.getTransactionalTopicSession((TopicConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (TopicConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null)) {
                return this.getCloseSuppressingSessionProxy(session);
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private Session getCloseSuppressingSessionProxy(Session target) {
            ArrayList classes = new ArrayList(3);
            classes.add(SessionProxy.class);
            if (target instanceof QueueSession) {
                classes.add(QueueSession.class);
            }
            if (target instanceof TopicSession) {
                classes.add(TopicSession.class);
            }
            return (Session)Proxy.newProxyInstance(SessionProxy.class.getClassLoader(), ClassUtils.toClassArray(classes), (InvocationHandler)new CloseSuppressingSessionInvocationHandler(target));
        }
    }

    private static class CloseSuppressingSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingSessionInvocationHandler(Session target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object;
            switch (method.getName()) {
                case "equals": {
                    Boolean bl = proxy == args[0];
                    object = bl;
                    break;
                }
                case "hashCode": {
                    Integer n = System.identityHashCode(proxy);
                    object = n;
                    break;
                }
                case "commit": {
                    throw new TransactionInProgressException("Commit call not allowed within a managed transaction");
                }
                case "rollback": {
                    throw new TransactionInProgressException("Rollback call not allowed within a managed transaction");
                }
                case "close": {
                    Session session = null;
                    object = session;
                    break;
                }
                case "getTargetSession": {
                    Session session = this.target;
                    object = session;
                    break;
                }
                default: {
                    try {
                        Object object2;
                        object = object2 = method.invoke((Object)this.target, args);
                        break;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
            }
            return object;
        }
    }
}

