/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;

public class ReadHandler
extends AbstractCommandHandler<JolokiaReadRequest> {
    private static final MBeanServerAccess.MBeanAction<MBeanInfo> MBEAN_INFO_HANDLER = new MBeanServerAccess.MBeanAction<MBeanInfo>(){

        public MBeanInfo execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException {
            try {
                return pConn.getMBeanInfo(pName);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Cannot inspect " + String.valueOf(pName) + ": " + String.valueOf(e), e);
            }
        }
    };
    private static final MBeanServerAccess.MBeanAction<Object> MBEAN_ATTRIBUTE_READ_HANDLER = new MBeanServerAccess.MBeanAction<Object>(){

        public Object execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException, AttributeNotFoundException {
            String attribute = (String)extraArgs[0];
            return pConn.getAttribute(pName, attribute);
        }
    };
    private static final MBeanServerAccess.MBeanAction<AttributeList> MBEAN_ATTRIBUTES_READ_HANDLER = new MBeanServerAccess.MBeanAction<AttributeList>(){

        public AttributeList execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException {
            return pConn.getAttributes(pName, (String[])extraArgs);
        }
    };

    @Override
    public RequestType getType() {
        return RequestType.READ;
    }

    @Override
    public boolean handleAllServersAtOnce(JolokiaReadRequest pRequest) {
        return pRequest.getObjectName().isPattern() || pRequest.isMultiAttributeMode() || !pRequest.hasAttribute();
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection pServer, JolokiaReadRequest pRequest) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        this.checkRestriction(pRequest.getObjectName(), pRequest.getAttributeName());
        return pServer.getAttribute(pRequest.getObjectName(), pRequest.getAttributeName());
    }

    @Override
    public Object doHandleAllServerRequest(MBeanServerAccess pServerManager, JolokiaReadRequest pRequest, Object pPreviousResult) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        ObjectName oName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        if (oName.isPattern()) {
            return this.fetchAttributesForMBeanPattern(pServerManager, pRequest);
        }
        return this.fetchAttributes(pServerManager, oName, pRequest.getAttributeNames(), faultHandler);
    }

    private Object fetchAttributesForMBeanPattern(MBeanServerAccess pServerManager, JolokiaReadRequest pRequest) throws IOException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        ObjectName objectName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        Set<ObjectName> names = this.searchMBeans(pServerManager, objectName);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        List attributeNames = pRequest.getAttributeNames();
        for (ObjectName name : names) {
            try {
                if (!pRequest.hasAttribute()) {
                    Map values = (Map)this.fetchAttributes(pServerManager, name, null, faultHandler);
                    if (values.isEmpty()) continue;
                    ret.put(pRequest.getOrderedObjectName(name), values);
                    continue;
                }
                List<String> filteredAttributeNames = this.filterAttributeNames(pServerManager, name, attributeNames);
                if (filteredAttributeNames.isEmpty()) continue;
                ret.put(pRequest.getOrderedObjectName(name), this.fetchAttributes(pServerManager, name, filteredAttributeNames, faultHandler));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("No matching attributes " + String.valueOf(pRequest.getAttributeNames()) + " found on MBeans " + String.valueOf(names));
        }
        return ret;
    }

    private Set<ObjectName> searchMBeans(MBeanServerAccess pServerManager, ObjectName pObjectName) throws IOException, InstanceNotFoundException {
        Set names = pServerManager.queryNames(pObjectName);
        if (names.isEmpty()) {
            throw new InstanceNotFoundException("No MBean with pattern " + String.valueOf(pObjectName) + " found for reading attributes");
        }
        return names;
    }

    private List<String> filterAttributeNames(MBeanServerAccess pSeverManager, ObjectName pName, List<String> pNames) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        HashSet<String> attrs = new HashSet<String>(this.getAllAttributesNames(pSeverManager, pName));
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : pNames) {
            if (!attrs.contains(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    private Object fetchAttributes(MBeanServerAccess pServerManager, ObjectName pMBeanName, List<String> pAttributeNames, ValueFaultHandler pFaultHandler) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        List<String> attributes = this.resolveAttributes(pServerManager, pMBeanName, pAttributeNames);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        boolean allFetched = false;
        if (attributes.size() > 1) {
            try {
                AttributeList allAttributes = this.getAttributes(pServerManager, pMBeanName, (String[])attributes.toArray(String[]::new));
                for (Attribute a : allAttributes.asList()) {
                    mapping.put(a.getName(), a.getValue());
                }
                allFetched = attributes.size() == mapping.size();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        for (String attribute : attributes) {
            try {
                this.checkRestriction(pMBeanName, attribute);
                if (allFetched) {
                    ret.put(attribute, mapping.get(attribute));
                    continue;
                }
                if (mapping.containsKey(attribute)) {
                    ret.put(attribute, mapping.get(attribute));
                    continue;
                }
                ret.put(attribute, this.getAttribute(pServerManager, pMBeanName, attribute));
            }
            catch (MBeanException e) {
                ret.put(attribute, pFaultHandler.handleException((Throwable)e));
            }
            catch (IllegalArgumentException e) {
                ret.put(attribute, pFaultHandler.handleException((Throwable)e));
            }
            catch (ReflectionException e) {
                ret.put(attribute, pFaultHandler.handleException((Throwable)e));
            }
            catch (IOException e) {
                ret.put(attribute, pFaultHandler.handleException((Throwable)e));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof UnsupportedOperationException) {
                    ret.put(attribute, "Unsupported");
                    continue;
                }
                ret.put(attribute, pFaultHandler.handleException((Throwable)e));
            }
            catch (AttributeNotFoundException e) {
                ret.put(attribute, pFaultHandler.handleException((Throwable)e));
            }
        }
        return ret;
    }

    private List<String> resolveAttributes(MBeanServerAccess pServers, ObjectName pMBeanName, List<String> pAttributeNames) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        List<String> attributes = pAttributeNames;
        if (this.shouldAllAttributesBeFetched(pAttributeNames)) {
            attributes = this.getAllAttributesNames(pServers, pMBeanName);
        }
        return attributes;
    }

    private boolean shouldAllAttributesBeFetched(List<String> pAttributeNames) {
        return pAttributeNames == null || pAttributeNames.isEmpty() || pAttributeNames.size() == 1 && pAttributeNames.get(0) == null;
    }

    private MBeanInfo getMBeanInfo(MBeanServerAccess pServerManager, ObjectName pObjectName) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        return (MBeanInfo)pServerManager.call(pObjectName, MBEAN_INFO_HANDLER, new Object[0]);
    }

    private Object getAttribute(MBeanServerAccess pServerManager, ObjectName pMBeanName, String attribute) throws MBeanException, ReflectionException, IOException, AttributeNotFoundException, InstanceNotFoundException {
        return pServerManager.call(pMBeanName, MBEAN_ATTRIBUTE_READ_HANDLER, new Object[]{attribute});
    }

    private AttributeList getAttributes(MBeanServerAccess pServerManager, ObjectName pMBeanName, String[] attributes) throws MBeanException, ReflectionException, IOException, AttributeNotFoundException, InstanceNotFoundException {
        return (AttributeList)pServerManager.call(pMBeanName, MBEAN_ATTRIBUTES_READ_HANDLER, (Object[])attributes);
    }

    private List<String> getAllAttributesNames(MBeanServerAccess pServerManager, ObjectName pObjectName) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        MBeanInfo mBeanInfo = this.getMBeanInfo(pServerManager, pObjectName);
        ArrayList<String> ret = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : mBeanInfo.getAttributes()) {
            if (!attrInfo.isReadable()) continue;
            ret.add(attrInfo.getName());
        }
        return ret;
    }

    private void checkRestriction(ObjectName mBeanName, String attribute) {
        if (!this.context.isAttributeReadAllowed(mBeanName, attribute)) {
            throw new SecurityException("Reading attribute " + attribute + " is forbidden for MBean " + mBeanName.getCanonicalName());
        }
    }

    @Override
    protected void checkForRestriction(JolokiaReadRequest pRequest) {
    }
}

