/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPLargeMessageWriter
implements MessageWriter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ProtonServerSenderContext serverSender;
    private final AMQPConnectionContext connection;
    private final AMQPSessionCallback sessionSPI;
    private final Sender protonSender;
    private MessageReference reference;
    private AMQPLargeMessage message;
    private LargeBodyReader largeBodyReader;
    private Delivery delivery;
    private long position;
    private boolean initialPacketHandled;
    private volatile boolean closed = true;

    public AMQPLargeMessageWriter(ProtonServerSenderContext serverSender) {
        this.serverSender = serverSender;
        this.connection = serverSender.getSessionContext().getAMQPConnectionContext();
        this.sessionSPI = serverSender.getSessionContext().getSessionSPI();
        this.protonSender = serverSender.getSender();
    }

    @Override
    public boolean isWriting() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                try {
                    if (this.largeBodyReader != null) {
                        this.largeBodyReader.close();
                    }
                }
                catch (Exception e) {
                    logger.warn("{}", (Object)e.getMessage(), (Object)e);
                }
                if (this.message != null) {
                    this.message.usageDown();
                }
            }
            finally {
                this.resetClosed();
            }
        }
    }

    @Override
    public AMQPLargeMessageWriter open(MessageReference reference) {
        if (!this.closed) {
            throw new IllegalStateException("Trying to open an AMQP Large Message writer that was not closed");
        }
        this.reference = reference;
        this.message = (AMQPLargeMessage)reference.getMessage();
        this.message.usageUp();
        try {
            this.largeBodyReader = this.message.getLargeBodyReader();
            this.largeBodyReader.open();
        }
        catch (Exception e) {
            this.serverSender.reportDeliveryError(this, reference, e);
        }
        this.resetOpen();
        return this;
    }

    private void resetClosed() {
        this.message = null;
        this.reference = null;
        this.delivery = null;
        this.largeBodyReader = null;
        this.position = 0L;
        this.initialPacketHandled = false;
        this.closed = true;
    }

    private void resetOpen() {
        this.position = 0L;
        this.initialPacketHandled = false;
        this.closed = false;
    }

    @Override
    public void writeBytes(MessageReference messageReference) {
        if (this.protonSender.getLocalState() == EndpointState.CLOSED) {
            logger.debug("Not delivering message {} as the sender is closed and credits were available, if you see too many of these it means clients are issuing credits and closing the connection with pending credits a lot of times", (Object)messageReference);
            return;
        }
        if (this.closed) {
            throw new IllegalStateException("Cannot write to an AMQP Large Message Writer that has been closed");
        }
        if (this.sessionSPI.invokeOutgoing(this.message, (ActiveMQProtonRemotingConnection)this.sessionSPI.getTransportConnection().getProtocolConnection()) != null) {
            this.close();
            return;
        }
        this.delivery = this.serverSender.createDelivery(messageReference, (int)this.message.getMessageFormat());
        this.tryDelivering();
    }

    private void resume() {
        this.connection.runLater(this::tryDelivering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDelivering() {
        if (this.closed) {
            logger.trace("AMQP Large Message Writer was closed before queued write attempt was executed");
            return;
        }
        int frameSize = this.protonSender.getSession().getConnection().getTransport().getOutboundFrameSizeLimit() - 50 - (this.delivery.getTag() != null ? this.delivery.getTag().length : 0);
        try {
            ByteBuf frameBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(frameSize, frameSize);
            NettyReadable frameView = new NettyReadable(frameBuffer);
            try {
                this.largeBodyReader.position(this.position);
                long bodySize = this.largeBodyReader.getSize();
                frameBuffer.ensureWritable(frameSize);
                if (!this.initialPacketHandled && this.protonSender.getLocalState() != EndpointState.CLOSED) {
                    if (!this.deliverInitialPacket(this.largeBodyReader, frameBuffer)) {
                        return;
                    }
                    this.initialPacketHandled = true;
                }
                while (this.protonSender.getLocalState() != EndpointState.CLOSED && this.position < bodySize) {
                    if (!this.connection.flowControl(this::resume)) {
                        return;
                    }
                    frameBuffer.clear();
                    int readSize = this.largeBodyReader.readInto(frameBuffer.internalNioBuffer(0, frameSize));
                    frameBuffer.writerIndex(readSize);
                    this.protonSender.send((ReadableBuffer)frameView);
                    this.position += (long)readSize;
                    if (readSize <= 0 || this.position >= bodySize) continue;
                    this.connection.instantFlush();
                }
            }
            finally {
                frameBuffer.release();
            }
            this.serverSender.reportDeliveryComplete(this, this.reference, this.delivery, true);
        }
        catch (Exception deliveryError) {
            this.serverSender.reportDeliveryError(this, this.reference, deliveryError);
        }
    }

    private boolean deliverInitialPacket(LargeBodyReader context, ByteBuf frameBuffer) throws Exception {
        int writtenBytes;
        assert (this.position == 0L && context.position() == 0L && !this.initialPacketHandled);
        if (!this.connection.flowControl(this::resume)) {
            return false;
        }
        frameBuffer.clear();
        this.message.checkReference(this.reference);
        DeliveryAnnotations deliveryAnnotationsToEncode = (DeliveryAnnotations)this.reference.getProtocolData(DeliveryAnnotations.class);
        try {
            this.replaceInitialHeader(deliveryAnnotationsToEncode, context, new NettyWritable(frameBuffer));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            assert (this.position == 0L) : "this shouldn't happen unless replaceInitialHeader is updating position before modifying frameBuffer";
            logger.debug("Delivery of message failed with an overFlowException, retrying again with expandable buffer");
            this.sendAndFlushInitialPacket(deliveryAnnotationsToEncode, context);
            return true;
        }
        int readSize = 0;
        int writableBytes = frameBuffer.writableBytes();
        if (writableBytes != 0 && (readSize = context.readInto(frameBuffer.internalNioBuffer(writtenBytes = frameBuffer.writerIndex(), writableBytes))) > 0) {
            frameBuffer.writerIndex(writtenBytes + readSize);
        }
        this.protonSender.send((ReadableBuffer)new NettyReadable(frameBuffer));
        if (readSize > 0) {
            this.position += (long)readSize;
        }
        this.connection.instantFlush();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndFlushInitialPacket(DeliveryAnnotations deliveryAnnotationsToEncode, LargeBodyReader context) throws Exception {
        ByteBuf nettyBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(AMQPMessageBrokerAccessor.getRemainingBodyPosition(this.message) * 2);
        try {
            this.replaceInitialHeader(deliveryAnnotationsToEncode, context, new NettyWritable(nettyBuffer));
            this.protonSender.send((ReadableBuffer)new NettyReadable(nettyBuffer));
        }
        finally {
            nettyBuffer.release();
            this.connection.instantFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int replaceInitialHeader(DeliveryAnnotations deliveryAnnotationsToEncode, LargeBodyReader context, WritableBuffer buf) throws Exception {
        TLSEncode.getEncoder().setByteBuffer(buf);
        try {
            int proposedPosition = this.writeHeaderAndAnnotations(deliveryAnnotationsToEncode);
            if (this.message.isReencoded()) {
                proposedPosition = this.writeMessageAnnotationsPropertiesAndApplicationProperties(context, this.message);
            }
            context.position((long)proposedPosition);
            this.position = proposedPosition;
            int n = (int)this.position;
            return n;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        }
    }

    private int writeMessageAnnotationsPropertiesAndApplicationProperties(LargeBodyReader context, AMQPLargeMessage message) throws Exception {
        int bodyPosition = AMQPMessageBrokerAccessor.getRemainingBodyPosition(message);
        assert (bodyPosition > 0);
        this.writeMessageAnnotationsPropertiesAndApplicationPropertiesInternal(message);
        return bodyPosition;
    }

    private void writeMessageAnnotationsPropertiesAndApplicationPropertiesInternal(AMQPLargeMessage message) {
        ApplicationProperties applicationProperties;
        Properties amqpProperties;
        MessageAnnotations messageAnnotations = AMQPMessageBrokerAccessor.getDecodedMessageAnnotations(message);
        if (messageAnnotations != null) {
            TLSEncode.getEncoder().writeObject((Object)messageAnnotations);
        }
        if ((amqpProperties = AMQPMessageBrokerAccessor.getCurrentProperties(message)) != null) {
            TLSEncode.getEncoder().writeObject((Object)amqpProperties);
        }
        if ((applicationProperties = AMQPMessageBrokerAccessor.getDecodedApplicationProperties(message)) != null) {
            TLSEncode.getEncoder().writeObject((Object)applicationProperties);
        }
    }

    private int writeHeaderAndAnnotations(DeliveryAnnotations deliveryAnnotationsToEncode) {
        Header header = AMQPMessageBrokerAccessor.getCurrentHeader(this.message);
        if (header != null) {
            TLSEncode.getEncoder().writeObject((Object)header);
        }
        if (deliveryAnnotationsToEncode != null) {
            TLSEncode.getEncoder().writeObject((Object)deliveryAnnotationsToEncode);
        }
        return this.message.getPositionAfterDeliveryAnnotations();
    }
}

