/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.util;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CreditsSemaphore {
    private final Sync sync;

    public CreditsSemaphore(int initialCredits) {
        this.sync = new Sync(initialCredits);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean tryAcquire() {
        return this.sync.tryAcquireShared(1) >= 0;
    }

    public void release() throws InterruptedException {
        this.sync.releaseShared(1);
    }

    public void release(int credits) throws InterruptedException {
        this.sync.releaseShared(credits);
    }

    public void setCredits(int credits) {
        this.sync.setCredits(credits);
    }

    public int getCredits() {
        return this.sync.getCredits();
    }

    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private Sync(int initial) {
            this.setState(initial);
        }

        public int getCredits() {
            return this.getState();
        }

        @Override
        public int tryAcquireShared(int numberOfAqcquires) {
            int newValue;
            while (true) {
                int actualSize;
                if ((newValue = (actualSize = this.getState()) - numberOfAqcquires) < 0) {
                    if (actualSize != this.getState()) continue;
                    return -1;
                }
                if (this.compareAndSetState(actualSize, newValue)) break;
            }
            return newValue;
        }

        @Override
        public boolean tryReleaseShared(int numberOfReleases) {
            int newValue;
            int actualSize;
            while (!this.compareAndSetState(actualSize = this.getState(), newValue = actualSize + numberOfReleases)) {
            }
            return true;
        }

        public void setCredits(int credits) {
            int actualState;
            while (!this.compareAndSetState(actualState = this.getState(), credits)) {
            }
            this.releaseShared(0);
        }
    }
}

