/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.Map;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static SQLProvider.Factory getSQLProviderFactory(String url) {
        PropertySQLProvider.Factory.SQLDialect dialect = PropertySQLProvider.Factory.identifyDialect(url);
        logger.trace("getSQLProvider Returning SQL provider for dialect {} for url::{}", (Object)dialect, (Object)url);
        return new PropertySQLProvider.Factory(dialect);
    }

    public static SQLProvider getSQLProvider(String driverClass, String tableName, SQLProvider.DatabaseStoreType storeType) {
        PropertySQLProvider.Factory.SQLDialect dialect = PropertySQLProvider.Factory.identifyDialect(driverClass);
        logger.trace("getSQLProvider Returning SQL provider for dialect {} for driver::{}, tableName::{}", new Object[]{dialect, driverClass, tableName});
        PropertySQLProvider.Factory factory = new PropertySQLProvider.Factory(dialect);
        return factory.create(tableName, storeType);
    }

    public static SQLProvider getSQLProvider(Map<String, Object> dataSourceProperties, String tableName, SQLProvider.DatabaseStoreType storeType) {
        PropertySQLProvider.Factory.SQLDialect dialect = PropertySQLProvider.Factory.investigateDialect(dataSourceProperties);
        logger.trace("getSQLProvider Returning SQL provider for dialect {}, tableName::{}", (Object)dialect, (Object)tableName);
        PropertySQLProvider.Factory factory = new PropertySQLProvider.Factory(dialect);
        return factory.create(tableName, storeType);
    }

    public static StringBuilder appendSQLExceptionDetails(StringBuilder errorMessage, SQLException exception, CharSequence sqlStatements) {
        errorMessage.append("\nSQL STATEMENTS: \n").append(sqlStatements);
        return JDBCUtils.appendSQLExceptionDetails(errorMessage, exception);
    }

    public static StringBuilder appendSQLExceptionDetails(StringBuilder errorMessage, SQLException exception) {
        errorMessage.append("\nSQL EXCEPTIONS: ");
        SQLException nextEx = exception;
        int level = 0;
        do {
            errorMessage.append('\n');
            errorMessage.append(" ".repeat(level));
            JDBCUtils.formatSqlException(errorMessage, nextEx);
            nextEx = nextEx.getNextException();
            ++level;
        } while (nextEx != null);
        return errorMessage;
    }

    private static StringBuilder formatSqlException(StringBuilder errorMessage, SQLException exception) {
        String sqlState = exception.getSQLState();
        int errorCode = exception.getErrorCode();
        String message = exception.getMessage();
        return errorMessage.append("SQLState: ").append(sqlState).append(" ErrorCode: ").append(errorCode).append(" Message: ").append(message);
    }
}

