//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Protocol Buffers describing Beam Schemas, a portable representation for
// complex types.
//
// The primary application of Schema is as the payload for the standard coder
// "beam:coder:row:v1", defined in beam_runner_api.proto

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v4.24.4
// source: org/apache/beam/model/pipeline/v1/schema.proto

package pipeline_v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AtomicType int32

const (
	AtomicType_UNSPECIFIED AtomicType = 0
	AtomicType_BYTE        AtomicType = 1
	AtomicType_INT16       AtomicType = 2
	AtomicType_INT32       AtomicType = 3
	AtomicType_INT64       AtomicType = 4
	AtomicType_FLOAT       AtomicType = 5
	AtomicType_DOUBLE      AtomicType = 6
	AtomicType_STRING      AtomicType = 7
	AtomicType_BOOLEAN     AtomicType = 8
	AtomicType_BYTES       AtomicType = 9
)

// Enum value maps for AtomicType.
var (
	AtomicType_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "BYTE",
		2: "INT16",
		3: "INT32",
		4: "INT64",
		5: "FLOAT",
		6: "DOUBLE",
		7: "STRING",
		8: "BOOLEAN",
		9: "BYTES",
	}
	AtomicType_value = map[string]int32{
		"UNSPECIFIED": 0,
		"BYTE":        1,
		"INT16":       2,
		"INT32":       3,
		"INT64":       4,
		"FLOAT":       5,
		"DOUBLE":      6,
		"STRING":      7,
		"BOOLEAN":     8,
		"BYTES":       9,
	}
)

func (x AtomicType) Enum() *AtomicType {
	p := new(AtomicType)
	*p = x
	return p
}

func (x AtomicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AtomicType) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_enumTypes[0].Descriptor()
}

func (AtomicType) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_schema_proto_enumTypes[0]
}

func (x AtomicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AtomicType.Descriptor instead.
func (AtomicType) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{0}
}

type LogicalTypes_Enum int32

const (
	// A URN for Python Callable logical type
	//   - Representation type: STRING
	//   - Language type: In Python SDK, PythonCallableWithSource.
	//     In any other SDKs, a wrapper object for a string which
	//     can be evaluated to a Python Callable object.
	LogicalTypes_PYTHON_CALLABLE LogicalTypes_Enum = 0
	// A URN for MicrosInstant type
	//   - Representation type: ROW<seconds: INT64, micros: INT64>
	//   - A timestamp without a timezone where seconds + micros represents the
	//     amount of time since the epoch.
	LogicalTypes_MICROS_INSTANT LogicalTypes_Enum = 1
	// A URN for MillisInstant type
	//   - Representation type: INT64
	//   - A timestamp without a timezone represented by the number of
	//     milliseconds since the epoch. The INT64 value is encoded with
	//     big-endian shifted such that lexicographic ordering of the bytes
	//     corresponds to chronological order.
	LogicalTypes_MILLIS_INSTANT LogicalTypes_Enum = 2
	// A URN for Decimal type
	//   - Representation type: BYTES
	//   - A decimal number with variable scale. Its BYTES
	//     representation consists of an integer (INT32) scale followed by a
	//     two's complement encoded big integer.
	LogicalTypes_DECIMAL LogicalTypes_Enum = 3
	// A URN for FixedLengthBytes type
	//   - Representation type: BYTES
	//   - Argument type: INT32.
	//     A fixed-length bytes with its length as the argument.
	LogicalTypes_FIXED_BYTES LogicalTypes_Enum = 4
	// A URN for VariableLengthBytes type
	//   - Representation type: BYTES
	//   - Argument type: INT32.
	//     A variable-length bytes with its maximum length as the argument.
	LogicalTypes_VAR_BYTES LogicalTypes_Enum = 5
	// A URN for FixedLengthString type
	//   - Representation type: STRING
	//   - Argument type: INT32.
	//     A fixed-length string with its length as the argument.
	LogicalTypes_FIXED_CHAR LogicalTypes_Enum = 6
	// A URN for VariableLengthString type
	//   - Representation type: STRING
	//   - Argument type: INT32.
	//     A variable-length string with its maximum length as the argument.
	LogicalTypes_VAR_CHAR LogicalTypes_Enum = 7
)

// Enum value maps for LogicalTypes_Enum.
var (
	LogicalTypes_Enum_name = map[int32]string{
		0: "PYTHON_CALLABLE",
		1: "MICROS_INSTANT",
		2: "MILLIS_INSTANT",
		3: "DECIMAL",
		4: "FIXED_BYTES",
		5: "VAR_BYTES",
		6: "FIXED_CHAR",
		7: "VAR_CHAR",
	}
	LogicalTypes_Enum_value = map[string]int32{
		"PYTHON_CALLABLE": 0,
		"MICROS_INSTANT":  1,
		"MILLIS_INSTANT":  2,
		"DECIMAL":         3,
		"FIXED_BYTES":     4,
		"VAR_BYTES":       5,
		"FIXED_CHAR":      6,
		"VAR_CHAR":        7,
	}
)

func (x LogicalTypes_Enum) Enum() *LogicalTypes_Enum {
	p := new(LogicalTypes_Enum)
	*p = x
	return p
}

func (x LogicalTypes_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogicalTypes_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_enumTypes[1].Descriptor()
}

func (LogicalTypes_Enum) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_schema_proto_enumTypes[1]
}

func (x LogicalTypes_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogicalTypes_Enum.Descriptor instead.
func (LogicalTypes_Enum) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{8, 0}
}

type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of fields for this schema. Two fields may not share a name.
	Fields []*Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	// REQUIRED. An RFC 4122 UUID.
	Id      string    `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Options []*Option `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
	// Indicates that encoding positions have been overridden.
	EncodingPositionsSet bool `protobuf:"varint,4,opt,name=encoding_positions_set,json=encodingPositionsSet,proto3" json:"encoding_positions_set,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{0}
}

func (x *Schema) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Schema) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Schema) GetOptions() []*Option {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Schema) GetEncodingPositionsSet() bool {
	if x != nil {
		return x.EncodingPositionsSet
	}
	return false
}

type Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Name of this field within the schema.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// OPTIONAL. Human readable description of this field, such as the query that generated it.
	Description string     `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	Type        *FieldType `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Id          int32      `protobuf:"varint,4,opt,name=id,proto3" json:"id,omitempty"`
	// OPTIONAL. The position of this field's data when encoded, e.g. with beam:coder:row:v1.
	// Either no fields in a given row are have encoding position populated,
	// or all of them are. Used to support backwards compatibility with schema
	// changes.
	// If no fields have encoding position populated the order of encoding is the same as the order in the Schema.
	// If this Field is part of a Schema where encoding_positions_set is True then encoding_position must be
	// defined, otherwise this field is ignored.
	EncodingPosition int32     `protobuf:"varint,5,opt,name=encoding_position,json=encodingPosition,proto3" json:"encoding_position,omitempty"`
	Options          []*Option `protobuf:"bytes,6,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *Field) Reset() {
	*x = Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{1}
}

func (x *Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Field) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Field) GetType() *FieldType {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Field) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Field) GetEncodingPosition() int32 {
	if x != nil {
		return x.EncodingPosition
	}
	return 0
}

func (x *Field) GetOptions() []*Option {
	if x != nil {
		return x.Options
	}
	return nil
}

type FieldType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nullable bool `protobuf:"varint,1,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// Types that are assignable to TypeInfo:
	//
	//	*FieldType_AtomicType
	//	*FieldType_ArrayType
	//	*FieldType_IterableType
	//	*FieldType_MapType
	//	*FieldType_RowType
	//	*FieldType_LogicalType
	TypeInfo isFieldType_TypeInfo `protobuf_oneof:"type_info"`
}

func (x *FieldType) Reset() {
	*x = FieldType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldType) ProtoMessage() {}

func (x *FieldType) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldType.ProtoReflect.Descriptor instead.
func (*FieldType) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{2}
}

func (x *FieldType) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (m *FieldType) GetTypeInfo() isFieldType_TypeInfo {
	if m != nil {
		return m.TypeInfo
	}
	return nil
}

func (x *FieldType) GetAtomicType() AtomicType {
	if x, ok := x.GetTypeInfo().(*FieldType_AtomicType); ok {
		return x.AtomicType
	}
	return AtomicType_UNSPECIFIED
}

func (x *FieldType) GetArrayType() *ArrayType {
	if x, ok := x.GetTypeInfo().(*FieldType_ArrayType); ok {
		return x.ArrayType
	}
	return nil
}

func (x *FieldType) GetIterableType() *IterableType {
	if x, ok := x.GetTypeInfo().(*FieldType_IterableType); ok {
		return x.IterableType
	}
	return nil
}

func (x *FieldType) GetMapType() *MapType {
	if x, ok := x.GetTypeInfo().(*FieldType_MapType); ok {
		return x.MapType
	}
	return nil
}

func (x *FieldType) GetRowType() *RowType {
	if x, ok := x.GetTypeInfo().(*FieldType_RowType); ok {
		return x.RowType
	}
	return nil
}

func (x *FieldType) GetLogicalType() *LogicalType {
	if x, ok := x.GetTypeInfo().(*FieldType_LogicalType); ok {
		return x.LogicalType
	}
	return nil
}

type isFieldType_TypeInfo interface {
	isFieldType_TypeInfo()
}

type FieldType_AtomicType struct {
	AtomicType AtomicType `protobuf:"varint,2,opt,name=atomic_type,json=atomicType,proto3,enum=org.apache.beam.model.pipeline.v1.AtomicType,oneof"`
}

type FieldType_ArrayType struct {
	ArrayType *ArrayType `protobuf:"bytes,3,opt,name=array_type,json=arrayType,proto3,oneof"`
}

type FieldType_IterableType struct {
	IterableType *IterableType `protobuf:"bytes,4,opt,name=iterable_type,json=iterableType,proto3,oneof"`
}

type FieldType_MapType struct {
	MapType *MapType `protobuf:"bytes,5,opt,name=map_type,json=mapType,proto3,oneof"`
}

type FieldType_RowType struct {
	RowType *RowType `protobuf:"bytes,6,opt,name=row_type,json=rowType,proto3,oneof"`
}

type FieldType_LogicalType struct {
	LogicalType *LogicalType `protobuf:"bytes,7,opt,name=logical_type,json=logicalType,proto3,oneof"`
}

func (*FieldType_AtomicType) isFieldType_TypeInfo() {}

func (*FieldType_ArrayType) isFieldType_TypeInfo() {}

func (*FieldType_IterableType) isFieldType_TypeInfo() {}

func (*FieldType_MapType) isFieldType_TypeInfo() {}

func (*FieldType_RowType) isFieldType_TypeInfo() {}

func (*FieldType_LogicalType) isFieldType_TypeInfo() {}

type ArrayType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ElementType *FieldType `protobuf:"bytes,1,opt,name=element_type,json=elementType,proto3" json:"element_type,omitempty"`
}

func (x *ArrayType) Reset() {
	*x = ArrayType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArrayType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayType) ProtoMessage() {}

func (x *ArrayType) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrayType.ProtoReflect.Descriptor instead.
func (*ArrayType) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{3}
}

func (x *ArrayType) GetElementType() *FieldType {
	if x != nil {
		return x.ElementType
	}
	return nil
}

type IterableType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ElementType *FieldType `protobuf:"bytes,1,opt,name=element_type,json=elementType,proto3" json:"element_type,omitempty"`
}

func (x *IterableType) Reset() {
	*x = IterableType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IterableType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IterableType) ProtoMessage() {}

func (x *IterableType) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IterableType.ProtoReflect.Descriptor instead.
func (*IterableType) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{4}
}

func (x *IterableType) GetElementType() *FieldType {
	if x != nil {
		return x.ElementType
	}
	return nil
}

type MapType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyType   *FieldType `protobuf:"bytes,1,opt,name=key_type,json=keyType,proto3" json:"key_type,omitempty"`
	ValueType *FieldType `protobuf:"bytes,2,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
}

func (x *MapType) Reset() {
	*x = MapType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapType) ProtoMessage() {}

func (x *MapType) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapType.ProtoReflect.Descriptor instead.
func (*MapType) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{5}
}

func (x *MapType) GetKeyType() *FieldType {
	if x != nil {
		return x.KeyType
	}
	return nil
}

func (x *MapType) GetValueType() *FieldType {
	if x != nil {
		return x.ValueType
	}
	return nil
}

type RowType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Schema *Schema `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *RowType) Reset() {
	*x = RowType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RowType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RowType) ProtoMessage() {}

func (x *RowType) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RowType.ProtoReflect.Descriptor instead.
func (*RowType) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{6}
}

func (x *RowType) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

type LogicalType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urn            string      `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	Payload        []byte      `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	Representation *FieldType  `protobuf:"bytes,3,opt,name=representation,proto3" json:"representation,omitempty"`
	ArgumentType   *FieldType  `protobuf:"bytes,4,opt,name=argument_type,json=argumentType,proto3" json:"argument_type,omitempty"`
	Argument       *FieldValue `protobuf:"bytes,5,opt,name=argument,proto3" json:"argument,omitempty"`
}

func (x *LogicalType) Reset() {
	*x = LogicalType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalType) ProtoMessage() {}

func (x *LogicalType) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalType.ProtoReflect.Descriptor instead.
func (*LogicalType) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{7}
}

func (x *LogicalType) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *LogicalType) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *LogicalType) GetRepresentation() *FieldType {
	if x != nil {
		return x.Representation
	}
	return nil
}

func (x *LogicalType) GetArgumentType() *FieldType {
	if x != nil {
		return x.ArgumentType
	}
	return nil
}

func (x *LogicalType) GetArgument() *FieldValue {
	if x != nil {
		return x.Argument
	}
	return nil
}

// Universally defined Logical types for Row schemas.
// These logical types are supposed to be understood by all SDKs.
type LogicalTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LogicalTypes) Reset() {
	*x = LogicalTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalTypes) ProtoMessage() {}

func (x *LogicalTypes) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalTypes.ProtoReflect.Descriptor instead.
func (*LogicalTypes) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{8}
}

type Option struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Identifier for the option.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Type specifier for the structure of value.
	// Conventionally, options that don't require additional configuration should
	// use a boolean type, with the value set to true.
	Type  *FieldType  `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Value *FieldValue `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Option) Reset() {
	*x = Option{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Option) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Option) ProtoMessage() {}

func (x *Option) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Option.ProtoReflect.Descriptor instead.
func (*Option) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{9}
}

func (x *Option) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Option) GetType() *FieldType {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Option) GetValue() *FieldValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []*FieldValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{10}
}

func (x *Row) GetValues() []*FieldValue {
	if x != nil {
		return x.Values
	}
	return nil
}

type FieldValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If none of these are set, value is considered null.
	//
	// Types that are assignable to FieldValue:
	//
	//	*FieldValue_AtomicValue
	//	*FieldValue_ArrayValue
	//	*FieldValue_IterableValue
	//	*FieldValue_MapValue
	//	*FieldValue_RowValue
	//	*FieldValue_LogicalTypeValue
	FieldValue isFieldValue_FieldValue `protobuf_oneof:"field_value"`
}

func (x *FieldValue) Reset() {
	*x = FieldValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldValue) ProtoMessage() {}

func (x *FieldValue) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldValue.ProtoReflect.Descriptor instead.
func (*FieldValue) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{11}
}

func (m *FieldValue) GetFieldValue() isFieldValue_FieldValue {
	if m != nil {
		return m.FieldValue
	}
	return nil
}

func (x *FieldValue) GetAtomicValue() *AtomicTypeValue {
	if x, ok := x.GetFieldValue().(*FieldValue_AtomicValue); ok {
		return x.AtomicValue
	}
	return nil
}

func (x *FieldValue) GetArrayValue() *ArrayTypeValue {
	if x, ok := x.GetFieldValue().(*FieldValue_ArrayValue); ok {
		return x.ArrayValue
	}
	return nil
}

func (x *FieldValue) GetIterableValue() *IterableTypeValue {
	if x, ok := x.GetFieldValue().(*FieldValue_IterableValue); ok {
		return x.IterableValue
	}
	return nil
}

func (x *FieldValue) GetMapValue() *MapTypeValue {
	if x, ok := x.GetFieldValue().(*FieldValue_MapValue); ok {
		return x.MapValue
	}
	return nil
}

func (x *FieldValue) GetRowValue() *Row {
	if x, ok := x.GetFieldValue().(*FieldValue_RowValue); ok {
		return x.RowValue
	}
	return nil
}

func (x *FieldValue) GetLogicalTypeValue() *LogicalTypeValue {
	if x, ok := x.GetFieldValue().(*FieldValue_LogicalTypeValue); ok {
		return x.LogicalTypeValue
	}
	return nil
}

type isFieldValue_FieldValue interface {
	isFieldValue_FieldValue()
}

type FieldValue_AtomicValue struct {
	AtomicValue *AtomicTypeValue `protobuf:"bytes,1,opt,name=atomic_value,json=atomicValue,proto3,oneof"`
}

type FieldValue_ArrayValue struct {
	ArrayValue *ArrayTypeValue `protobuf:"bytes,2,opt,name=array_value,json=arrayValue,proto3,oneof"`
}

type FieldValue_IterableValue struct {
	IterableValue *IterableTypeValue `protobuf:"bytes,3,opt,name=iterable_value,json=iterableValue,proto3,oneof"`
}

type FieldValue_MapValue struct {
	MapValue *MapTypeValue `protobuf:"bytes,4,opt,name=map_value,json=mapValue,proto3,oneof"`
}

type FieldValue_RowValue struct {
	RowValue *Row `protobuf:"bytes,5,opt,name=row_value,json=rowValue,proto3,oneof"`
}

type FieldValue_LogicalTypeValue struct {
	LogicalTypeValue *LogicalTypeValue `protobuf:"bytes,6,opt,name=logical_type_value,json=logicalTypeValue,proto3,oneof"`
}

func (*FieldValue_AtomicValue) isFieldValue_FieldValue() {}

func (*FieldValue_ArrayValue) isFieldValue_FieldValue() {}

func (*FieldValue_IterableValue) isFieldValue_FieldValue() {}

func (*FieldValue_MapValue) isFieldValue_FieldValue() {}

func (*FieldValue_RowValue) isFieldValue_FieldValue() {}

func (*FieldValue_LogicalTypeValue) isFieldValue_FieldValue() {}

type AtomicTypeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*AtomicTypeValue_Byte
	//	*AtomicTypeValue_Int16
	//	*AtomicTypeValue_Int32
	//	*AtomicTypeValue_Int64
	//	*AtomicTypeValue_Float
	//	*AtomicTypeValue_Double
	//	*AtomicTypeValue_String_
	//	*AtomicTypeValue_Boolean
	//	*AtomicTypeValue_Bytes
	Value isAtomicTypeValue_Value `protobuf_oneof:"value"`
}

func (x *AtomicTypeValue) Reset() {
	*x = AtomicTypeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AtomicTypeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AtomicTypeValue) ProtoMessage() {}

func (x *AtomicTypeValue) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AtomicTypeValue.ProtoReflect.Descriptor instead.
func (*AtomicTypeValue) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{12}
}

func (m *AtomicTypeValue) GetValue() isAtomicTypeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AtomicTypeValue) GetByte() int32 {
	if x, ok := x.GetValue().(*AtomicTypeValue_Byte); ok {
		return x.Byte
	}
	return 0
}

func (x *AtomicTypeValue) GetInt16() int32 {
	if x, ok := x.GetValue().(*AtomicTypeValue_Int16); ok {
		return x.Int16
	}
	return 0
}

func (x *AtomicTypeValue) GetInt32() int32 {
	if x, ok := x.GetValue().(*AtomicTypeValue_Int32); ok {
		return x.Int32
	}
	return 0
}

func (x *AtomicTypeValue) GetInt64() int64 {
	if x, ok := x.GetValue().(*AtomicTypeValue_Int64); ok {
		return x.Int64
	}
	return 0
}

func (x *AtomicTypeValue) GetFloat() float32 {
	if x, ok := x.GetValue().(*AtomicTypeValue_Float); ok {
		return x.Float
	}
	return 0
}

func (x *AtomicTypeValue) GetDouble() float64 {
	if x, ok := x.GetValue().(*AtomicTypeValue_Double); ok {
		return x.Double
	}
	return 0
}

func (x *AtomicTypeValue) GetString_() string {
	if x, ok := x.GetValue().(*AtomicTypeValue_String_); ok {
		return x.String_
	}
	return ""
}

func (x *AtomicTypeValue) GetBoolean() bool {
	if x, ok := x.GetValue().(*AtomicTypeValue_Boolean); ok {
		return x.Boolean
	}
	return false
}

func (x *AtomicTypeValue) GetBytes() []byte {
	if x, ok := x.GetValue().(*AtomicTypeValue_Bytes); ok {
		return x.Bytes
	}
	return nil
}

type isAtomicTypeValue_Value interface {
	isAtomicTypeValue_Value()
}

type AtomicTypeValue_Byte struct {
	Byte int32 `protobuf:"varint,1,opt,name=byte,proto3,oneof"`
}

type AtomicTypeValue_Int16 struct {
	Int16 int32 `protobuf:"varint,2,opt,name=int16,proto3,oneof"`
}

type AtomicTypeValue_Int32 struct {
	Int32 int32 `protobuf:"varint,3,opt,name=int32,proto3,oneof"`
}

type AtomicTypeValue_Int64 struct {
	Int64 int64 `protobuf:"varint,4,opt,name=int64,proto3,oneof"`
}

type AtomicTypeValue_Float struct {
	Float float32 `protobuf:"fixed32,5,opt,name=float,proto3,oneof"`
}

type AtomicTypeValue_Double struct {
	Double float64 `protobuf:"fixed64,6,opt,name=double,proto3,oneof"`
}

type AtomicTypeValue_String_ struct {
	String_ string `protobuf:"bytes,7,opt,name=string,proto3,oneof"`
}

type AtomicTypeValue_Boolean struct {
	Boolean bool `protobuf:"varint,8,opt,name=boolean,proto3,oneof"`
}

type AtomicTypeValue_Bytes struct {
	Bytes []byte `protobuf:"bytes,9,opt,name=bytes,proto3,oneof"`
}

func (*AtomicTypeValue_Byte) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Int16) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Int32) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Int64) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Float) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Double) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_String_) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Boolean) isAtomicTypeValue_Value() {}

func (*AtomicTypeValue_Bytes) isAtomicTypeValue_Value() {}

type ArrayTypeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Element []*FieldValue `protobuf:"bytes,1,rep,name=element,proto3" json:"element,omitempty"`
}

func (x *ArrayTypeValue) Reset() {
	*x = ArrayTypeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArrayTypeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayTypeValue) ProtoMessage() {}

func (x *ArrayTypeValue) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrayTypeValue.ProtoReflect.Descriptor instead.
func (*ArrayTypeValue) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{13}
}

func (x *ArrayTypeValue) GetElement() []*FieldValue {
	if x != nil {
		return x.Element
	}
	return nil
}

type IterableTypeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Element []*FieldValue `protobuf:"bytes,1,rep,name=element,proto3" json:"element,omitempty"`
}

func (x *IterableTypeValue) Reset() {
	*x = IterableTypeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IterableTypeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IterableTypeValue) ProtoMessage() {}

func (x *IterableTypeValue) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IterableTypeValue.ProtoReflect.Descriptor instead.
func (*IterableTypeValue) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{14}
}

func (x *IterableTypeValue) GetElement() []*FieldValue {
	if x != nil {
		return x.Element
	}
	return nil
}

type MapTypeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entries []*MapTypeEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *MapTypeValue) Reset() {
	*x = MapTypeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapTypeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapTypeValue) ProtoMessage() {}

func (x *MapTypeValue) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapTypeValue.ProtoReflect.Descriptor instead.
func (*MapTypeValue) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{15}
}

func (x *MapTypeValue) GetEntries() []*MapTypeEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type MapTypeEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *FieldValue `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value *FieldValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *MapTypeEntry) Reset() {
	*x = MapTypeEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapTypeEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapTypeEntry) ProtoMessage() {}

func (x *MapTypeEntry) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapTypeEntry.ProtoReflect.Descriptor instead.
func (*MapTypeEntry) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{16}
}

func (x *MapTypeEntry) GetKey() *FieldValue {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *MapTypeEntry) GetValue() *FieldValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type LogicalTypeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value *FieldValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *LogicalTypeValue) Reset() {
	*x = LogicalTypeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalTypeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalTypeValue) ProtoMessage() {}

func (x *LogicalTypeValue) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalTypeValue.ProtoReflect.Descriptor instead.
func (*LogicalTypeValue) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP(), []int{17}
}

func (x *LogicalTypeValue) GetValue() *FieldValue {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_org_apache_beam_model_pipeline_v1_schema_proto protoreflect.FileDescriptor

var file_org_apache_beam_model_pipeline_v1_schema_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61,
	0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x1a, 0x37, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f,
	0x62, 0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x75, 0x6e, 0x6e,
	0x65, 0x72, 0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd5, 0x01, 0x0a,
	0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x40, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34,
	0x0a, 0x16, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x53, 0x65, 0x74, 0x22, 0x81, 0x02, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x94, 0x04, 0x0a, 0x09, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x6f, 0x6d,
	0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x72,
	0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x72, 0x72, 0x61, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x0d, 0x69, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x6d,
	0x61, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x72, 0x6f, 0x77, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x54, 0x79,
	0x70, 0x65, 0x48, 0x00, 0x52, 0x07, 0x72, 0x6f, 0x77, 0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a,
	0x0c, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22,
	0x5c, 0x0a, 0x09, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a, 0x0c,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0b, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x5f, 0x0a,
	0x0c, 0x49, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a,
	0x0c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0b, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x9f,
	0x01, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x6b, 0x65,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x4c, 0x0a, 0x07, 0x52, 0x6f, 0x77, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0xad,
	0x02, 0x0a, 0x0b, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x54, 0x0a, 0x0e, 0x72, 0x65,
	0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x51, 0x0a, 0x0d, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xdf,
	0x03, 0x0a, 0x0c, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22,
	0xce, 0x03, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x3f, 0x0a, 0x0f, 0x50, 0x59, 0x54, 0x48,
	0x4f, 0x4e, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x00, 0x1a, 0x2a, 0xa2,
	0xb4, 0xfa, 0xc2, 0x05, 0x24, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x3d, 0x0a, 0x0e, 0x4d, 0x49, 0x43,
	0x52, 0x4f, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x54, 0x10, 0x01, 0x1a, 0x29, 0xa2,
	0xb4, 0xfa, 0xc2, 0x05, 0x23, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x3a, 0x76, 0x31, 0x12, 0x3d, 0x0a, 0x0e, 0x4d, 0x49, 0x4c, 0x4c,
	0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x54, 0x10, 0x02, 0x1a, 0x29, 0xa2, 0xb4,
	0xfa, 0xc2, 0x05, 0x23, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x3a, 0x76, 0x31, 0x12, 0x2f, 0x0a, 0x07, 0x44, 0x45, 0x43, 0x49, 0x4d,
	0x41, 0x4c, 0x10, 0x03, 0x1a, 0x22, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1c, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x64, 0x65,
	0x63, 0x69, 0x6d, 0x61, 0x6c, 0x3a, 0x76, 0x31, 0x12, 0x37, 0x0a, 0x0b, 0x46, 0x49, 0x58, 0x45,
	0x44, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x04, 0x1a, 0x26, 0xa2, 0xb4, 0xfa, 0xc2, 0x05,
	0x20, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x3a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x3a, 0x76,
	0x31, 0x12, 0x33, 0x0a, 0x09, 0x56, 0x41, 0x52, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x05,
	0x1a, 0x24, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67,
	0x69, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x76, 0x61, 0x72, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x35, 0x0a, 0x0a, 0x46, 0x49, 0x58, 0x45, 0x44, 0x5f,
	0x43, 0x48, 0x41, 0x52, 0x10, 0x06, 0x1a, 0x25, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1f, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a,
	0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x3a, 0x76, 0x31, 0x12, 0x31, 0x0a,
	0x08, 0x56, 0x41, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10, 0x07, 0x1a, 0x23, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x3a, 0x76, 0x61, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x3a, 0x76, 0x31,
	0x22, 0xa3, 0x01, 0x0a, 0x06, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x4c, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x45, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x22, 0xa5, 0x04, 0x0a, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74,
	0x6f, 0x6d, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52,
	0x0b, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x54, 0x0a, 0x0b,
	0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x69, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x0d, 0x69, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x4e, 0x0a, 0x09, 0x6d, 0x61, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x45, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x08,
	0x72, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x63, 0x0a, 0x12, 0x6c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x6f, 0x67,
	0x69, 0x63, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xf8, 0x01, 0x0a,
	0x0f, 0x41, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x14, 0x0a, 0x04, 0x62, 0x79, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00,
	0x52, 0x04, 0x62, 0x79, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x69, 0x6e, 0x74, 0x31, 0x36, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6e, 0x74, 0x31, 0x36, 0x12, 0x16,
	0x0a, 0x05, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x05, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x12, 0x16, 0x0a, 0x05, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x12, 0x16,
	0x0a, 0x05, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52,
	0x05, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x12, 0x18, 0x0a, 0x06, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x06, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x12, 0x18, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x07, 0x62, 0x6f,
	0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x62,
	0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x12, 0x16, 0x0a, 0x05, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x05, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x07,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x59, 0x0a, 0x0e, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x5c, 0x0a, 0x11, 0x49, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x59, 0x0a, 0x0c, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x49, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x94, 0x01, 0x0a, 0x0c,
	0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x57, 0x0a, 0x10, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2a, 0x83, 0x01, 0x0a, 0x0a,
	0x41, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42,
	0x59, 0x54, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x31, 0x36, 0x10, 0x02,
	0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x33, 0x32, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x49,
	0x4e, 0x54, 0x36, 0x34, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10,
	0x05, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x06, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f,
	0x4c, 0x45, 0x41, 0x4e, 0x10, 0x08, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10,
	0x09, 0x42, 0x78, 0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x41, 0x70,
	0x69, 0x5a, 0x48, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x73, 0x64, 0x6b, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x31, 0x3b,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescOnce sync.Once
	file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescData = file_org_apache_beam_model_pipeline_v1_schema_proto_rawDesc
)

func file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescGZIP() []byte {
	file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescOnce.Do(func() {
		file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescData = protoimpl.X.CompressGZIP(file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescData)
	})
	return file_org_apache_beam_model_pipeline_v1_schema_proto_rawDescData
}

var file_org_apache_beam_model_pipeline_v1_schema_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_org_apache_beam_model_pipeline_v1_schema_proto_goTypes = []interface{}{
	(AtomicType)(0),           // 0: org.apache.beam.model.pipeline.v1.AtomicType
	(LogicalTypes_Enum)(0),    // 1: org.apache.beam.model.pipeline.v1.LogicalTypes.Enum
	(*Schema)(nil),            // 2: org.apache.beam.model.pipeline.v1.Schema
	(*Field)(nil),             // 3: org.apache.beam.model.pipeline.v1.Field
	(*FieldType)(nil),         // 4: org.apache.beam.model.pipeline.v1.FieldType
	(*ArrayType)(nil),         // 5: org.apache.beam.model.pipeline.v1.ArrayType
	(*IterableType)(nil),      // 6: org.apache.beam.model.pipeline.v1.IterableType
	(*MapType)(nil),           // 7: org.apache.beam.model.pipeline.v1.MapType
	(*RowType)(nil),           // 8: org.apache.beam.model.pipeline.v1.RowType
	(*LogicalType)(nil),       // 9: org.apache.beam.model.pipeline.v1.LogicalType
	(*LogicalTypes)(nil),      // 10: org.apache.beam.model.pipeline.v1.LogicalTypes
	(*Option)(nil),            // 11: org.apache.beam.model.pipeline.v1.Option
	(*Row)(nil),               // 12: org.apache.beam.model.pipeline.v1.Row
	(*FieldValue)(nil),        // 13: org.apache.beam.model.pipeline.v1.FieldValue
	(*AtomicTypeValue)(nil),   // 14: org.apache.beam.model.pipeline.v1.AtomicTypeValue
	(*ArrayTypeValue)(nil),    // 15: org.apache.beam.model.pipeline.v1.ArrayTypeValue
	(*IterableTypeValue)(nil), // 16: org.apache.beam.model.pipeline.v1.IterableTypeValue
	(*MapTypeValue)(nil),      // 17: org.apache.beam.model.pipeline.v1.MapTypeValue
	(*MapTypeEntry)(nil),      // 18: org.apache.beam.model.pipeline.v1.MapTypeEntry
	(*LogicalTypeValue)(nil),  // 19: org.apache.beam.model.pipeline.v1.LogicalTypeValue
}
var file_org_apache_beam_model_pipeline_v1_schema_proto_depIdxs = []int32{
	3,  // 0: org.apache.beam.model.pipeline.v1.Schema.fields:type_name -> org.apache.beam.model.pipeline.v1.Field
	11, // 1: org.apache.beam.model.pipeline.v1.Schema.options:type_name -> org.apache.beam.model.pipeline.v1.Option
	4,  // 2: org.apache.beam.model.pipeline.v1.Field.type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	11, // 3: org.apache.beam.model.pipeline.v1.Field.options:type_name -> org.apache.beam.model.pipeline.v1.Option
	0,  // 4: org.apache.beam.model.pipeline.v1.FieldType.atomic_type:type_name -> org.apache.beam.model.pipeline.v1.AtomicType
	5,  // 5: org.apache.beam.model.pipeline.v1.FieldType.array_type:type_name -> org.apache.beam.model.pipeline.v1.ArrayType
	6,  // 6: org.apache.beam.model.pipeline.v1.FieldType.iterable_type:type_name -> org.apache.beam.model.pipeline.v1.IterableType
	7,  // 7: org.apache.beam.model.pipeline.v1.FieldType.map_type:type_name -> org.apache.beam.model.pipeline.v1.MapType
	8,  // 8: org.apache.beam.model.pipeline.v1.FieldType.row_type:type_name -> org.apache.beam.model.pipeline.v1.RowType
	9,  // 9: org.apache.beam.model.pipeline.v1.FieldType.logical_type:type_name -> org.apache.beam.model.pipeline.v1.LogicalType
	4,  // 10: org.apache.beam.model.pipeline.v1.ArrayType.element_type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	4,  // 11: org.apache.beam.model.pipeline.v1.IterableType.element_type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	4,  // 12: org.apache.beam.model.pipeline.v1.MapType.key_type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	4,  // 13: org.apache.beam.model.pipeline.v1.MapType.value_type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	2,  // 14: org.apache.beam.model.pipeline.v1.RowType.schema:type_name -> org.apache.beam.model.pipeline.v1.Schema
	4,  // 15: org.apache.beam.model.pipeline.v1.LogicalType.representation:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	4,  // 16: org.apache.beam.model.pipeline.v1.LogicalType.argument_type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	13, // 17: org.apache.beam.model.pipeline.v1.LogicalType.argument:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	4,  // 18: org.apache.beam.model.pipeline.v1.Option.type:type_name -> org.apache.beam.model.pipeline.v1.FieldType
	13, // 19: org.apache.beam.model.pipeline.v1.Option.value:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	13, // 20: org.apache.beam.model.pipeline.v1.Row.values:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	14, // 21: org.apache.beam.model.pipeline.v1.FieldValue.atomic_value:type_name -> org.apache.beam.model.pipeline.v1.AtomicTypeValue
	15, // 22: org.apache.beam.model.pipeline.v1.FieldValue.array_value:type_name -> org.apache.beam.model.pipeline.v1.ArrayTypeValue
	16, // 23: org.apache.beam.model.pipeline.v1.FieldValue.iterable_value:type_name -> org.apache.beam.model.pipeline.v1.IterableTypeValue
	17, // 24: org.apache.beam.model.pipeline.v1.FieldValue.map_value:type_name -> org.apache.beam.model.pipeline.v1.MapTypeValue
	12, // 25: org.apache.beam.model.pipeline.v1.FieldValue.row_value:type_name -> org.apache.beam.model.pipeline.v1.Row
	19, // 26: org.apache.beam.model.pipeline.v1.FieldValue.logical_type_value:type_name -> org.apache.beam.model.pipeline.v1.LogicalTypeValue
	13, // 27: org.apache.beam.model.pipeline.v1.ArrayTypeValue.element:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	13, // 28: org.apache.beam.model.pipeline.v1.IterableTypeValue.element:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	18, // 29: org.apache.beam.model.pipeline.v1.MapTypeValue.entries:type_name -> org.apache.beam.model.pipeline.v1.MapTypeEntry
	13, // 30: org.apache.beam.model.pipeline.v1.MapTypeEntry.key:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	13, // 31: org.apache.beam.model.pipeline.v1.MapTypeEntry.value:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	13, // 32: org.apache.beam.model.pipeline.v1.LogicalTypeValue.value:type_name -> org.apache.beam.model.pipeline.v1.FieldValue
	33, // [33:33] is the sub-list for method output_type
	33, // [33:33] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_org_apache_beam_model_pipeline_v1_schema_proto_init() }
func file_org_apache_beam_model_pipeline_v1_schema_proto_init() {
	if File_org_apache_beam_model_pipeline_v1_schema_proto != nil {
		return
	}
	file_org_apache_beam_model_pipeline_v1_beam_runner_api_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArrayType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IterableType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RowType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalTypes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Option); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AtomicTypeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArrayTypeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IterableTypeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapTypeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapTypeEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalTypeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*FieldType_AtomicType)(nil),
		(*FieldType_ArrayType)(nil),
		(*FieldType_IterableType)(nil),
		(*FieldType_MapType)(nil),
		(*FieldType_RowType)(nil),
		(*FieldType_LogicalType)(nil),
	}
	file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*FieldValue_AtomicValue)(nil),
		(*FieldValue_ArrayValue)(nil),
		(*FieldValue_IterableValue)(nil),
		(*FieldValue_MapValue)(nil),
		(*FieldValue_RowValue)(nil),
		(*FieldValue_LogicalTypeValue)(nil),
	}
	file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*AtomicTypeValue_Byte)(nil),
		(*AtomicTypeValue_Int16)(nil),
		(*AtomicTypeValue_Int32)(nil),
		(*AtomicTypeValue_Int64)(nil),
		(*AtomicTypeValue_Float)(nil),
		(*AtomicTypeValue_Double)(nil),
		(*AtomicTypeValue_String_)(nil),
		(*AtomicTypeValue_Boolean)(nil),
		(*AtomicTypeValue_Bytes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_org_apache_beam_model_pipeline_v1_schema_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_org_apache_beam_model_pipeline_v1_schema_proto_goTypes,
		DependencyIndexes: file_org_apache_beam_model_pipeline_v1_schema_proto_depIdxs,
		EnumInfos:         file_org_apache_beam_model_pipeline_v1_schema_proto_enumTypes,
		MessageInfos:      file_org_apache_beam_model_pipeline_v1_schema_proto_msgTypes,
	}.Build()
	File_org_apache_beam_model_pipeline_v1_schema_proto = out.File
	file_org_apache_beam_model_pipeline_v1_schema_proto_rawDesc = nil
	file_org_apache_beam_model_pipeline_v1_schema_proto_goTypes = nil
	file_org_apache_beam_model_pipeline_v1_schema_proto_depIdxs = nil
}
