/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAccessor;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerReader;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.BKDistributedLogNamespace;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.BookKeeperClientBuilder;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.MetadataAccessor;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.auditor.DLAuditor;
import org.apache.distributedlog.bk.LedgerAllocator;
import org.apache.distributedlog.bk.LedgerAllocatorUtils;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.LogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.apache.distributedlog.tools.Tool;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLogTool
extends Tool {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLogTool.class);
    static final List<String> EMPTY_LIST = Lists.newArrayList();
    static final Comparator<LogSegmentMetadata> LOGSEGMENT_COMPARATOR_BY_TIME = new Comparator<LogSegmentMetadata>(){

        @Override
        public int compare(LogSegmentMetadata o1, LogSegmentMetadata o2) {
            if (o1.isInProgress() && o2.isInProgress()) {
                return DistributedLogTool.compareByCompletionTime(o1.getFirstTxId(), o2.getFirstTxId());
            }
            if (!o1.isInProgress() && !o2.isInProgress()) {
                return DistributedLogTool.compareByCompletionTime(o1.getCompletionTime(), o2.getCompletionTime());
            }
            if (o1.isInProgress() && !o2.isInProgress()) {
                return DistributedLogTool.compareByCompletionTime(o1.getFirstTxId(), o2.getCompletionTime());
            }
            return DistributedLogTool.compareByCompletionTime(o1.getCompletionTime(), o2.getFirstTxId());
        }
    };

    static int compareByCompletionTime(long time1, long time2) {
        return time1 > time2 ? 1 : (time1 < time2 ? -1 : 0);
    }

    static DLSN parseDLSN(String dlsnStr) throws ParseException {
        if (dlsnStr.equals("InitialDLSN")) {
            return DLSN.InitialDLSN;
        }
        String[] parts = dlsnStr.split(",");
        if (parts.length != 3) {
            throw new ParseException("Invalid dlsn : " + dlsnStr);
        }
        try {
            return new DLSN(Long.parseLong(parts[0]), Long.parseLong(parts[1]), Long.parseLong(parts[2]));
        }
        catch (Exception nfe) {
            throw new ParseException("Invalid dlsn : " + dlsnStr);
        }
    }

    public DistributedLogTool() {
        this.addCommand(new AuditBKSpaceCommand());
        this.addCommand(new AuditLedgersCommand());
        this.addCommand(new AuditDLSpaceCommand());
        this.addCommand(new CreateCommand());
        this.addCommand(new CountCommand());
        this.addCommand(new DeleteCommand());
        this.addCommand(new DeleteAllocatorPoolCommand());
        this.addCommand(new DeleteLedgersCommand());
        this.addCommand(new DumpCommand());
        this.addCommand(new FindLedgerCommand());
        this.addCommand(new InspectCommand());
        this.addCommand(new InspectStreamCommand());
        this.addCommand(new ListCommand());
        this.addCommand(new ReadLastConfirmedCommand());
        this.addCommand(new ReadEntriesCommand());
        this.addCommand(new RecoverLedgerCommand());
        this.addCommand(new ShowCommand());
        this.addCommand(new TruncateCommand());
        this.addCommand(new TruncateStreamCommand());
        this.addCommand(new DeserializeDLSNCommand());
        this.addCommand(new SerializeDLSNCommand());
        this.addCommand(new WatchNamespaceCommand());
        this.addCommand(new DeleteSubscriberCommand());
    }

    @Override
    protected String getName() {
        return "dlog_tool";
    }

    public static class DeleteSubscriberCommand
    extends PerDLCommand {
        int numThreads = 1;
        String streamPrefix = null;
        String subscriberId = null;

        DeleteSubscriberCommand() {
            super("delete_subscriber", "Delete the subscriber in subscription store. ");
            this.options.addOption("s", "subscriberId", true, "SubscriberId to remove from the stream");
            this.options.addOption("t", "threads", true, "Number of threads");
            this.options.addOption("ft", "filter", true, "Stream filter by prefix");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("s")) {
                throw new ParseException("No subscriberId provided.");
            }
            this.subscriberId = cmdline.getOptionValue("s");
            if (cmdline.hasOption("t")) {
                this.numThreads = Integer.parseInt(cmdline.getOptionValue("t"));
            }
            if (cmdline.hasOption("ft")) {
                this.streamPrefix = cmdline.getOptionValue("ft");
            }
        }

        @Override
        protected String getUsage() {
            return "delete_subscriber [options]";
        }

        @Override
        protected int runCmd() throws Exception {
            this.getConf().setZkAclId(this.getZkAclId());
            return this.deleteSubscriber(this.getNamespace());
        }

        private int deleteSubscriber(final Namespace namespace) throws Exception {
            int i;
            Iterator<String> streamCollection = namespace.getLogs();
            final ArrayList<String> streams = new ArrayList<String>();
            while (streamCollection.hasNext()) {
                String s = streamCollection.next();
                if (null != this.streamPrefix) {
                    if (!s.startsWith(this.streamPrefix)) continue;
                    streams.add(s);
                    continue;
                }
                streams.add(s);
            }
            if (0 == streams.size()) {
                return 0;
            }
            System.out.println("Streams : " + streams);
            if (!this.getForce() && !IOUtils.confirmPrompt((String)("Do you want to delete subscriber " + this.subscriberId + " for " + streams.size() + " streams ?"))) {
                return 0;
            }
            this.numThreads = Math.min(streams.size(), this.numThreads);
            final int numStreamsPerThreads = streams.size() / this.numThreads + 1;
            Thread[] threads = new Thread[this.numThreads];
            for (i = 0; i < this.numThreads; ++i) {
                final int tid = i;
                threads[i] = new Thread("RemoveSubscriberThread-" + i){

                    @Override
                    public void run() {
                        try {
                            this.deleteSubscriber(namespace, streams, tid, numStreamsPerThreads);
                            System.out.println("Thread " + tid + " finished.");
                        }
                        catch (Exception e) {
                            System.err.println("Thread " + tid + " quits with exception : " + e.getMessage());
                        }
                    }
                };
                threads[i].start();
            }
            for (i = 0; i < this.numThreads; ++i) {
                threads[i].join();
            }
            return 0;
        }

        private void deleteSubscriber(Namespace namespace, List<String> streams, int tid, int numStreamsPerThreads) throws Exception {
            int startIdx = tid * numStreamsPerThreads;
            int endIdx = Math.min(streams.size(), (tid + 1) * numStreamsPerThreads);
            for (int i = startIdx; i < endIdx; ++i) {
                final String s = streams.get(i);
                DistributedLogManager dlm = namespace.openLog(s);
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                dlm.getSubscriptionsStore().deleteSubscriber(this.subscriberId).whenComplete((BiConsumer)new FutureEventListener<Boolean>(){

                    public void onFailure(Throwable cause) {
                        System.out.println("Failed to delete subscriber for stream " + s);
                        cause.printStackTrace();
                        countDownLatch.countDown();
                    }

                    public void onSuccess(Boolean value) {
                        countDownLatch.countDown();
                    }
                });
                countDownLatch.await();
                dlm.close();
            }
        }
    }

    public static class SerializeDLSNCommand
    extends SimpleCommand {
        private DLSN dlsn = DLSN.InitialDLSN;
        private boolean hex = false;

        SerializeDLSNCommand() {
            super("serialize_dlsn", "Serialize DLSN. Default format is base64 string.");
            this.options.addOption("dlsn", true, "DLSN in comma separated format to serialize");
            this.options.addOption("x", "hex", false, "Emit hex-encoded string DLSN instead of base 64");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (cmdline.hasOption("dlsn")) {
                this.dlsn = DistributedLogTool.parseDLSN(cmdline.getOptionValue("dlsn"));
            }
            this.hex = cmdline.hasOption("x");
        }

        @Override
        protected int runSimpleCmd() throws Exception {
            if (this.hex) {
                byte[] bytes = this.dlsn.serializeBytes();
                String hexString = Hex.encodeHexString((byte[])bytes);
                System.out.println(hexString);
            } else {
                System.out.println(this.dlsn.serialize());
            }
            return 0;
        }
    }

    public static class DeserializeDLSNCommand
    extends SimpleCommand {
        String base64Dlsn = "";

        DeserializeDLSNCommand() {
            super("deserialize_dlsn", "Deserialize DLSN");
            this.options.addOption("b64", "base64", true, "Base64 encoded dlsn");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (!cmdline.hasOption("b64")) {
                throw new IllegalArgumentException("Argument b64 is required");
            }
            this.base64Dlsn = cmdline.getOptionValue("b64");
        }

        @Override
        protected int runSimpleCmd() throws Exception {
            System.out.println(DLSN.deserialize((String)this.base64Dlsn));
            return 0;
        }
    }

    protected static class TruncateStreamCommand
    extends PerStreamCommand {
        DLSN dlsn = DLSN.InvalidDLSN;

        TruncateStreamCommand() {
            super("truncate_stream", "truncate a stream at a specific position");
            this.options.addOption("dlsn", true, "Truncate all records older than this dlsn");
        }

        public void setDlsn(DLSN dlsn) {
            this.dlsn = dlsn;
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("dlsn")) {
                this.dlsn = DistributedLogTool.parseDLSN(cmdline.getOptionValue("dlsn"));
            }
        }

        @Override
        protected int runCmd() throws Exception {
            this.getConf().setZkAclId(this.getZkAclId());
            return this.truncateStream(this.getNamespace(), this.getStreamName(), this.dlsn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int truncateStream(Namespace namespace, String streamName, DLSN dlsn) throws Exception {
            try (DistributedLogManager dlm = namespace.openLog(streamName);){
                int n;
                long totalRecords = dlm.getLogRecordCount();
                long recordsAfterTruncate = (Long)FutureUtils.result(dlm.getLogRecordCountAsync(dlsn));
                long recordsToTruncate = totalRecords - recordsAfterTruncate;
                if (!this.getForce() && !IOUtils.confirmPrompt((String)("Do you want to truncate " + streamName + " at dlsn " + dlsn + " (" + recordsToTruncate + " records)?"))) {
                    int n2 = 0;
                    return n2;
                }
                AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
                try {
                    if (!((Boolean)FutureUtils.result(writer.truncate(dlsn))).booleanValue()) {
                        System.out.println("Failed to truncate.");
                    }
                    n = 0;
                }
                catch (Throwable throwable) {
                    try {
                        Utils.close(writer);
                        throw throwable;
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to truncate " + ex);
                        int n3 = 1;
                        return n3;
                    }
                }
                Utils.close(writer);
                return n;
            }
        }
    }

    public static class AuditBKSpaceCommand
    extends PerDLCommand {
        AuditBKSpaceCommand() {
            super("audit_bk_space", "Audit bk space usage for a given dl uri");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            try (DLAuditor dlAuditor = new DLAuditor(this.getConf());){
                long spaceUsage = dlAuditor.calculateLedgerSpaceUsage(this.uri);
                System.out.println("bookkeeper ledgers space usage \t " + spaceUsage);
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "audit_bk_space [options]";
        }
    }

    public static class AuditDLSpaceCommand
    extends PerDLCommand {
        private String regex = null;

        AuditDLSpaceCommand() {
            super("audit_dl_space", "Audit stream space usage for a given dl uri");
            this.options.addOption("groupByRegex", true, "Group by the result of applying the regex to stream name");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("groupByRegex")) {
                this.regex = cmdline.getOptionValue("groupByRegex");
            }
        }

        @Override
        protected int runCmd() throws Exception {
            try (DLAuditor dlAuditor = new DLAuditor(this.getConf());){
                Map<String, Long> streamSpaceMap = dlAuditor.calculateStreamSpaceUsage(this.getUri());
                if (null != this.regex) {
                    this.printGroupByRegexSpaceUsage(streamSpaceMap, this.regex);
                } else {
                    this.printSpaceUsage(streamSpaceMap);
                }
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "audit_dl_space [options]";
        }

        private void printSpaceUsage(Map<String, Long> spaceMap) throws Exception {
            for (Map.Entry<String, Long> entry : spaceMap.entrySet()) {
                System.out.println(entry.getKey() + "\t" + entry.getValue());
            }
        }

        private void printGroupByRegexSpaceUsage(Map<String, Long> streamSpaceMap, String regex) throws Exception {
            Pattern pattern = Pattern.compile(regex);
            HashMap<String, Long> groupedUsageMap = new HashMap<String, Long>();
            for (Map.Entry<String, Long> entry : streamSpaceMap.entrySet()) {
                Matcher matcher = pattern.matcher(entry.getKey());
                String key = entry.getKey();
                boolean matches = matcher.matches();
                if (matches) {
                    key = matcher.group(1);
                }
                Long value = entry.getValue();
                if (groupedUsageMap.containsKey(key)) {
                    value = value + (Long)groupedUsageMap.get(key);
                }
                groupedUsageMap.put(key, value);
            }
            this.printSpaceUsage(groupedUsageMap);
        }
    }

    static class AuditLedgersCommand
    extends AuditCommand {
        String ledgersFilePrefix;
        final List<List<String>> allocationPaths = new ArrayList<List<String>>();

        AuditLedgersCommand() {
            super("audit_ledgers", "Audit ledgers between bookkeeper and DL uris");
            this.options.addOption("lf", "ledgers-file", true, "Prefix of filename to store ledgers");
            this.options.addOption("ap", "allocation-paths", true, "Allocation paths per uri. E.g ap10;ap11,ap20");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("lf")) {
                throw new ParseException("No file specified to store leak ledgers");
            }
            this.ledgersFilePrefix = cmdline.getOptionValue("lf");
            if (cmdline.hasOption("ap")) {
                String[] aps;
                for (String ap : aps = cmdline.getOptionValue("ap").split(",")) {
                    ArrayList list = new ArrayList();
                    String[] array = ap.split(";");
                    Collections.addAll(list, array);
                    this.allocationPaths.add(list);
                }
            } else {
                throw new ParseException("No allocation paths provided.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dumpLedgers(Set<Long> ledgers, File targetFile) throws Exception {
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), StandardCharsets.UTF_8.name()));){
                for (Long ledger : ledgers) {
                    pw.println(ledger);
                }
            }
            System.out.println("Dump " + ledgers.size() + " ledgers to file : " + targetFile);
        }

        @Override
        protected int runCmd() throws Exception {
            if (!this.getForce() && !IOUtils.confirmPrompt((String)("Do you want to audit uris : " + this.getUris() + ", allocation paths = " + this.allocationPaths))) {
                return 0;
            }
            try (DLAuditor dlAuditor = new DLAuditor(this.getConf());){
                Pair<Set<Long>, Set<Long>> bkdlLedgers = dlAuditor.collectLedgers(this.getUris(), this.allocationPaths);
                this.dumpLedgers((Set)bkdlLedgers.getLeft(), new File(this.ledgersFilePrefix + "-bkledgers.txt"));
                this.dumpLedgers((Set)bkdlLedgers.getRight(), new File(this.ledgersFilePrefix + "-dlledgers.txt"));
                this.dumpLedgers((Set<Long>)Sets.difference((Set)((Set)bkdlLedgers.getLeft()), (Set)((Set)bkdlLedgers.getRight())), new File(this.ledgersFilePrefix + "-leakledgers.txt"));
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "audit_ledgers [options]";
        }
    }

    protected static abstract class AuditCommand
    extends Tool.OptsCommand {
        protected final Options options = new Options();
        protected final DistributedLogConfiguration dlConf;
        protected final List<URI> uris = new ArrayList<URI>();
        protected String zkAclId = null;
        protected boolean force = false;

        protected AuditCommand(String name, String description) {
            super(name, description);
            this.dlConf = new DistributedLogConfiguration();
            this.options.addOption("u", "uris", true, "List of distributedlog uris, separated by comma");
            this.options.addOption("c", "conf", true, "DistributedLog Configuration File");
            this.options.addOption("a", "zk-acl-id", true, "ZooKeeper ACL ID");
            this.options.addOption("f", "force", false, "Force command (no warnings or prompts)");
        }

        @Override
        protected int runCmd(CommandLine commandLine) throws Exception {
            try {
                this.parseCommandLine(commandLine);
            }
            catch (ParseException pe) {
                System.err.println("ERROR: failed to parse commandline : '" + pe.getMessage() + "'");
                this.printUsage();
                return -1;
            }
            return this.runCmd();
        }

        protected abstract int runCmd() throws Exception;

        @Override
        protected Options getOptions() {
            return this.options;
        }

        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (!cmdline.hasOption("u")) {
                throw new ParseException("No distributedlog uri provided.");
            }
            String urisStr = cmdline.getOptionValue("u");
            for (String uriStr : urisStr.split(",")) {
                this.uris.add(URI.create(uriStr));
            }
            if (cmdline.hasOption("c")) {
                String configFile = cmdline.getOptionValue("c");
                try {
                    this.dlConf.loadConf(new File(configFile).toURI().toURL());
                }
                catch (ConfigurationException e) {
                    throw new ParseException("Failed to load distributedlog configuration from " + configFile + ".");
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Failed to load distributedlog configuration from malformed " + configFile + ".");
                }
            }
            if (cmdline.hasOption("a")) {
                this.zkAclId = cmdline.getOptionValue("a");
            }
            if (cmdline.hasOption("f")) {
                this.force = true;
            }
        }

        protected DistributedLogConfiguration getConf() {
            return this.dlConf;
        }

        protected List<URI> getUris() {
            return this.uris;
        }

        protected String getZkAclId() {
            return this.zkAclId;
        }

        protected boolean getForce() {
            return this.force;
        }
    }

    protected static class ReadEntriesCommand
    extends PerLedgerCommand {
        Long fromEntryId;
        Long untilEntryId;
        boolean printHex = false;
        boolean skipPayload = false;
        boolean readAllBookies = false;
        boolean readLac = false;
        boolean corruptOnly = false;
        int metadataVersion = LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION;

        ReadEntriesCommand() {
            super("readentries", "read entries for a given ledger");
            this.options.addOption("x", "hex", false, "Print record in hex format");
            this.options.addOption("sp", "skip-payload", false, "Skip printing the payload of the record");
            this.options.addOption("fid", "from", true, "Entry id to start reading");
            this.options.addOption("uid", "until", true, "Entry id to read until");
            this.options.addOption("bks", "all-bookies", false, "Read entry from all bookies");
            this.options.addOption("lac", "last-add-confirmed", false, "Return last add confirmed rather than entry payload");
            this.options.addOption("ver", "metadata-version", true, "The log segment metadata version to use");
            this.options.addOption("bad", "corrupt-only", false, "Display info for corrupt entries only");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            this.printHex = cmdline.hasOption("x");
            this.skipPayload = cmdline.hasOption("sp");
            if (cmdline.hasOption("fid")) {
                this.fromEntryId = Long.parseLong(cmdline.getOptionValue("fid"));
            }
            if (cmdline.hasOption("uid")) {
                this.untilEntryId = Long.parseLong(cmdline.getOptionValue("uid"));
            }
            if (cmdline.hasOption("ver")) {
                this.metadataVersion = Integer.parseInt(cmdline.getOptionValue("ver"));
            }
            this.corruptOnly = cmdline.hasOption("bad");
            this.readAllBookies = cmdline.hasOption("bks");
            this.readLac = cmdline.hasOption("lac");
        }

        @Override
        protected int runCmd() throws Exception {
            try (LedgerHandle lh = this.getBookKeeperClient().get().openLedgerNoRecovery(this.getLedgerID(), BookKeeper.DigestType.CRC32, this.dlConf.getBKDigestPW().getBytes(StandardCharsets.UTF_8));){
                if (null == this.fromEntryId) {
                    this.fromEntryId = 0L;
                }
                if (null == this.untilEntryId) {
                    this.untilEntryId = lh.readLastConfirmed();
                }
                if (this.untilEntryId >= this.fromEntryId) {
                    if (this.readAllBookies) {
                        LedgerReader lr = new LedgerReader(this.getBookKeeperClient().get());
                        if (this.readLac) {
                            this.readLacsFromAllBookies(lr, lh, this.fromEntryId, this.untilEntryId);
                        } else {
                            this.readEntriesFromAllBookies(lr, lh, this.fromEntryId, this.untilEntryId);
                        }
                    } else {
                        this.simpleReadEntries(lh, this.fromEntryId, this.untilEntryId);
                    }
                } else {
                    System.out.println("No entries.");
                }
            }
            return 0;
        }

        private void readEntriesFromAllBookies(LedgerReader ledgerReader, LedgerHandle lh, long fromEntryId, long untilEntryId) throws Exception {
            for (long eid = fromEntryId; eid <= untilEntryId; ++eid) {
                CountDownLatch doneLatch = new CountDownLatch(1);
                AtomicReference resultHolder = new AtomicReference();
                ledgerReader.readEntriesFromAllBookies(lh, eid, (BookkeeperInternalCallbacks.GenericCallback<Set<LedgerReader.ReadResult<ByteBuf>>>)((BookkeeperInternalCallbacks.GenericCallback)(rc, readResults) -> {
                    if (0 == rc) {
                        resultHolder.set(readResults);
                    } else {
                        resultHolder.set(null);
                    }
                    doneLatch.countDown();
                }));
                doneLatch.await();
                Set readResults2 = (Set)resultHolder.get();
                if (null == readResults2) {
                    throw new IOException("Failed to read entry " + eid);
                }
                boolean printHeader = true;
                for (LedgerReader.ReadResult rr : readResults2) {
                    if (this.corruptOnly) {
                        if (-5 != rr.getResultCode()) continue;
                        if (printHeader) {
                            System.out.println("\t" + eid + "\t:");
                            printHeader = false;
                        }
                        System.out.println("\tbookie=" + rr.getBookieAddress());
                        System.out.println("\t-------------------------------");
                        System.out.println("status = " + BKException.getMessage((int)rr.getResultCode()));
                        System.out.println("\t-------------------------------");
                        continue;
                    }
                    if (printHeader) {
                        System.out.println("\t" + eid + "\t:");
                        printHeader = false;
                    }
                    System.out.println("\tbookie=" + rr.getBookieAddress());
                    System.out.println("\t-------------------------------");
                    if (0 == rr.getResultCode()) {
                        Entry.Reader reader = Entry.newBuilder().setLogSegmentInfo(lh.getId(), 0L).setEntryId(eid).setEntry((ByteBuf)rr.getValue()).setEnvelopeEntry(LogSegmentMetadata.supportsEnvelopedEntries(this.metadataVersion)).buildReader();
                        ReferenceCountUtil.release(rr.getValue());
                        this.printEntry(reader);
                    } else {
                        System.out.println("status = " + BKException.getMessage((int)rr.getResultCode()));
                    }
                    System.out.println("\t-------------------------------");
                }
            }
        }

        private void readLacsFromAllBookies(LedgerReader ledgerReader, LedgerHandle lh, long fromEntryId, long untilEntryId) throws Exception {
            for (long eid = fromEntryId; eid <= untilEntryId; ++eid) {
                final CountDownLatch doneLatch = new CountDownLatch(1);
                final AtomicReference resultHolder = new AtomicReference();
                ledgerReader.readLacs(lh, eid, new BookkeeperInternalCallbacks.GenericCallback<Set<LedgerReader.ReadResult<Long>>>(){

                    public void operationComplete(int rc, Set<LedgerReader.ReadResult<Long>> readResults) {
                        if (0 == rc) {
                            resultHolder.set(readResults);
                        } else {
                            resultHolder.set(null);
                        }
                        doneLatch.countDown();
                    }
                });
                doneLatch.await();
                Set readResults = (Set)resultHolder.get();
                if (null == readResults) {
                    throw new IOException("Failed to read entry " + eid);
                }
                System.out.println("\t" + eid + "\t:");
                for (LedgerReader.ReadResult rr : readResults) {
                    System.out.println("\tbookie=" + rr.getBookieAddress());
                    System.out.println("\t-------------------------------");
                    if (0 == rr.getResultCode()) {
                        System.out.println("Eid = " + rr.getEntryId() + ", Lac = " + rr.getValue());
                    } else {
                        System.out.println("status = " + BKException.getMessage((int)rr.getResultCode()));
                    }
                    System.out.println("\t-------------------------------");
                }
            }
        }

        private void simpleReadEntries(LedgerHandle lh, long fromEntryId, long untilEntryId) throws Exception {
            Enumeration entries = lh.readEntries(fromEntryId, untilEntryId);
            long i = fromEntryId;
            System.out.println("Entries:");
            while (entries.hasMoreElements()) {
                LedgerEntry entry = (LedgerEntry)entries.nextElement();
                System.out.println("\t" + i + "(eid=" + entry.getEntryId() + ")\t: ");
                Entry.Reader reader = Entry.newBuilder().setLogSegmentInfo(0L, 0L).setEntryId(entry.getEntryId()).setEntry(entry.getEntryBuffer()).setEnvelopeEntry(LogSegmentMetadata.supportsEnvelopedEntries(this.metadataVersion)).buildReader();
                ReferenceCountUtil.release((Object)entry.getEntryBuffer());
                this.printEntry(reader);
                ++i;
            }
        }

        private void printEntry(Entry.Reader reader) throws Exception {
            LogRecordWithDLSN record = reader.nextRecord();
            while (null != record) {
                System.out.println("\t" + record);
                if (!this.skipPayload) {
                    if (this.printHex) {
                        System.out.println(Hex.encodeHexString((byte[])record.getPayload()));
                    } else {
                        System.out.println(new String(record.getPayload(), StandardCharsets.UTF_8));
                    }
                }
                System.out.println();
                record = reader.nextRecord();
            }
        }

        @Override
        protected String getUsage() {
            return "readentries [options]";
        }
    }

    protected static class ReadLastConfirmedCommand
    extends PerLedgerCommand {
        ReadLastConfirmedCommand() {
            super("readlac", "read last add confirmed for a given ledger");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            try (LedgerHandle lh = this.getBookKeeperClient().get().openLedgerNoRecovery(this.getLedgerID(), BookKeeper.DigestType.CRC32, this.dlConf.getBKDigestPW().getBytes(StandardCharsets.UTF_8));){
                long lac = lh.readLastConfirmed();
                System.out.println("LastAddConfirmed: " + lac);
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "readlac [options]";
        }
    }

    protected static class FindLedgerCommand
    extends PerLedgerCommand {
        FindLedgerCommand() {
            super("findledger", "find the stream for a given ledger");
        }

        @Override
        protected int runCmd() throws Exception {
            Iterator<String> logs = this.getNamespace().getLogs();
            while (logs.hasNext()) {
                String logName = logs.next();
                if (!this.processLog(logName)) continue;
                System.out.println("Found ledger " + this.getLedgerID() + " at log stream '" + logName + "'");
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processLog(String logName) throws Exception {
            try (DistributedLogManager dlm = this.getNamespace().openLog(logName);){
                List<LogSegmentMetadata> segments = dlm.getLogSegments();
                for (LogSegmentMetadata segment : segments) {
                    if (this.getLedgerID() != segment.getLogSegmentId()) continue;
                    System.out.println("Found ledger " + this.getLedgerID() + " at log segment " + segment + " for stream '" + logName + "'");
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    protected static class RecoverLedgerCommand
    extends PerLedgerCommand {
        RecoverLedgerCommand() {
            super("recoverledger", "force recover ledger");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            LedgerHandle lh = this.getBookKeeperClient().get().openLedgerNoRecovery(this.getLedgerID(), BookKeeper.DigestType.CRC32, this.dlConf.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
            final CountDownLatch doneLatch = new CountDownLatch(1);
            final AtomicInteger resultHolder = new AtomicInteger(-1234);
            BookkeeperInternalCallbacks.GenericCallback<Void> recoverCb = new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                public void operationComplete(int rc, Void result) {
                    resultHolder.set(rc);
                    doneLatch.countDown();
                }
            };
            try {
                BookKeeperAccessor.forceRecoverLedger(lh, recoverCb);
                doneLatch.await();
                if (0 != resultHolder.get()) {
                    throw BKException.create((int)resultHolder.get());
                }
            }
            finally {
                lh.close();
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "recoverledger [options]";
        }
    }

    static abstract class PerLedgerCommand
    extends PerDLCommand {
        protected long ledgerId;

        protected PerLedgerCommand(String name, String description) {
            super(name, description);
            this.options.addOption("l", "ledger", true, "Ledger ID");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("l")) {
                throw new ParseException("No ledger provided.");
            }
            this.ledgerId = Long.parseLong(cmdline.getOptionValue("l"));
        }

        protected long getLedgerID() {
            return this.ledgerId;
        }

        protected void setLedgerId(long ledgerId) {
            this.ledgerId = ledgerId;
        }
    }

    static abstract class PerBKCommand
    extends PerDLCommand {
        protected PerBKCommand(String name, String description) {
            super(name, description);
        }

        @Override
        protected int runCmd() throws Exception {
            return this.runBKCommand(new BKCommandRunner(){

                @Override
                public int run(ZooKeeperClient zkc, BookKeeperClient bkc) throws Exception {
                    return this.runBKCmd(zkc, bkc);
                }
            });
        }

        protected int runBKCommand(BKCommandRunner runner) throws Exception {
            return runner.run(this.getZooKeeperClient(), this.getBookKeeperClient());
        }

        protected abstract int runBKCmd(ZooKeeperClient var1, BookKeeperClient var2) throws Exception;
    }

    static interface BKCommandRunner {
        public int run(ZooKeeperClient var1, BookKeeperClient var2) throws Exception;
    }

    static class InspectStreamCommand
    extends PerStreamCommand {
        InspectStreamCommand() {
            super("inspectstream", "Inspect a given stream to identify any metadata corruptions");
        }

        @Override
        protected int runCmd() throws Exception {
            try (DistributedLogManager dlm = this.getNamespace().openLog(this.getStreamName());){
                int n = this.inspectAndRepair(dlm.getLogSegments());
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int inspectAndRepair(List<LogSegmentMetadata> segments) throws Exception {
            LogSegmentMetadataStore metadataStore = this.getLogSegmentMetadataStore();
            ZooKeeperClient zkc = this.getZooKeeperClient();
            BKDLConfig bkdlConfig = BKDLConfig.resolveDLConfig(zkc, this.getUri());
            BKDLConfig.propagateConfiguration(bkdlConfig, this.getConf());
            try (BookKeeperClient bkc = BookKeeperClientBuilder.newBuilder().dlConfig(this.getConf()).zkServers(bkdlConfig.getBkZkServersForReader()).ledgersPath(bkdlConfig.getBkLedgersPath()).name("dlog").build();){
                List<LogSegmentMetadata> segmentsToRepair = this.inspectLogSegments(bkc, segments);
                if (segmentsToRepair.isEmpty()) {
                    System.out.println("The stream is good. No log segments to repair.");
                    int n = 0;
                    return n;
                }
                System.out.println(segmentsToRepair.size() + " segments to repair : ");
                System.out.println(segmentsToRepair);
                System.out.println();
                if (!IOUtils.confirmPrompt((String)"Do you want to repair them (Y/N): ")) {
                    int n = 0;
                    return n;
                }
                this.repairLogSegments(metadataStore, bkc, segmentsToRepair);
                int n = 0;
                return n;
            }
        }

        protected List<LogSegmentMetadata> inspectLogSegments(BookKeeperClient bkc, List<LogSegmentMetadata> segments) throws Exception {
            ArrayList<LogSegmentMetadata> segmentsToRepair = new ArrayList<LogSegmentMetadata>();
            for (LogSegmentMetadata segment : segments) {
                if (segment.isInProgress() || this.inspectLogSegment(bkc, segment)) continue;
                segmentsToRepair.add(segment);
            }
            return segmentsToRepair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean inspectLogSegment(BookKeeperClient bkc, LogSegmentMetadata metadata) throws Exception {
            if (metadata.isInProgress()) {
                System.out.println("Skip inprogress log segment " + metadata);
                return true;
            }
            long ledgerId = metadata.getLogSegmentId();
            LedgerHandle lh = bkc.get().openLedger(ledgerId, BookKeeper.DigestType.CRC32, this.getConf().getBKDigestPW().getBytes(StandardCharsets.UTF_8));
            LedgerHandle readLh = bkc.get().openLedger(ledgerId, BookKeeper.DigestType.CRC32, this.getConf().getBKDigestPW().getBytes(StandardCharsets.UTF_8));
            LedgerReader lr = new LedgerReader(bkc.get());
            final AtomicReference<Object> entriesHolder = new AtomicReference<Object>(null);
            final AtomicInteger rcHolder = new AtomicInteger(-1234);
            final CountDownLatch doneLatch = new CountDownLatch(1);
            try {
                long lastEntryId;
                lr.forwardReadEntriesFromLastConfirmed(readLh, new BookkeeperInternalCallbacks.GenericCallback<List<LedgerEntry>>(){

                    public void operationComplete(int rc, List<LedgerEntry> entries) {
                        rcHolder.set(rc);
                        entriesHolder.set(entries);
                        doneLatch.countDown();
                    }
                });
                doneLatch.await();
                if (0 != rcHolder.get()) {
                    throw BKException.create((int)rcHolder.get());
                }
                List entries = entriesHolder.get();
                if (entries.isEmpty()) {
                    lastEntryId = -1L;
                } else {
                    LedgerEntry lastEntry = (LedgerEntry)entries.get(entries.size() - 1);
                    lastEntryId = lastEntry.getEntryId();
                }
                if (lastEntryId != lh.getLastAddConfirmed()) {
                    System.out.println("Inconsistent Last Add Confirmed Found for LogSegment " + metadata.getLogSegmentSequenceNumber() + ": ");
                    System.out.println("\t metadata: " + metadata);
                    System.out.println("\t lac in ledger metadata is " + lh.getLastAddConfirmed() + ", but lac in bookies is " + lastEntryId);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lh.close();
                readLh.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void repairLogSegments(LogSegmentMetadataStore metadataStore, BookKeeperClient bkc, List<LogSegmentMetadata> segments) throws Exception {
            try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(bkc.get());){
                MetadataUpdater metadataUpdater = LogSegmentMetadataStoreUpdater.createMetadataUpdater(this.getConf(), metadataStore);
                for (LogSegmentMetadata segment : segments) {
                    this.repairLogSegment(bkAdmin, metadataUpdater, segment);
                }
            }
        }

        protected void repairLogSegment(BookKeeperAdmin bkAdmin, MetadataUpdater metadataUpdater, LogSegmentMetadata segment) throws Exception {
            long lac;
            if (segment.isInProgress()) {
                System.out.println("Skip inprogress log segment " + segment);
                return;
            }
            LedgerHandle lh = bkAdmin.openLedger(segment.getLogSegmentId());
            Enumeration entries = lh.readEntries(lac = lh.getLastAddConfirmed(), lac);
            if (!entries.hasMoreElements()) {
                throw new IOException("Entry " + lac + " isn't found for " + segment);
            }
            LedgerEntry lastEntry = (LedgerEntry)entries.nextElement();
            Entry.Reader reader = Entry.newBuilder().setLogSegmentInfo(segment.getLogSegmentSequenceNumber(), segment.getStartSequenceId()).setEntryId(lastEntry.getEntryId()).setEnvelopeEntry(LogSegmentMetadata.supportsEnvelopedEntries(segment.getVersion())).setEntry(lastEntry.getEntryBuffer()).buildReader();
            ReferenceCountUtil.release((Object)lastEntry.getEntryBuffer());
            LogRecordWithDLSN record = reader.nextRecord();
            LogRecordWithDLSN lastRecord = null;
            while (null != record) {
                lastRecord = record;
                record = reader.nextRecord();
            }
            if (null == lastRecord) {
                throw new IOException("No record found in entry " + lac + " for " + segment);
            }
            System.out.println("Updating last record for " + segment + " to " + lastRecord);
            if (!IOUtils.confirmPrompt((String)"Do you want to make this change (Y/N): ")) {
                return;
            }
            metadataUpdater.updateLastRecord(segment, lastRecord);
        }

        @Override
        protected String getUsage() {
            return "inspectstream [options]";
        }
    }

    protected static class DumpCommand
    extends PerStreamCommand {
        boolean printHex = false;
        boolean skipPayload = false;
        Long fromTxnId = null;
        DLSN fromDLSN = null;
        int count = 100;

        DumpCommand() {
            super("dump", "dump records of a given stream");
            this.options.addOption("x", "hex", false, "Print record in hex format");
            this.options.addOption("sp", "skip-payload", false, "Skip printing the payload of the record");
            this.options.addOption("o", "offset", true, "Txn ID to start dumping.");
            this.options.addOption("n", "seqno", true, "Sequence Number to start dumping");
            this.options.addOption("e", "eid", true, "Entry ID to start dumping");
            this.options.addOption("t", "slot", true, "Slot to start dumping");
            this.options.addOption("l", "limit", true, "Number of entries to dump. Default is 100.");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            this.printHex = cmdline.hasOption("x");
            this.skipPayload = cmdline.hasOption("sp");
            if (cmdline.hasOption("o")) {
                try {
                    this.fromTxnId = Long.parseLong(cmdline.getOptionValue("o"));
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid txn id " + cmdline.getOptionValue("o"));
                }
            }
            if (cmdline.hasOption("l")) {
                try {
                    this.count = Integer.parseInt(cmdline.getOptionValue("l"));
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid count " + cmdline.getOptionValue("l"));
                }
                if (this.count <= 0) {
                    throw new ParseException("Negative count found : " + this.count);
                }
            }
            if (cmdline.hasOption("n")) {
                long seqno;
                try {
                    seqno = Long.parseLong(cmdline.getOptionValue("n"));
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid sequence number " + cmdline.getOptionValue("n"));
                }
                long eid = cmdline.hasOption("e") ? Long.parseLong(cmdline.getOptionValue("e")) : 0L;
                long slot = cmdline.hasOption("t") ? Long.parseLong(cmdline.getOptionValue("t")) : 0L;
                this.fromDLSN = new DLSN(seqno, eid, slot);
            }
            if (null == this.fromTxnId && null == this.fromDLSN) {
                throw new ParseException("No start Txn/DLSN is specified.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            DistributedLogManager dlm = this.getNamespace().openLog(this.getStreamName());
            long totalCount = dlm.getLogRecordCount();
            try {
                Object startOffset;
                AsyncLogReader reader;
                try {
                    DLSN lastDLSN = (DLSN)FutureUtils.result(dlm.getLastDLSNAsync());
                    System.out.println("Last DLSN : " + lastDLSN);
                    if (null == this.fromDLSN) {
                        reader = dlm.getAsyncLogReader(this.fromTxnId);
                        startOffset = this.fromTxnId;
                    } else {
                        reader = dlm.getAsyncLogReader(this.fromDLSN);
                        startOffset = this.fromDLSN;
                    }
                }
                catch (LogNotFoundException lee) {
                    System.out.println("No stream found to dump records.");
                    int n = 0;
                    dlm.close();
                    return n;
                }
                try {
                    System.out.println(String.format("Dump records for %s (from = %s, dump count = %d, total records = %d)", this.getStreamName(), startOffset, this.count, totalCount));
                    this.dumpRecords(reader);
                }
                finally {
                    Utils.close(reader);
                }
            }
            finally {
                dlm.close();
            }
            return 0;
        }

        private void dumpRecords(AsyncLogReader reader) throws Exception {
            int numRead = 0;
            LogRecord record = (LogRecord)FutureUtils.result(reader.readNext());
            while (record != null) {
                this.dumpRecord(record);
                if (++numRead >= this.count) break;
                record = (LogRecord)FutureUtils.result(reader.readNext());
            }
            if (numRead == 0) {
                System.out.println("No records.");
            } else {
                System.out.println("------------------------------------------------");
            }
        }

        private void dumpRecord(LogRecord record) {
            System.out.println("------------------------------------------------");
            if (record instanceof LogRecordWithDLSN) {
                System.out.println("Record (txn = " + record.getTransactionId() + ", bytes = " + record.getPayload().length + ", dlsn = " + ((LogRecordWithDLSN)record).getDlsn() + ", sequence id = " + ((LogRecordWithDLSN)record).getSequenceId() + ")");
            } else {
                System.out.println("Record (txn = " + record.getTransactionId() + ", bytes = " + record.getPayload().length + ")");
            }
            System.out.println();
            if (this.skipPayload) {
                return;
            }
            if (this.printHex) {
                System.out.println(Hex.encodeHexString((byte[])record.getPayload()));
            } else {
                System.out.println(new String(record.getPayload(), StandardCharsets.UTF_8));
            }
        }

        @Override
        protected String getUsage() {
            return "dump [options]";
        }

        protected void setFromTxnId(Long fromTxnId) {
            this.fromTxnId = fromTxnId;
        }
    }

    public static class CreateCommand
    extends PerDLCommand {
        final List<String> streams = new ArrayList<String>();
        String streamPrefix = null;
        String streamExpression = null;

        CreateCommand() {
            super("create", "create streams under a given namespace");
            this.options.addOption("r", "prefix", true, "Prefix of stream name. E.g. 'QuantumLeapTest-'.");
            this.options.addOption("e", "expression", true, "Expression to generate stream suffix. Currently we support range 'x-y', list 'x,y,z' and name 'xyz'");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("r")) {
                this.streamPrefix = cmdline.getOptionValue("r");
            }
            if (cmdline.hasOption("e")) {
                this.streamExpression = cmdline.getOptionValue("e");
            }
            if (null == this.streamPrefix || null == this.streamExpression) {
                throw new ParseException("Please specify stream prefix & expression.");
            }
        }

        protected void generateStreams(String streamPrefix, String streamExpression) throws ParseException {
            if (streamExpression.contains("-")) {
                String[] parts = streamExpression.split("-");
                if (parts.length != 2) {
                    throw new ParseException("Invalid stream index range : " + streamExpression);
                }
                try {
                    int start = Integer.parseInt(parts[0]);
                    int end = Integer.parseInt(parts[1]);
                    if (start > end) {
                        throw new ParseException("Invalid stream index range : " + streamExpression);
                    }
                    for (int i = start; i <= end; ++i) {
                        this.streams.add(streamPrefix + i);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid stream index range : " + streamExpression);
                }
            } else if (streamExpression.contains(",")) {
                String[] parts = streamExpression.split(",");
                try {
                    for (String part : parts) {
                        int idx = Integer.parseInt(part);
                        this.streams.add(streamPrefix + idx);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid stream suffix list : " + streamExpression);
                }
            } else {
                this.streams.add(streamPrefix + streamExpression);
            }
        }

        @Override
        protected int runCmd() throws Exception {
            this.generateStreams(this.streamPrefix, this.streamExpression);
            if (this.streams.isEmpty()) {
                System.out.println("Nothing to create.");
                return 0;
            }
            if (!this.getForce() && !IOUtils.confirmPrompt((String)("You are going to create streams : " + this.streams))) {
                return 0;
            }
            this.getConf().setZkAclId(this.getZkAclId());
            for (String stream : this.streams) {
                this.getNamespace().createLog(stream);
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "create [options]";
        }

        protected void setPrefix(String prefix) {
            this.streamPrefix = prefix;
        }

        protected void setExpression(String expression) {
            this.streamExpression = expression;
        }
    }

    public static class DeleteLedgersCommand
    extends PerDLCommand {
        private final List<Long> ledgers = new ArrayList<Long>();
        int numThreads = 1;

        protected DeleteLedgersCommand() {
            super("delete_ledgers", "delete given ledgers");
            this.options.addOption("l", "ledgers", true, "List of ledgers, separated by comma");
            this.options.addOption("lf", "ledgers-file", true, "File of list of ledgers, each line has a ledger id");
            this.options.addOption("t", "concurrency", true, "Number of threads to run deletions");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("l") && cmdline.hasOption("lf")) {
                throw new ParseException("Please specify ledgers: either use list or use file only.");
            }
            if (!cmdline.hasOption("l") && !cmdline.hasOption("lf")) {
                throw new ParseException("No ledgers specified. Please specify ledgers either use list or use file only.");
            }
            if (cmdline.hasOption("l")) {
                String[] ledgerStrs;
                String ledgersStr = cmdline.getOptionValue("l");
                for (String ledgerStr : ledgerStrs = ledgersStr.split(",")) {
                    this.ledgers.add(Long.parseLong(ledgerStr));
                }
            }
            if (cmdline.hasOption("lf")) {
                BufferedReader br = null;
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(cmdline.getOptionValue("lf"))), StandardCharsets.UTF_8.name()));
                    while ((line = br.readLine()) != null) {
                        this.ledgers.add(Long.parseLong(line));
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ParseException("No ledgers file " + cmdline.getOptionValue("lf") + " found.");
                }
                catch (IOException e) {
                    throw new ParseException("Invalid ledgers file " + cmdline.getOptionValue("lf") + " found.");
                }
                finally {
                    if (null != br) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (cmdline.hasOption("t")) {
                this.numThreads = Integer.parseInt(cmdline.getOptionValue("t"));
            }
        }

        @Override
        protected String getUsage() {
            return "delete_ledgers [options]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
            try {
                final AtomicInteger numLedgers = new AtomicInteger(0);
                final CountDownLatch doneLatch = new CountDownLatch(this.numThreads);
                final AtomicInteger numFailures = new AtomicInteger(0);
                final LinkedBlockingQueue<Long> ledgerQueue = new LinkedBlockingQueue<Long>();
                ledgerQueue.addAll(this.ledgers);
                int i = 0;
                while (i < this.numThreads) {
                    final int tid = i++;
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            Long ledger;
                            while (null != (ledger = (Long)ledgerQueue.poll())) {
                                try {
                                    this.getBookKeeperClient().get().deleteLedger(ledger.longValue());
                                    int numLedgersDeleted = numLedgers.incrementAndGet();
                                    if (numLedgersDeleted % 1000 != 0) continue;
                                    System.out.println("Deleted " + numLedgersDeleted + " ledgers.");
                                }
                                catch (BKException.BKNoSuchLedgerExistsOnMetadataServerException e) {
                                    int numLedgersDeleted = numLedgers.incrementAndGet();
                                    if (numLedgersDeleted % 1000 != 0) continue;
                                    System.out.println("Deleted " + numLedgersDeleted + " ledgers.");
                                }
                                catch (Exception e) {
                                    numFailures.incrementAndGet();
                                    break;
                                }
                            }
                            doneLatch.countDown();
                            System.out.println("Thread " + tid + " quits");
                        }
                    });
                }
                doneLatch.await();
                if (numFailures.get() > 0) {
                    throw new IOException("Encounter " + numFailures.get() + " failures during deleting ledgers");
                }
            }
            finally {
                executorService.shutdown();
            }
            return 0;
        }
    }

    public static class DeleteCommand
    extends PerStreamCommand {
        protected DeleteCommand() {
            super("delete", "delete a given stream");
        }

        @Override
        protected int runCmd() throws Exception {
            this.getConf().setZkAclId(this.getZkAclId());
            try (DistributedLogManager dlm = this.getNamespace().openLog(this.getStreamName());){
                dlm.delete();
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "delete";
        }
    }

    static class CountCommand
    extends PerStreamCommand {
        DLSN startDLSN = null;
        DLSN endDLSN = null;

        protected CountCommand() {
            super("count", "count number records between dlsns");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            String[] args = cmdline.getArgs();
            if (args.length < 1) {
                throw new ParseException("Must specify at least start dlsn.");
            }
            if (args.length >= 1) {
                this.startDLSN = DistributedLogTool.parseDLSN(args[0]);
            }
            if (args.length >= 2) {
                this.endDLSN = DistributedLogTool.parseDLSN(args[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            try (DistributedLogManager dlm = this.getNamespace().openLog(this.getStreamName());){
                long count = 0L;
                count = null == this.endDLSN ? this.countToLastRecord(dlm) : (long)this.countFromStartToEnd(dlm);
                System.out.println("total is " + count + " records.");
                int n = 0;
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int countFromStartToEnd(DistributedLogManager dlm) throws Exception {
            int count = 0;
            try (LogReader reader = dlm.getInputStream(this.startDLSN);){
                LogRecordWithDLSN record;
                LogRecordWithDLSN preRecord = record = reader.readNext(false);
                System.out.println("first record : " + record);
                while (null != record && record.getDlsn().compareTo(this.endDLSN) <= 0) {
                    if (++count % 1000 == 0) {
                        logger.info("read {} records from {}...", (Object)count, (Object)this.getStreamName());
                    }
                    preRecord = record;
                    record = reader.readNext(false);
                }
                System.out.println("last record : " + preRecord);
            }
            finally {
                dlm.close();
            }
            return count;
        }

        long countToLastRecord(DistributedLogManager dlm) throws Exception {
            return (Long)FutureUtils.result(dlm.getLogRecordCountAsync(this.startDLSN));
        }

        @Override
        protected String getUsage() {
            return "count <start> <end>";
        }
    }

    protected static class ShowCommand
    extends PerStreamCommand {
        SimpleBookKeeperClient bkc = null;
        boolean listSegments = true;
        boolean listEppStats = false;
        long firstLid = 0L;
        long lastLid = -1L;

        ShowCommand() {
            super("show", "show metadata of a given stream and list segments");
            this.options.addOption("ns", "no-log-segments", false, "Do not list log segment metadata");
            this.options.addOption("lp", "placement-stats", false, "Show ensemble placement stats");
            this.options.addOption("fl", "first-ledger", true, "First log sement no");
            this.options.addOption("ll", "last-ledger", true, "Last log sement no");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("fl")) {
                try {
                    this.firstLid = Long.parseLong(cmdline.getOptionValue("fl"));
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid ledger id " + cmdline.getOptionValue("fl"));
                }
            }
            if (this.firstLid < 0L) {
                throw new IllegalArgumentException("Invalid ledger id " + this.firstLid);
            }
            if (cmdline.hasOption("ll")) {
                try {
                    this.lastLid = Long.parseLong(cmdline.getOptionValue("ll"));
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid ledger id " + cmdline.getOptionValue("ll"));
                }
            }
            if (this.lastLid != -1L && this.firstLid > this.lastLid) {
                throw new IllegalArgumentException("Invalid ledger ids " + this.firstLid + " " + this.lastLid);
            }
            this.listSegments = !cmdline.hasOption("ns");
            this.listEppStats = cmdline.hasOption("lp");
        }

        @Override
        protected int runCmd() throws Exception {
            DistributedLogManager dlm = this.getNamespace().openLog(this.getStreamName());
            try {
                if (this.listEppStats) {
                    this.bkc = new SimpleBookKeeperClient(this.getConf(), this.getUri());
                }
                this.printMetadata(dlm);
            }
            finally {
                dlm.close();
                if (null != this.bkc) {
                    this.bkc.close();
                }
            }
            return 0;
        }

        private void printMetadata(DistributedLogManager dlm) throws Exception {
            this.printHeader(dlm);
            if (this.listSegments) {
                System.out.println("Ledgers : ");
                List<LogSegmentMetadata> segments = dlm.getLogSegments();
                for (LogSegmentMetadata segment : segments) {
                    if (!this.include(segment)) continue;
                    this.printLedgerRow(segment);
                }
            }
        }

        private void printHeader(DistributedLogManager dlm) throws Exception {
            DLSN firstDlsn = (DLSN)FutureUtils.result(dlm.getFirstDLSNAsync());
            boolean endOfStreamMarked = dlm.isEndOfStreamMarked();
            DLSN lastDlsn = dlm.getLastDLSN();
            long firstTxnId = dlm.getFirstTxId();
            long lastTxnId = dlm.getLastTxId();
            long recordCount = dlm.getLogRecordCount();
            String result = String.format("Stream : (firstTxId=%d, lastTxid=%d, firstDlsn=%s, lastDlsn=%s, endOfStreamMarked=%b, recordCount=%d)", firstTxnId, lastTxnId, this.getDlsnName(firstDlsn), this.getDlsnName(lastDlsn), endOfStreamMarked, recordCount);
            System.out.println(result);
            if (this.listEppStats) {
                this.printEppStatsHeader(dlm);
            }
        }

        boolean include(LogSegmentMetadata segment) {
            return this.firstLid <= segment.getLogSegmentSequenceNumber() && (this.lastLid == -1L || this.lastLid >= segment.getLogSegmentSequenceNumber());
        }

        private void printEppStatsHeader(DistributedLogManager dlm) throws Exception {
            String label = "Ledger Placement :";
            System.out.println(label);
            HashMap<BookieId, Integer> totals = new HashMap<BookieId, Integer>();
            List<LogSegmentMetadata> segments = dlm.getLogSegments();
            for (LogSegmentMetadata segment : segments) {
                if (!this.include(segment)) continue;
                this.merge(totals, this.getBookieStats(segment));
            }
            ArrayList entries = new ArrayList(totals.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<BookieId, Integer>>(){

                @Override
                public int compare(Map.Entry<BookieId, Integer> o1, Map.Entry<BookieId, Integer> o2) {
                    return o2.getValue() - o1.getValue();
                }
            });
            int width = 0;
            int totalEntries = 0;
            for (Map.Entry entry : entries) {
                width = Math.max(width, label.length() + 1 + ((BookieId)entry.getKey()).toString().length());
                totalEntries += ((Integer)entry.getValue()).intValue();
            }
            for (Map.Entry entry : entries) {
                System.out.println(String.format("%" + width + "s\t%6.2f%%\t\t%d", entry.getKey(), (double)((Integer)entry.getValue()).intValue() * 1.0 / (double)totalEntries, entry.getValue()));
            }
        }

        private void printLedgerRow(LogSegmentMetadata segment) throws Exception {
            System.out.println(segment.getLogSegmentSequenceNumber() + "\t: " + segment);
        }

        private Map<BookieId, Integer> getBookieStats(LogSegmentMetadata segment) throws Exception {
            HashMap<BookieId, Integer> stats = new HashMap<BookieId, Integer>();
            LedgerHandle lh = this.bkc.client().get().openLedgerNoRecovery(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.getConf().getBKDigestPW().getBytes(StandardCharsets.UTF_8));
            long eidFirst = 0L;
            for (Map.Entry<Long, ? extends List<BookieId>> entry : LedgerReader.bookiesForLedger(lh).entrySet()) {
                long eidLast = entry.getKey();
                long count = eidLast - eidFirst + 1L;
                for (BookieId bookie : entry.getValue()) {
                    this.merge(stats, bookie, (int)count);
                }
                eidFirst = eidLast;
            }
            return stats;
        }

        void merge(Map<BookieId, Integer> m, BookieId bookie, Integer count) {
            if (m.containsKey(bookie)) {
                m.put(bookie, count + m.get(bookie));
            } else {
                m.put(bookie, count);
            }
        }

        void merge(Map<BookieId, Integer> m1, Map<BookieId, Integer> m2) {
            for (Map.Entry<BookieId, Integer> entry : m2.entrySet()) {
                this.merge(m1, entry.getKey(), entry.getValue());
            }
        }

        String getDlsnName(DLSN dlsn) {
            if (dlsn.equals((Object)DLSN.InvalidDLSN)) {
                return "InvalidDLSN";
            }
            return dlsn.toString();
        }

        @Override
        protected String getUsage() {
            return "show [options]";
        }
    }

    public static class SimpleBookKeeperClient {
        BookKeeperClient bkc;
        ZooKeeperClient zkc;

        public SimpleBookKeeperClient(DistributedLogConfiguration conf, URI uri) {
            try {
                this.zkc = ZooKeeperClientBuilder.newBuilder().sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).zkAclId(conf.getZkAclId()).uri(uri).build();
                BKDLConfig bkdlConfig = BKDLConfig.resolveDLConfig(this.zkc, uri);
                BKDLConfig.propagateConfiguration(bkdlConfig, conf);
                this.bkc = BookKeeperClientBuilder.newBuilder().zkc(this.zkc).dlConfig(conf).ledgersPath(bkdlConfig.getBkLedgersPath()).name("dlog").build();
            }
            catch (Exception e) {
                this.close();
            }
        }

        public BookKeeperClient client() {
            return this.bkc;
        }

        public void close() {
            if (null != this.bkc) {
                this.bkc.close();
            }
            if (null != this.zkc) {
                this.zkc.close();
            }
        }
    }

    protected static class TruncateCommand
    extends PerDLCommand {
        int numThreads = 1;
        String streamPrefix = null;
        boolean deleteStream = false;

        TruncateCommand() {
            super("truncate", "truncate streams under a given dl uri");
            this.options.addOption("t", "threads", true, "Number threads to do truncation");
            this.options.addOption("ft", "filter", true, "Stream filter by prefix");
            this.options.addOption("d", "delete", false, "Delete Stream");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("t")) {
                this.numThreads = Integer.parseInt(cmdline.getOptionValue("t"));
            }
            if (cmdline.hasOption("ft")) {
                this.streamPrefix = cmdline.getOptionValue("ft");
            }
            if (cmdline.hasOption("d")) {
                this.deleteStream = true;
            }
        }

        @Override
        protected String getUsage() {
            return "truncate [options]";
        }

        protected void setFilter(String filter) {
            this.streamPrefix = filter;
        }

        @Override
        protected int runCmd() throws Exception {
            this.getConf().setZkAclId(this.getZkAclId());
            return this.truncateStreams(this.getNamespace());
        }

        private int truncateStreams(final Namespace namespace) throws Exception {
            int i;
            Iterator<String> streamCollection = namespace.getLogs();
            final ArrayList<String> streams = new ArrayList<String>();
            while (streamCollection.hasNext()) {
                String s = streamCollection.next();
                if (null != this.streamPrefix) {
                    if (!s.startsWith(this.streamPrefix)) continue;
                    streams.add(s);
                    continue;
                }
                streams.add(s);
            }
            if (0 == streams.size()) {
                return 0;
            }
            System.out.println("Streams : " + streams);
            if (!this.getForce() && !IOUtils.confirmPrompt((String)("Do you want to truncate " + streams.size() + " streams ?"))) {
                return 0;
            }
            this.numThreads = Math.min(streams.size(), this.numThreads);
            final int numStreamsPerThreads = streams.size() / this.numThreads + 1;
            Thread[] threads = new Thread[this.numThreads];
            for (i = 0; i < this.numThreads; ++i) {
                final int tid = i;
                threads[i] = new Thread("Truncate-" + i){

                    @Override
                    public void run() {
                        try {
                            this.truncateStreams(namespace, streams, tid, numStreamsPerThreads);
                            System.out.println("Thread " + tid + " finished.");
                        }
                        catch (IOException e) {
                            System.err.println("Thread " + tid + " quits with exception : " + e.getMessage());
                        }
                    }
                };
                threads[i].start();
            }
            for (i = 0; i < this.numThreads; ++i) {
                threads[i].join();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void truncateStreams(Namespace namespace, List<String> streams, int tid, int numStreamsPerThreads) throws IOException {
            int startIdx = tid * numStreamsPerThreads;
            int endIdx = Math.min(streams.size(), (tid + 1) * numStreamsPerThreads);
            for (int i = startIdx; i < endIdx; ++i) {
                String s = streams.get(i);
                try (DistributedLogManager dlm = namespace.openLog(s);){
                    if (this.deleteStream) {
                        dlm.delete();
                        continue;
                    }
                    dlm.purgeLogsOlderThan(Long.MAX_VALUE);
                    continue;
                }
            }
        }
    }

    protected static class InspectCommand
    extends PerDLCommand {
        int numThreads = 1;
        String streamPrefix = null;
        boolean printInprogressOnly = false;
        boolean dumpEntries = false;
        boolean orderByTime = false;
        boolean printStreamsOnly = false;
        boolean checkInprogressOnly = false;

        InspectCommand() {
            super("inspect", "Inspect streams under a given dl uri to find any potential corruptions");
            this.options.addOption("t", "threads", true, "Number threads to do inspection.");
            this.options.addOption("ft", "filter", true, "Stream filter by prefix");
            this.options.addOption("i", "inprogress", false, "Print inprogress log segments only");
            this.options.addOption("d", "dump", false, "Dump entries of inprogress log segments");
            this.options.addOption("ot", "orderbytime", false, "Order the log segments by completion time");
            this.options.addOption("pso", "print-stream-only", false, "Print streams only");
            this.options.addOption("cio", "check-inprogress-only", false, "Check duplicated inprogress only");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("t")) {
                this.numThreads = Integer.parseInt(cmdline.getOptionValue("t"));
            }
            if (cmdline.hasOption("ft")) {
                this.streamPrefix = cmdline.getOptionValue("ft");
            }
            this.printInprogressOnly = cmdline.hasOption("i");
            this.dumpEntries = cmdline.hasOption("d");
            this.orderByTime = cmdline.hasOption("ot");
            this.printStreamsOnly = cmdline.hasOption("pso");
            this.checkInprogressOnly = cmdline.hasOption("cio");
        }

        @Override
        protected int runCmd() throws Exception {
            TreeMap<String, List<Pair<LogSegmentMetadata, List<String>>>> corruptedCandidates = new TreeMap<String, List<Pair<LogSegmentMetadata, List<String>>>>();
            this.inspectStreams(corruptedCandidates);
            System.out.println("Corrupted Candidates : ");
            if (this.printStreamsOnly) {
                System.out.println(corruptedCandidates.keySet());
                return 0;
            }
            for (Map.Entry entry : corruptedCandidates.entrySet()) {
                System.out.println((String)entry.getKey() + " : \n");
                for (Pair pair : (List)entry.getValue()) {
                    System.out.println("\t - " + pair.getLeft());
                    if (!this.printInprogressOnly || !this.dumpEntries) continue;
                    int i = 0;
                    for (String entryData : (List)pair.getRight()) {
                        System.out.println("\t" + i + "\t: " + entryData);
                        ++i;
                    }
                }
                System.out.println();
            }
            return 0;
        }

        private void inspectStreams(final SortedMap<String, List<Pair<LogSegmentMetadata, List<String>>>> corruptedCandidates) throws Exception {
            int i;
            Iterator<String> streamCollection = this.getNamespace().getLogs();
            final ArrayList<String> streams = new ArrayList<String>();
            while (streamCollection.hasNext()) {
                String s = streamCollection.next();
                if (null != this.streamPrefix) {
                    if (!s.startsWith(this.streamPrefix)) continue;
                    streams.add(s);
                    continue;
                }
                streams.add(s);
            }
            if (0 == streams.size()) {
                return;
            }
            Tool.println("Streams : " + streams);
            if (!this.getForce() && !IOUtils.confirmPrompt((String)("Are you sure you want to inspect " + streams.size() + " streams"))) {
                return;
            }
            this.numThreads = Math.min(streams.size(), this.numThreads);
            final int numStreamsPerThreads = streams.size() / this.numThreads;
            Thread[] threads = new Thread[this.numThreads];
            for (i = 0; i < this.numThreads; ++i) {
                final int tid = i;
                threads[i] = new Thread("Inspect-" + i){

                    @Override
                    public void run() {
                        try {
                            this.inspectStreams(streams, tid, numStreamsPerThreads, corruptedCandidates);
                            System.out.println("Thread " + tid + " finished.");
                        }
                        catch (Exception e) {
                            System.err.println("Thread " + tid + " quits with exception : " + e.getMessage());
                        }
                    }
                };
                threads[i].start();
            }
            for (i = 0; i < this.numThreads; ++i) {
                threads[i].join();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void inspectStreams(List<String> streams, int tid, int numStreamsPerThreads, SortedMap<String, List<Pair<LogSegmentMetadata, List<String>>>> corruptedCandidates) throws Exception {
            int startIdx = tid * numStreamsPerThreads;
            int endIdx = Math.min(streams.size(), (tid + 1) * numStreamsPerThreads);
            for (int i = startIdx; i < endIdx; ++i) {
                String s = streams.get(i);
                BookKeeperClient bkc = this.getBookKeeperClient();
                try (DistributedLogManager dlm = this.getNamespace().openLog(s);){
                    List<LogSegmentMetadata> segments = dlm.getLogSegments();
                    if (segments.size() <= 1) continue;
                    boolean isCandidate = false;
                    if (this.checkInprogressOnly) {
                        HashSet<Long> inprogressSeqNos = new HashSet<Long>();
                        for (LogSegmentMetadata segment : segments) {
                            if (!segment.isInProgress()) continue;
                            inprogressSeqNos.add(segment.getLogSegmentSequenceNumber());
                        }
                        for (LogSegmentMetadata segment : segments) {
                            if (segment.isInProgress() || !inprogressSeqNos.contains(segment.getLogSegmentSequenceNumber())) continue;
                            isCandidate = true;
                        }
                    } else {
                        LogSegmentMetadata firstSegment = segments.get(0);
                        long lastSeqNo = firstSegment.getLogSegmentSequenceNumber();
                        for (int j = 1; j < segments.size(); ++j) {
                            LogSegmentMetadata nextSegment = segments.get(j);
                            if (lastSeqNo + 1L != nextSegment.getLogSegmentSequenceNumber()) {
                                isCandidate = true;
                                break;
                            }
                            ++lastSeqNo;
                        }
                    }
                    if (!isCandidate) continue;
                    if (this.orderByTime) {
                        Collections.sort(segments, LOGSEGMENT_COMPARATOR_BY_TIME);
                    }
                    ArrayList<Pair> ledgers = new ArrayList<Pair>();
                    Object object = segments.iterator();
                    while (object.hasNext()) {
                        LogSegmentMetadata seg;
                        LogSegmentMetadata segment = seg = object.next();
                        ArrayList<String> dumpedEntries = new ArrayList<String>();
                        if (segment.isInProgress()) {
                            try (LedgerHandle lh = bkc.get().openLedgerNoRecovery(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.dlConf.getBKDigestPW().getBytes(StandardCharsets.UTF_8));){
                                long lac = lh.readLastConfirmed();
                                segment = segment.mutator().setLastEntryId(lac).build();
                                if (this.printInprogressOnly && this.dumpEntries && lac >= 0L) {
                                    Enumeration entries = lh.readEntries(0L, lac);
                                    while (entries.hasMoreElements()) {
                                        LedgerEntry entry = (LedgerEntry)entries.nextElement();
                                        dumpedEntries.add(new String(entry.getEntry(), StandardCharsets.UTF_8));
                                    }
                                }
                            }
                        }
                        if (this.printInprogressOnly) {
                            if (!segment.isInProgress()) continue;
                            ledgers.add(Pair.of((Object)segment, dumpedEntries));
                            continue;
                        }
                        ledgers.add(Pair.of((Object)segment, EMPTY_LIST));
                    }
                    object = corruptedCandidates;
                    synchronized (object) {
                        corruptedCandidates.put(s, ledgers);
                        continue;
                    }
                }
            }
        }

        @Override
        protected String getUsage() {
            return "inspect [options]";
        }
    }

    public static class WatchNamespaceCommand
    extends PerDLCommand
    implements NamespaceListener {
        private Set<String> currentSet = Sets.newHashSet();
        private CountDownLatch doneLatch = new CountDownLatch(1);

        WatchNamespaceCommand() {
            super("watch", "watch and report changes for a dl namespace");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
        }

        @Override
        protected String getUsage() {
            return "watch [options]";
        }

        @Override
        protected int runCmd() throws Exception {
            this.watchAndReportChanges(this.getNamespace());
            this.doneLatch.await();
            return 0;
        }

        @Override
        public synchronized void onStreamsChanged(Iterator<String> streams) {
            HashSet updatedSet = Sets.newHashSet(streams);
            Sets.SetView oldStreams = Sets.difference(this.currentSet, (Set)updatedSet);
            Sets.SetView newStreams = Sets.difference((Set)updatedSet, this.currentSet);
            this.currentSet = updatedSet;
            System.out.println("Old streams : ");
            for (String stream : oldStreams) {
                System.out.println(stream);
            }
            System.out.println("New streams : ");
            for (String stream : newStreams) {
                System.out.println(stream);
            }
            System.out.println();
        }

        protected void watchAndReportChanges(Namespace namespace) throws Exception {
            namespace.registerNamespaceListener(this);
        }
    }

    public static class ListCommand
    extends PerDLCommand {
        boolean printMetadata = false;
        boolean printHex = false;

        ListCommand() {
            super("list", "list streams of a given distributedlog instance");
            this.options.addOption("m", "meta", false, "Print metadata associated with each stream");
            this.options.addOption("x", "hex", false, "Print metadata in hex format");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            this.printMetadata = cmdline.hasOption("m");
            this.printHex = cmdline.hasOption("x");
        }

        @Override
        protected String getUsage() {
            return "list [options]";
        }

        @Override
        protected int runCmd() throws Exception {
            this.printStreams(this.getNamespace());
            return 0;
        }

        protected void printStreams(Namespace namespace) throws Exception {
            Iterator<String> streams = namespace.getLogs();
            System.out.println("Streams under " + this.getUri() + " : ");
            System.out.println("--------------------------------");
            while (streams.hasNext()) {
                MetadataAccessor accessor;
                byte[] metadata;
                String streamName = streams.next();
                System.out.println(streamName);
                if (!this.printMetadata || null == (metadata = (accessor = namespace.getNamespaceDriver().getMetadataAccessor(streamName)).getMetadata()) || metadata.length == 0) continue;
                if (this.printHex) {
                    System.out.println(Hex.encodeHexString((byte[])metadata));
                } else {
                    System.out.println(new String(metadata, StandardCharsets.UTF_8));
                }
                System.out.println();
            }
            System.out.println("--------------------------------");
        }
    }

    protected static class DeleteAllocatorPoolCommand
    extends PerDLCommand {
        int concurrency = 1;
        String allocationPoolPath = ".allocation_pool";

        DeleteAllocatorPoolCommand() {
            super("delete_allocator_pool", "Delete allocator pool for a given distributedlog instance");
            this.options.addOption("t", "concurrency", true, "Concurrency on deleting allocator pool.");
            this.options.addOption("ap", "allocation-pool-path", true, "Ledger Allocation Pool Path");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("t")) {
                this.concurrency = Integer.parseInt(cmdline.getOptionValue("t"));
                if (this.concurrency <= 0) {
                    throw new ParseException("Invalid concurrency value : " + this.concurrency + ": it must be greater or equal to 0.");
                }
            }
            if (cmdline.hasOption("ap")) {
                this.allocationPoolPath = cmdline.getOptionValue("ap");
                if (!this.allocationPoolPath.startsWith(".") || !this.allocationPoolPath.contains("allocation")) {
                    throw new ParseException("Invalid allocation pool path : " + this.allocationPoolPath + ": it must starts with a '.' and must contains 'allocation'");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int runCmd() throws Exception {
            String rootPath = this.getUri().getPath() + "/" + this.allocationPoolPath;
            final ScheduledExecutorService allocationExecutor = Executors.newSingleThreadScheduledExecutor();
            ExecutorService executorService = Executors.newFixedThreadPool(this.concurrency);
            Preconditions.checkArgument((boolean)(this.getNamespace() instanceof BKDistributedLogNamespace));
            BKDistributedLogNamespace bkns = (BKDistributedLogNamespace)this.getNamespace();
            final ZooKeeperClient zkc = ((BKNamespaceDriver)bkns.getNamespaceDriver()).getWriterZKC();
            final BookKeeperClient bkc = ((BKNamespaceDriver)bkns.getNamespaceDriver()).getReaderBKC();
            try {
                List pools = zkc.get().getChildren(rootPath, false);
                final LinkedBlockingQueue<String> poolsToDelete = new LinkedBlockingQueue<String>();
                if (this.getForce() || IOUtils.confirmPrompt((String)("Are you sure you want to delete allocator pools : " + pools))) {
                    for (String pool : pools) {
                        poolsToDelete.add(rootPath + "/" + pool);
                    }
                    final CountDownLatch doneLatch = new CountDownLatch(this.concurrency);
                    int i = 0;
                    while (i < this.concurrency) {
                        final int tid = i++;
                        executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                String poolPath;
                                while (!poolsToDelete.isEmpty() && null != (poolPath = (String)poolsToDelete.poll())) {
                                    try {
                                        LedgerAllocator allocator = LedgerAllocatorUtils.createLedgerAllocatorPool(poolPath, 0, this.getConf(), zkc, bkc, allocationExecutor);
                                        allocator.delete();
                                        System.out.println("Deleted allocator pool : " + poolPath + " .");
                                    }
                                    catch (IOException ioe) {
                                        System.err.println("Failed to delete allocator pool " + poolPath + " : " + ioe.getMessage());
                                    }
                                }
                                doneLatch.countDown();
                                System.out.println("Thread " + tid + " is done.");
                            }
                        });
                    }
                    doneLatch.await();
                }
            }
            finally {
                executorService.shutdown();
                allocationExecutor.shutdown();
            }
            return 0;
        }

        @Override
        protected String getUsage() {
            return "delete_allocator_pool";
        }
    }

    static abstract class PerStreamCommand
    extends PerDLCommand {
        protected String streamName;

        protected PerStreamCommand(String name, String description) {
            super(name, description);
            this.options.addOption("s", "stream", true, "Stream Name");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("s")) {
                throw new ParseException("No stream name provided.");
            }
            this.streamName = cmdline.getOptionValue("s");
        }

        protected String getStreamName() {
            return this.streamName;
        }

        protected void setStreamName(String streamName) {
            this.streamName = streamName;
        }
    }

    public static abstract class SimpleCommand
    extends Tool.OptsCommand {
        protected final Options options = new Options();

        SimpleCommand(String name, String description) {
            super(name, description);
        }

        @Override
        protected int runCmd(CommandLine commandLine) throws Exception {
            try {
                this.parseCommandLine(commandLine);
            }
            catch (ParseException pe) {
                System.err.println("ERROR: failed to parse commandline : '" + pe.getMessage() + "'");
                this.printUsage();
                return -1;
            }
            return this.runSimpleCmd();
        }

        protected abstract int runSimpleCmd() throws Exception;

        protected abstract void parseCommandLine(CommandLine var1) throws ParseException;

        @Override
        protected Options getOptions() {
            return this.options;
        }
    }

    protected static abstract class PerDLCommand
    extends Tool.OptsCommand {
        protected Options options = new Options();
        protected final DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        protected URI uri;
        protected String zkAclId = null;
        protected boolean force = false;
        protected Namespace namespace = null;

        protected PerDLCommand(String name, String description) {
            super(name, description);
            this.dlConf.setDLLedgerMetadataSkipMinVersionCheck(true);
            this.options.addOption("u", "uri", true, "DistributedLog URI");
            this.options.addOption("c", "conf", true, "DistributedLog Configuration File");
            this.options.addOption("a", "zk-acl-id", true, "Zookeeper ACL ID");
            this.options.addOption("f", "force", false, "Force command (no warnings or prompts)");
        }

        @Override
        protected int runCmd(CommandLine commandLine) throws Exception {
            try {
                this.parseCommandLine(commandLine);
            }
            catch (ParseException pe) {
                System.err.println("ERROR: failed to parse commandline : '" + pe.getMessage() + "'");
                this.printUsage();
                return -1;
            }
            try {
                int n = this.runCmd();
                return n;
            }
            finally {
                if (null != this.namespace) {
                    this.namespace.close();
                }
            }
        }

        protected abstract int runCmd() throws Exception;

        @Override
        protected Options getOptions() {
            return this.options;
        }

        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (!cmdline.hasOption("u")) {
                throw new ParseException("No distributedlog uri provided.");
            }
            this.uri = URI.create(cmdline.getOptionValue("u"));
            if (cmdline.hasOption("c")) {
                String configFile = cmdline.getOptionValue("c");
                try {
                    this.dlConf.loadConf(new File(configFile).toURI().toURL());
                }
                catch (ConfigurationException e) {
                    throw new ParseException("Failed to load distributedlog configuration from " + configFile + ".");
                }
                catch (MalformedURLException e) {
                    throw new ParseException("Failed to load distributedlog configuration from " + configFile + ": malformed uri.");
                }
            }
            if (cmdline.hasOption("a")) {
                this.zkAclId = cmdline.getOptionValue("a");
            }
            if (cmdline.hasOption("f")) {
                this.force = true;
            }
        }

        protected DistributedLogConfiguration getConf() {
            return this.dlConf;
        }

        protected URI getUri() {
            return this.uri;
        }

        protected void setUri(URI uri) {
            this.uri = uri;
        }

        protected String getZkAclId() {
            return this.zkAclId;
        }

        protected void setZkAclId(String zkAclId) {
            this.zkAclId = zkAclId;
        }

        protected boolean getForce() {
            return this.force;
        }

        protected void setForce(boolean force) {
            this.force = force;
        }

        protected Namespace getNamespace() throws IOException {
            if (null == this.namespace) {
                this.namespace = NamespaceBuilder.newBuilder().uri(this.getUri()).conf(this.getConf()).build();
            }
            return this.namespace;
        }

        protected LogSegmentMetadataStore getLogSegmentMetadataStore() throws IOException {
            return this.getNamespace().getNamespaceDriver().getLogStreamMetadataStore(NamespaceDriver.Role.READER).getLogSegmentMetadataStore();
        }

        protected ZooKeeperClient getZooKeeperClient() throws IOException {
            NamespaceDriver driver = this.getNamespace().getNamespaceDriver();
            assert (driver instanceof BKNamespaceDriver);
            return ((BKNamespaceDriver)driver).getWriterZKC();
        }

        protected BookKeeperClient getBookKeeperClient() throws IOException {
            NamespaceDriver driver = this.getNamespace().getNamespaceDriver();
            assert (driver instanceof BKNamespaceDriver);
            return ((BKNamespaceDriver)driver).getReaderBKC();
        }
    }
}

