/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.limiter;

import org.apache.distributedlog.limiter.ChainedRequestLimiter;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestLimiter {
    @Test(timeout=60000L)
    public void testChainedRequestLimiter() throws Exception {
        MockRequestLimiter limiter1 = new MockRequestLimiter();
        MockRequestLimiter limiter2 = new MockRequestLimiter();
        ChainedRequestLimiter.Builder limiterBuilder = new ChainedRequestLimiter.Builder();
        limiterBuilder.addLimiter((RequestLimiter)limiter1).addLimiter((RequestLimiter)limiter2);
        ChainedRequestLimiter limiter = limiterBuilder.build();
        Assert.assertEquals((long)0L, (long)limiter1.getCount());
        Assert.assertEquals((long)0L, (long)limiter2.getCount());
        limiter.apply((Object)new MockRequest());
        Assert.assertEquals((long)1L, (long)limiter1.getCount());
        Assert.assertEquals((long)1L, (long)limiter2.getCount());
        limiter.apply((Object)new MockRequest());
        Assert.assertEquals((long)2L, (long)limiter1.getCount());
        Assert.assertEquals((long)2L, (long)limiter2.getCount());
    }

    class MockRequestLimiter
    implements RequestLimiter<MockRequest> {
        int count = 0;

        MockRequestLimiter() {
        }

        public void apply(MockRequest request) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    class MockRequest {
        MockRequest() {
        }
    }
}

