/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.util.Recycler;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.slf4j.MDC;

class AddCompletion
extends CompletionValue
implements BookkeeperInternalCallbacks.WriteCallback {
    final Recycler.Handle<AddCompletion> handle;
    CompletionKey key = null;
    BookkeeperInternalCallbacks.WriteCallback originalCallback = null;
    private static final Recycler<AddCompletion> ADD_COMPLETION_RECYCLER = new Recycler<AddCompletion>(){

        protected AddCompletion newObject(Recycler.Handle<AddCompletion> handle) {
            return new AddCompletion(handle);
        }
    };

    static AddCompletion acquireAddCompletion(CompletionKey key, BookkeeperInternalCallbacks.WriteCallback originalCallback, Object originalCtx, long ledgerId, long entryId, PerChannelBookieClient perChannelBookieClient) {
        AddCompletion completion = (AddCompletion)ADD_COMPLETION_RECYCLER.get();
        completion.reset(key, originalCallback, originalCtx, ledgerId, entryId, perChannelBookieClient);
        return completion;
    }

    AddCompletion(Recycler.Handle<AddCompletion> handle) {
        super("Add", null, -1L, -1L, null);
        this.handle = handle;
    }

    void reset(CompletionKey key, BookkeeperInternalCallbacks.WriteCallback originalCallback, Object originalCtx, long ledgerId, long entryId, PerChannelBookieClient perChannelBookieClient) {
        this.key = key;
        this.originalCallback = originalCallback;
        this.ctx = originalCtx;
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.startTime = MathUtils.nowInNano();
        this.opLogger = perChannelBookieClient.addEntryOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.addTimeoutOpLogger;
        this.perChannelBookieClient = perChannelBookieClient;
        this.mdcContextMap = perChannelBookieClient.preserveMdcForTaskExecution ? MDC.getCopyOfContextMap() : null;
    }

    @Override
    public void release() {
        this.ctx = null;
        this.opLogger = null;
        this.timeoutOpLogger = null;
        this.perChannelBookieClient = null;
        this.mdcContextMap = null;
        this.handle.recycle((Object)this);
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
        this.logOpResult(rc);
        this.originalCallback.writeComplete(rc, ledgerId, entryId, addr, ctx);
        this.key.release();
        this.release();
    }

    @Override
    boolean maybeTimeout() {
        if (MathUtils.elapsedNanos((long)this.startTime) >= this.perChannelBookieClient.addEntryTimeoutNanos) {
            this.timeout();
            return true;
        }
        return false;
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.writeComplete(rc, this.ledgerId, this.entryId, this.perChannelBookieClient.bookieId, this.ctx));
    }

    @Override
    public void setOutstanding() {
        this.perChannelBookieClient.addEntryOutstanding.inc();
    }

    @Override
    public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
        this.perChannelBookieClient.addEntryOutstanding.dec();
        this.handleResponse(ledgerId, entryId, status);
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        this.perChannelBookieClient.addEntryOutstanding.dec();
        BookkeeperProtocol.AddResponse addResponse = response.getAddResponse();
        BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? addResponse.getStatus() : response.getStatus();
        this.handleResponse(addResponse.getLedgerId(), addResponse.getEntryId(), status);
    }

    private void handleResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status) {
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "ledger", ledgerId, "entry", entryId);
        }
        int rc = this.convertStatus(status, -12);
        this.writeComplete(rc, ledgerId, entryId, this.perChannelBookieClient.bookieId, this.ctx);
    }
}

