/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.embedded;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.embedded.ZookeeperServeInfo;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZookeeperServerClusterTest {
    @TempDir
    public Path baseDir;

    @BeforeAll
    public static void setUpEnvironment() {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
    }

    @AfterAll
    public static void cleanUpEnvironment() throws InterruptedException, IOException {
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.4lw.commands.whitelist");
    }

    @Test
    public void testStart() throws Exception {
        Path baseDir1 = this.baseDir.resolve("server1");
        Path baseDir2 = this.baseDir.resolve("server2");
        Path baseDir3 = this.baseDir.resolve("server3");
        int clientport1 = PortAssignment.unique();
        int clientport2 = PortAssignment.unique();
        int clientport3 = PortAssignment.unique();
        int port4 = PortAssignment.unique();
        int port5 = PortAssignment.unique();
        int port6 = PortAssignment.unique();
        int port7 = PortAssignment.unique();
        int port8 = PortAssignment.unique();
        int port9 = PortAssignment.unique();
        Properties config = new Properties();
        config.put("host", "localhost");
        config.put("ticktime", "10");
        config.put("initLimit", "4000");
        config.put("syncLimit", "5");
        config.put("server.1", "localhost:" + port4 + ":" + port7);
        config.put("server.2", "localhost:" + port5 + ":" + port8);
        config.put("server.3", "localhost:" + port6 + ":" + port9);
        Properties configZookeeper1 = new Properties();
        configZookeeper1.putAll((Map<?, ?>)config);
        configZookeeper1.put("clientPort", clientport1 + "");
        Properties configZookeeper2 = new Properties();
        configZookeeper2.putAll((Map<?, ?>)config);
        configZookeeper2.put("clientPort", clientport2 + "");
        Properties configZookeeper3 = new Properties();
        configZookeeper3.putAll((Map<?, ?>)config);
        configZookeeper3.put("clientPort", clientport3 + "");
        Files.createDirectories(baseDir1.resolve("data"), new FileAttribute[0]);
        Files.write(baseDir1.resolve("data").resolve("myid"), "1".getBytes("ASCII"), new OpenOption[0]);
        Files.createDirectories(baseDir2.resolve("data"), new FileAttribute[0]);
        Files.write(baseDir2.resolve("data").resolve("myid"), "2".getBytes("ASCII"), new OpenOption[0]);
        Files.createDirectories(baseDir3.resolve("data"), new FileAttribute[0]);
        Files.write(baseDir3.resolve("data").resolve("myid"), "3".getBytes("ASCII"), new OpenOption[0]);
        try (ZooKeeperServerEmbedded zkServer1 = ZooKeeperServerEmbedded.builder().configuration(configZookeeper1).baseDir(baseDir1).exitHandler(ExitHandler.LOG_ONLY).build();
             ZooKeeperServerEmbedded zkServer2 = ZooKeeperServerEmbedded.builder().configuration(configZookeeper2).baseDir(baseDir2).exitHandler(ExitHandler.LOG_ONLY).build();
             ZooKeeperServerEmbedded zkServer3 = ZooKeeperServerEmbedded.builder().configuration(configZookeeper3).baseDir(baseDir3).exitHandler(ExitHandler.LOG_ONLY).build();){
            zkServer1.start();
            zkServer2.start();
            zkServer3.start();
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer1.getConnectionString(), 60000L));
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer2.getConnectionString(), 60000L));
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer3.getConnectionString(), 60000L));
            for (int i = 0; i < 100; ++i) {
                ZookeeperServeInfo.ServerInfo status = ZookeeperServeInfo.getStatus("ReplicatedServer*");
                System.out.println("status:" + status);
                if (status.isLeader() && !status.isStandaloneMode() && status.getPeers().size() == 3) break;
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status = ZookeeperServeInfo.getStatus("ReplicatedServer*");
            Assert.assertTrue((boolean)status.isLeader());
            Assert.assertTrue((!status.isStandaloneMode() ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)status.getPeers().size());
        }
    }
}

