/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.CqlOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.StressSettings;

public class CqlInserter
extends CqlOperation<Integer> {
    public CqlInserter(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(Command.WRITE, timer, generator, seedManager, settings);
    }

    @Override
    protected String buildQuery() {
        StringBuilder query = new StringBuilder("UPDATE ").append(this.wrapInQuotes(this.type.table));
        if (this.settings.columns.timestamp != null) {
            query.append(" USING TIMESTAMP ").append(this.settings.columns.timestamp);
        }
        query.append(" SET ");
        for (int i = 0; i < this.settings.columns.maxColumnsPerKey; ++i) {
            if (i > 0) {
                query.append(',');
            }
            query.append(this.wrapInQuotes(this.settings.columns.namestrs.get(i))).append(" = ?");
        }
        query.append(" WHERE KEY=?");
        return query.toString();
    }

    @Override
    protected List<Object> getQueryParameters(byte[] key) {
        ArrayList<Object> queryParams = new ArrayList<Object>();
        List<ByteBuffer> values = this.getColumnValues();
        queryParams.addAll(values);
        queryParams.add(ByteBuffer.wrap(key));
        return queryParams;
    }

    @Override
    protected CqlOperation.CqlRunOp<Integer> buildRunOp(CqlOperation.QueryExecutor<?> queryExecutor, List<Object> params, ByteBuffer key) {
        return new CqlOperation.CqlRunOpAlwaysSucceed(this, queryExecutor, params, key, 1);
    }

    @Override
    public boolean isWrite() {
        return true;
    }
}

