/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.concurrent.JMXEnabledSingleThreadExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;

public enum Stage {
    READ(false, "ReadStage", "request", DatabaseDescriptor::getConcurrentReaders, DatabaseDescriptor::setConcurrentReaders, Stage::multiThreadedLowSignalStage),
    MUTATION(true, "MutationStage", "request", DatabaseDescriptor::getConcurrentWriters, DatabaseDescriptor::setConcurrentWriters, Stage::multiThreadedLowSignalStage),
    COUNTER_MUTATION(true, "CounterMutationStage", "request", DatabaseDescriptor::getConcurrentCounterWriters, DatabaseDescriptor::setConcurrentCounterWriters, Stage::multiThreadedLowSignalStage),
    VIEW_MUTATION(true, "ViewMutationStage", "request", DatabaseDescriptor::getConcurrentViewWriters, DatabaseDescriptor::setConcurrentViewWriters, Stage::multiThreadedLowSignalStage),
    GOSSIP(true, "GossipStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    REQUEST_RESPONSE(false, "RequestResponseStage", "request", FBUtilities::getAvailableProcessors, null, Stage::multiThreadedLowSignalStage),
    ANTI_ENTROPY(false, "AntiEntropyStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    MIGRATION(false, "MigrationStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    MISC(false, "MiscStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    TRACING(false, "TracingStage", "internal", () -> 1, null, Stage::tracingExecutor),
    INTERNAL_RESPONSE(false, "InternalResponseStage", "internal", FBUtilities::getAvailableProcessors, null, Stage::multiThreadedStage),
    IMMEDIATE(false, "ImmediateStage", "internal", () -> 0, null, Stage::immediateExecutor);

    public static final long KEEP_ALIVE_SECONDS = 60L;
    public final String jmxName;
    public final boolean shutdownBeforeCommitlog;
    private final Supplier<LocalAwareExecutorService> initialiser;
    private volatile LocalAwareExecutorService executor = null;
    private static final Map<String, Stage> nameMap;

    private Stage(Boolean shutdownBeforeCommitlog, String jmxName, String jmxType, IntSupplier numThreads, LocalAwareExecutorService.MaximumPoolSizeListener onSetMaximumPoolSize, ExecutorServiceInitialiser initialiser) {
        this.shutdownBeforeCommitlog = shutdownBeforeCommitlog;
        this.jmxName = jmxName;
        this.initialiser = () -> initialiser.init(jmxName, jmxType, numThreads.getAsInt(), onSetMaximumPoolSize);
    }

    private static String normalizeName(String stageName) {
        String upperStageName = stageName.toUpperCase();
        if (upperStageName.endsWith("STAGE")) {
            upperStageName = upperStageName.substring(0, stageName.length() - 5);
        }
        return upperStageName;
    }

    public static Stage fromPoolName(String stageName) {
        String upperStageName = Stage.normalizeName(stageName);
        Stage result = nameMap.get(upperStageName);
        if (result != null) {
            return result;
        }
        try {
            return Stage.valueOf(upperStageName);
        }
        catch (IllegalArgumentException e) {
            switch (upperStageName) {
                case "CONCURRENT_READS": {
                    return READ;
                }
                case "CONCURRENT_WRITERS": {
                    return MUTATION;
                }
                case "CONCURRENT_COUNTER_WRITES": {
                    return COUNTER_MUTATION;
                }
                case "CONCURRENT_MATERIALIZED_VIEW_WRITES": {
                    return VIEW_MUTATION;
                }
            }
            throw new IllegalStateException("Must be one of " + Arrays.stream(Stage.values()).map(Enum::toString).collect(Collectors.joining(",")));
        }
    }

    public void execute(Runnable command) {
        this.executor().execute(command);
    }

    public void execute(Runnable command, ExecutorLocals locals) {
        this.executor().execute(command, locals);
    }

    public void maybeExecuteImmediately(Runnable command) {
        this.executor().maybeExecuteImmediately(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor().submit(task);
    }

    public Future<?> submit(Runnable task) {
        return this.executor().submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor().submit(task, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalAwareExecutorService executor() {
        if (this.executor == null) {
            Stage stage = this;
            synchronized (stage) {
                if (this.executor == null) {
                    this.executor = this.initialiser.get();
                }
            }
        }
        return this.executor;
    }

    private static List<ExecutorService> executors() {
        return Stream.of(Stage.values()).map(Stage::executor).collect(Collectors.toList());
    }

    private static List<ExecutorService> mutatingExecutors() {
        return Stream.of(Stage.values()).filter(stage -> stage.shutdownBeforeCommitlog).map(Stage::executor).collect(Collectors.toList());
    }

    public static void shutdownNow() {
        ExecutorUtils.shutdownNow(Stage.executors());
    }

    public static void shutdownAndAwaitMutatingExecutors(boolean interrupt, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        List<ExecutorService> executors = Stage.mutatingExecutors();
        ExecutorUtils.shutdown(interrupt, executors);
        ExecutorUtils.awaitTermination(timeout, units, executors);
    }

    public static boolean areMutationExecutorsTerminated() {
        return Stage.mutatingExecutors().stream().allMatch(ExecutorService::isTerminated);
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        List<ExecutorService> executors = Stage.executors();
        ExecutorUtils.shutdownNow(executors);
        ExecutorUtils.awaitTermination(timeout, units, executors);
    }

    static LocalAwareExecutorService tracingExecutor(String jmxName, String jmxType, int numThreads, LocalAwareExecutorService.MaximumPoolSizeListener onSetMaximumPoolSize) {
        RejectedExecutionHandler reh = (r, executor) -> MessagingService.instance().metrics.recordSelfDroppedMessage(Verb._TRACE);
        return new TracingExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new NamedThreadFactory(jmxName), reh);
    }

    static LocalAwareExecutorService multiThreadedStage(String jmxName, String jmxType, int numThreads, LocalAwareExecutorService.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return new JMXEnabledThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(jmxName), jmxType);
    }

    static LocalAwareExecutorService multiThreadedLowSignalStage(String jmxName, String jmxType, int numThreads, LocalAwareExecutorService.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return SharedExecutorPool.SHARED.newExecutor(numThreads, onSetMaximumPoolSize, jmxType, jmxName);
    }

    static LocalAwareExecutorService singleThreadedStage(String jmxName, String jmxType, int numThreads, LocalAwareExecutorService.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return new JMXEnabledSingleThreadExecutor(jmxName, jmxType);
    }

    static LocalAwareExecutorService immediateExecutor(String jmxName, String jmxType, int numThreads, LocalAwareExecutorService.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return ImmediateExecutor.INSTANCE;
    }

    public int getCorePoolSize() {
        return this.executor().getCorePoolSize();
    }

    public void setCorePoolSize(int newCorePoolSize) {
        this.executor().setCorePoolSize(newCorePoolSize);
    }

    public int getMaximumPoolSize() {
        return this.executor().getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int newMaximumPoolSize) {
        this.executor().setMaximumPoolSize(newMaximumPoolSize);
    }

    static {
        nameMap = Arrays.stream(Stage.values()).collect(Collectors.toMap(s -> Stage.normalizeName(s.jmxName), s -> s));
    }

    private static class TracingExecutor
    extends ThreadPoolExecutor
    implements LocalAwareExecutorService {
        TracingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        public void execute(Runnable command, ExecutorLocals locals) {
            assert (locals == null);
            super.execute(command);
        }

        @Override
        public void maybeExecuteImmediately(Runnable command) {
            this.execute(command);
        }

        @Override
        public int getActiveTaskCount() {
            return this.getActiveCount();
        }

        @Override
        public int getPendingTaskCount() {
            return this.getQueue().size();
        }
    }

    @FunctionalInterface
    public static interface ExecutorServiceInitialiser {
        public LocalAwareExecutorService init(String var1, String var2, int var3, LocalAwareExecutorService.MaximumPoolSizeListener var4);
    }
}

