/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.utils.FBUtilities;

public class CompactionTasks
extends AbstractCollection<AbstractCompactionTask>
implements AutoCloseable {
    private static final CompactionTasks EMPTY = new CompactionTasks(Collections.emptyList());
    private final Collection<AbstractCompactionTask> tasks;

    private CompactionTasks(Collection<AbstractCompactionTask> tasks) {
        this.tasks = tasks;
    }

    public static CompactionTasks create(Collection<AbstractCompactionTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return EMPTY;
        }
        return new CompactionTasks(tasks);
    }

    public static CompactionTasks empty() {
        return EMPTY;
    }

    @Override
    public Iterator<AbstractCompactionTask> iterator() {
        return this.tasks.iterator();
    }

    @Override
    public int size() {
        return this.tasks.size();
    }

    @Override
    public void close() {
        try {
            FBUtilities.closeAll(this.tasks.stream().map(task -> task.transaction).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

