/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.monitor;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemAlterationObserverImpl
implements FilesystemAlterationObserver {
    private final Log log = LogFactory.getLog(FilesystemAlterationObserverImpl.class);
    private final File rootDirectory;
    private final Entry rootEntry;
    private FilesystemAlterationListener[] listeners = new FilesystemAlterationListener[0];
    private final Set<FilesystemAlterationListener> listenersSet = new HashSet<FilesystemAlterationListener>();

    public FilesystemAlterationObserverImpl(File pRootDirectory) {
        this.rootDirectory = pRootDirectory;
        this.rootEntry = new Entry(new MonitorFileImpl(pRootDirectory));
    }

    private void notifyOnStart() {
        this.log.debug((Object)("onStart " + this.rootEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onStart(this);
        }
    }

    private void notifyOnStop() {
        this.log.debug((Object)("onStop " + this.rootEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onStop(this);
        }
    }

    private void notifyOnFileCreate(Entry pEntry) {
        this.log.debug((Object)("onFileCreate " + pEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onFileCreate(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnFileChange(Entry pEntry) {
        this.log.debug((Object)("onFileChange " + pEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onFileChange(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnFileDelete(Entry pEntry) {
        this.log.debug((Object)("onFileDelete " + pEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onFileDelete(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnDirectoryCreate(Entry pEntry) {
        this.log.debug((Object)("onDirectoryCreate " + pEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onDirectoryCreate(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnDirectoryChange(Entry pEntry) {
        this.log.debug((Object)("onDirectoryChange " + pEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onDirectoryChange(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnDirectoryDelete(Entry pEntry) {
        this.log.debug((Object)("onDirectoryDelete " + pEntry));
        for (FilesystemAlterationListener listener : this.listeners) {
            listener.onDirectoryDelete(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void checkEntries() {
        if (this.rootEntry.needsToBeDeleted()) {
            this.rootEntry.lastType = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotify() {
        Set<FilesystemAlterationListener> set = this.listenersSet;
        synchronized (set) {
            if (this.listeners.length == 0) {
                return;
            }
            this.notifyOnStart();
            this.checkEntries();
            this.notifyOnStop();
        }
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FilesystemAlterationListener pListener) {
        Set<FilesystemAlterationListener> set = this.listenersSet;
        synchronized (set) {
            if (this.listenersSet.add(pListener)) {
                this.listeners = this.createArrayFromSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FilesystemAlterationListener pListener) {
        Set<FilesystemAlterationListener> set = this.listenersSet;
        synchronized (set) {
            if (this.listenersSet.remove(pListener)) {
                this.listeners = this.createArrayFromSet();
            }
        }
    }

    private FilesystemAlterationListener[] createArrayFromSet() {
        FilesystemAlterationListener[] newListeners = new FilesystemAlterationListener[this.listenersSet.size()];
        this.listenersSet.toArray(newListeners);
        return newListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilesystemAlterationListener[] getListeners() {
        Set<FilesystemAlterationListener> set = this.listenersSet;
        synchronized (set) {
            FilesystemAlterationListener[] res = new FilesystemAlterationListener[this.listeners.length];
            System.arraycopy(this.listeners, 0, res, 0, res.length);
            return res;
        }
    }

    private final class Entry {
        private static final int TYPE_UNKNOWN = 0;
        private static final int TYPE_FILE = 1;
        private static final int TYPE_DIRECTORY = 2;
        private final MonitorFile file;
        private long lastModified = -1L;
        private int lastType = 0;
        private final Map<String, Entry> children = new HashMap<String, Entry>();

        public Entry(MonitorFile pFile) {
            this.file = pFile;
        }

        public String getName() {
            return this.file.getName();
        }

        public String toString() {
            return this.file.toString();
        }

        private void compareChildren() {
            if (!this.file.isDirectory()) {
                return;
            }
            MonitorFile[] files = this.file.listFiles();
            HashSet<Entry> deleted = new HashSet<Entry>(this.children.values());
            for (MonitorFile f : files) {
                String name = f.getName();
                Entry entry = this.children.get(name);
                if (entry != null) {
                    deleted.remove(entry);
                    if (!entry.needsToBeDeleted()) continue;
                    this.children.remove(name);
                    continue;
                }
                Entry newChild = new Entry(f);
                this.children.put(name, newChild);
                newChild.needsToBeDeleted();
            }
            for (Entry entry : deleted) {
                entry.deleteChildrenAndNotify();
                this.children.remove(entry.getName());
            }
        }

        private void deleteChildrenAndNotify() {
            for (Entry entry : this.children.values()) {
                entry.deleteChildrenAndNotify();
            }
            this.children.clear();
            if (this.lastType == 2) {
                FilesystemAlterationObserverImpl.this.notifyOnDirectoryDelete(this);
            } else if (this.lastType == 1) {
                FilesystemAlterationObserverImpl.this.notifyOnFileDelete(this);
            }
        }

        public boolean needsToBeDeleted() {
            if (!this.file.exists()) {
                this.deleteChildrenAndNotify();
                return true;
            }
            long currentModified = this.file.lastModified();
            if (currentModified != this.lastModified) {
                int newType;
                this.lastModified = currentModified;
                int n = newType = this.file.isDirectory() ? 2 : 1;
                if (this.lastType != newType) {
                    this.deleteChildrenAndNotify();
                    this.lastType = newType;
                    if (newType == 2) {
                        FilesystemAlterationObserverImpl.this.notifyOnDirectoryCreate(this);
                        this.compareChildren();
                    } else {
                        FilesystemAlterationObserverImpl.this.notifyOnFileCreate(this);
                    }
                    return false;
                }
                if (newType == 2) {
                    FilesystemAlterationObserverImpl.this.notifyOnDirectoryChange(this);
                    this.compareChildren();
                } else {
                    FilesystemAlterationObserverImpl.this.notifyOnFileChange(this);
                }
                return false;
            }
            this.compareChildren();
            return false;
        }

        public MonitorFile getFile() {
            return this.file;
        }

        public void markNotChanged() {
            this.lastModified = this.file.lastModified();
        }
    }

    private static final class MonitorFileImpl
    implements MonitorFile {
        private final File file;

        public MonitorFileImpl(File pFile) {
            this.file = pFile;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public MonitorFile[] listFiles() {
            File[] children = this.file.listFiles();
            if (children == null) {
                return new MonitorFile[0];
            }
            MonitorFile[] providers = new MonitorFile[children.length];
            for (int i = 0; i < providers.length; ++i) {
                providers[i] = new MonitorFileImpl(children[i]);
            }
            return providers;
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public long lastModified() {
            return this.file.lastModified();
        }

        public String toString() {
            return this.file.toString();
        }
    }

    private static interface MonitorFile {
        public long lastModified();

        public MonitorFile[] listFiles();

        public boolean isDirectory();

        public boolean exists();

        public String getName();
    }
}

