/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestXMLOutput
extends BaseJellyTest {
    public TestXMLOutput(String name) {
        super(name);
    }

    public void testOutputGood() throws Exception {
        this.setUpScript("outputGood.jelly");
        Script script = this.getJelly().compileScript();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        script.run(this.getJellyContext(), XMLOutput.createXMLOutput((OutputStream)bos));
        TestXMLOutput.assertEquals((String)"<html></html>x", (String)bos.toString());
    }

    public void testOutputBad() throws Exception {
        this.setUpScript("outputBad.jelly");
        Script script = this.getJelly().compileScript();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        script.run(this.getJellyContext(), XMLOutput.createXMLOutput((OutputStream)bos));
        TestXMLOutput.assertEquals((String)"<html></html>", (String)bos.toString());
    }

    public void testOutputBadGood() throws Exception {
        this.setUpScript("outputBad.jelly");
        Script script = this.getJelly().compileScript();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutput ouput = XMLOutput.createXMLOutput((OutputStream)bos);
        script.run(this.getJellyContext(), ouput);
        ouput.flush();
        TestXMLOutput.assertEquals((String)"<html></html>", (String)bos.toString());
    }

    public void testOutputData() throws Exception {
        this.setUpScript("outputData.jelly");
        Script script = this.getJelly().compileScript();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutput ouput = XMLOutput.createXMLOutput((OutputStream)bos);
        script.run(this.getJellyContext(), ouput);
        ouput.flush();
        TestXMLOutput.assertEquals((String)"[string]", (String)bos.toString().trim());
    }
}

