/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng;

import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.commons.rng.UniformRandomProviderSupport;

public interface UniformRandomProvider {
    default public void nextBytes(byte[] bytes) {
        UniformRandomProviderSupport.nextBytes(this, bytes, 0, bytes.length);
    }

    default public void nextBytes(byte[] bytes, int start, int len) {
        UniformRandomProviderSupport.validateFromIndexSize(start, len, bytes.length);
        UniformRandomProviderSupport.nextBytes(this, bytes, start, len);
    }

    default public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    default public int nextInt(int n) {
        UniformRandomProviderSupport.validateUpperBound(n);
        return UniformRandomProviderSupport.nextInt(this, n);
    }

    default public int nextInt(int origin, int bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return UniformRandomProviderSupport.nextInt(this, origin, bound);
    }

    public long nextLong();

    default public long nextLong(long n) {
        UniformRandomProviderSupport.validateUpperBound(n);
        return UniformRandomProviderSupport.nextLong(this, n);
    }

    default public long nextLong(long origin, long bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return UniformRandomProviderSupport.nextLong(this, origin, bound);
    }

    default public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    default public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    default public float nextFloat(float bound) {
        UniformRandomProviderSupport.validateUpperBound(bound);
        return UniformRandomProviderSupport.nextFloat(this, bound);
    }

    default public float nextFloat(float origin, float bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return UniformRandomProviderSupport.nextFloat(this, origin, bound);
    }

    default public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    default public double nextDouble(double bound) {
        UniformRandomProviderSupport.validateUpperBound(bound);
        return UniformRandomProviderSupport.nextDouble(this, bound);
    }

    default public double nextDouble(double origin, double bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return UniformRandomProviderSupport.nextDouble(this, origin, bound);
    }

    default public IntStream ints() {
        return IntStream.generate(this::nextInt).sequential();
    }

    default public IntStream ints(int origin, int bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return IntStream.generate(() -> this.nextInt(origin, bound)).sequential();
    }

    default public IntStream ints(long streamSize) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        return this.ints().limit(streamSize);
    }

    default public IntStream ints(long streamSize, int origin, int bound) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        UniformRandomProviderSupport.validateRange(origin, bound);
        return this.ints(origin, bound).limit(streamSize);
    }

    default public LongStream longs() {
        return LongStream.generate(this::nextLong).sequential();
    }

    default public LongStream longs(long origin, long bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return LongStream.generate(() -> this.nextLong(origin, bound)).sequential();
    }

    default public LongStream longs(long streamSize) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        return this.longs().limit(streamSize);
    }

    default public LongStream longs(long streamSize, long origin, long bound) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        UniformRandomProviderSupport.validateRange(origin, bound);
        return this.longs(origin, bound).limit(streamSize);
    }

    default public DoubleStream doubles() {
        return DoubleStream.generate(this::nextDouble).sequential();
    }

    default public DoubleStream doubles(double origin, double bound) {
        UniformRandomProviderSupport.validateRange(origin, bound);
        return DoubleStream.generate(() -> this.nextDouble(origin, bound)).sequential();
    }

    default public DoubleStream doubles(long streamSize) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        return this.doubles().limit(streamSize);
    }

    default public DoubleStream doubles(long streamSize, double origin, double bound) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        UniformRandomProviderSupport.validateRange(origin, bound);
        return this.doubles(origin, bound).limit(streamSize);
    }
}

