/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.systest.jaxws.attachment;

import java.io.InputStream;

import javax.activation.DataHandler;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.ws.soap.MTOM;

import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.helpers.IOUtils;

@WebService(name = "AttachmentService", targetNamespace = "http://org.apache.cxf/service/AttachmentService")
@SchemaValidation(type = SchemaValidation.SchemaValidationType.IN)
@MTOM(enabled = true)
public class AttachmentServiceImpl implements AttachmentService {

    @WebMethod
    public int test(@WebParam(name = "request") @XmlElement(required = true) Request request) throws Exception {
        DataHandler dataHandler = request.getContent();
        InputStream inputStream = dataHandler.getInputStream();
        return IOUtils.readBytesFromStream(inputStream).length;
    }
}
