/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.validationtransformation;

import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTransformer;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceValidator;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSDResourceValidator
implements ResourceValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(XSDResourceValidator.class);
    protected Validator validator;
    @Resource
    private WebServiceContext context;

    public XSDResourceValidator(Source xsd, ResourceTransformer resourceTransformer) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsd);
            this.validator = schema.newValidator();
        }
        catch (SAXException ex) {
            LOG.severe(ex.getLocalizedMessage());
            throw new SoapFault("Internal error", this.getSoapVersion().getReceiver());
        }
    }

    public XSDResourceValidator(Source xsd) {
        this(xsd, null);
    }

    @Override
    public boolean validate(Representation representation, Representation oldRepresentation) {
        try {
            this.validator.validate(new DOMSource((Node)representation.getAny()));
        }
        catch (SAXException ex) {
            return false;
        }
        catch (IOException ex) {
            LOG.severe(ex.getLocalizedMessage());
            throw new SoapFault("Internal error", this.getSoapVersion().getReceiver());
        }
        return true;
    }

    private SoapVersion getSoapVersion() {
        WrappedMessageContext wmc = (WrappedMessageContext)this.context.getMessageContext();
        SoapMessage message = (SoapMessage)wmc.getWrappedMessage();
        return message.getVersion();
    }
}

