/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.processor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.wss4j.common.util.DOM2Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FedizResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String audience;
    private String username;
    private List<String> roles;
    private String issuer;
    private List<Claim> claims;
    private transient Element token;
    private String tokenStr;
    private String uniqueTokenId;
    private Instant tokenCreated;
    private Instant tokenExpires;

    public FedizResponse(String username, String issuer, List<String> roles, List<Claim> claims, String audience, Instant created, Instant expires, Element token, String uniqueTokenId) {
        this.username = username;
        this.issuer = issuer;
        this.roles = roles;
        this.claims = claims;
        this.audience = audience;
        this.tokenCreated = created;
        this.tokenExpires = expires;
        this.token = token;
        this.uniqueTokenId = uniqueTokenId;
    }

    public String getUniqueTokenId() {
        return this.uniqueTokenId;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            return null;
        }
        return Collections.unmodifiableList(this.roles);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public List<Claim> getClaims() {
        if (this.claims == null) {
            return null;
        }
        return Collections.unmodifiableList(this.claims);
    }

    public Instant getTokenCreated() {
        return this.tokenCreated;
    }

    public Instant getTokenExpires() {
        return this.tokenExpires;
    }

    public Element getToken() {
        return this.token;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.token != null && this.tokenStr == null) {
            this.tokenStr = DOM2Writer.nodeToString((Node)this.token);
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, XMLStreamException, SAXException, ParserConfigurationException {
        in.defaultReadObject();
        if (this.token == null && this.tokenStr != null) {
            this.token = DOMUtils.readXml(new StringReader(this.tokenStr)).getDocumentElement();
        }
    }
}

