/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.file.Path;
import org.apache.daffodil.io.ByteArrayOrFileOutputStream;
import org.apache.daffodil.io.DOSState;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.DataOutputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.DataStreamCommonState;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream$;
import org.apache.daffodil.io.Finished$;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.Uninitialized$;
import org.apache.daffodil.io.ZeroLengthStatus;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder$MostSignificantBitFirst$;
import org.apache.daffodil.lib.util.Bits$;
import org.apache.daffodil.lib.util.LocalStack;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.Misc$;
import passera.unsigned.ULong;
import passera.unsigned.ULong$;
import scala.Byte$;
import scala.DummyImplicit$;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DirectOrBufferedDataOutputStream
implements DataStreamCommonState,
DataOutputStream,
DataStreamCommonImplMixin,
LocalBufferMixin,
DataOutputStreamImplMixin {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DirectOrBufferedDataOutputStream.class.getDeclaredField("withLocalByteBuffer$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DirectOrBufferedDataOutputStream.class.getDeclaredField("withLocalCharBuffer$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DirectOrBufferedDataOutputStream.class.getDeclaredField("id$lzy1"));
    private Object org$apache$daffodil$io$DataStreamCommonState$$maybePriorBitOrder_;
    private boolean debugging;
    private int maybeTrailingSurrogateForUTF8;
    private long priorBitPos;
    private volatile Object withLocalCharBuffer$lzy1;
    private volatile Object withLocalByteBuffer$lzy1;
    private long org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_;
    private ZeroLengthStatus org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_;
    private long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging_;
    private long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_;
    private long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_;
    private long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_;
    private long maybeAbsBitLimit0b;
    private long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_;
    private int bitStartOffset0b;
    private Object debugOutputStream;
    private int org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte_;
    private int org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit_;
    private DOSState org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState;
    private ByteBuffer unionByteBuffer;
    private DoubleBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer;
    private FloatBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer;
    private IntBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer;
    private LongBuffer unionLongBuffer;
    private DirectOrBufferedDataOutputStream splitFrom;
    private final boolean isLayer;
    private final int chunkSizeInBytes;
    private final long maxBufferSizeInBytes;
    private final File tempDirPath;
    private final Object maybeExistingFile;
    private final int layerID;
    private final int splitID;
    private volatile Object id$lzy1;
    private final ByteArrayOrFileOutputStream bufferingJOS;
    private OutputStream _javaOutputStream;
    private Object _following;
    private Object finishedFormatInfo;

    public static DirectOrBufferedDataOutputStream apply(OutputStream outputStream, DirectOrBufferedDataOutputStream directOrBufferedDataOutputStream, boolean bl, int n, long l, File file, Object object) {
        return DirectOrBufferedDataOutputStream$.MODULE$.apply(outputStream, directOrBufferedDataOutputStream, bl, n, l, file, object);
    }

    public static boolean $lessinit$greater$default$2() {
        return DirectOrBufferedDataOutputStream$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean apply$default$3() {
        return DirectOrBufferedDataOutputStream$.MODULE$.apply$default$3();
    }

    public static Object apply$default$7() {
        return DirectOrBufferedDataOutputStream$.MODULE$.apply$default$7();
    }

    public DirectOrBufferedDataOutputStream(DirectOrBufferedDataOutputStream splitFrom, boolean isLayer, int chunkSizeInBytes, long maxBufferSizeInBytes, File tempDirPath, Object maybeExistingFile) {
        int n;
        this.splitFrom = splitFrom;
        this.isLayer = isLayer;
        this.chunkSizeInBytes = chunkSizeInBytes;
        this.maxBufferSizeInBytes = maxBufferSizeInBytes;
        this.tempDirPath = tempDirPath;
        this.maybeExistingFile = maybeExistingFile;
        DataStreamCommonState.$init$(this);
        LocalBufferMixin.$init$(this);
        DataOutputStreamImplMixin.$init$(this);
        DirectOrBufferedDataOutputStream directOrBufferedDataOutputStream = this;
        synchronized (directOrBufferedDataOutputStream) {
            int n2;
            if (this.splitFrom() != null) {
                n2 = this.splitFrom().layerID();
            } else {
                int lid = DirectOrBufferedDataOutputStream$.org$apache$daffodil$io$DirectOrBufferedDataOutputStream$$$nextLayerID++;
                DirectOrBufferedDataOutputStream$ directOrBufferedDataOutputStream$ = DirectOrBufferedDataOutputStream$.MODULE$;
                n2 = lid;
            }
            n = n2;
        }
        this.layerID = n;
        this.splitID = this.splitFrom() == null ? 0 : this.splitFrom().splitID() + 1;
        this.bufferingJOS = new ByteArrayOrFileOutputStream(maxBufferSizeInBytes, tempDirPath, maybeExistingFile);
        this._javaOutputStream = this.bufferingJOS;
        this._following = Maybe$.MODULE$.Nope();
        this.finishedFormatInfo = Maybe$.MODULE$.Nope();
        Statics.releaseFence();
    }

    @Override
    public Object org$apache$daffodil$io$DataStreamCommonState$$maybePriorBitOrder_() {
        return this.org$apache$daffodil$io$DataStreamCommonState$$maybePriorBitOrder_;
    }

    @Override
    public boolean debugging() {
        return this.debugging;
    }

    @Override
    public int maybeTrailingSurrogateForUTF8() {
        return this.maybeTrailingSurrogateForUTF8;
    }

    @Override
    public long priorBitPos() {
        return this.priorBitPos;
    }

    @Override
    public void org$apache$daffodil$io$DataStreamCommonState$$maybePriorBitOrder__$eq(Object x$1) {
        this.org$apache$daffodil$io$DataStreamCommonState$$maybePriorBitOrder_ = x$1;
    }

    @Override
    public void debugging_$eq(boolean x$1) {
        this.debugging = x$1;
    }

    @Override
    public void maybeTrailingSurrogateForUTF8_$eq(int x$1) {
        this.maybeTrailingSurrogateForUTF8 = x$1;
    }

    @Override
    public void priorBitPos_$eq(long x$1) {
        this.priorBitPos = x$1;
    }

    public final LocalStack withLocalCharBuffer() {
        Object object = this.withLocalCharBuffer$lzy1;
        if (object instanceof LocalStack) {
            return (LocalStack)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LocalStack)this.withLocalCharBuffer$lzyINIT1();
    }

    private Object withLocalCharBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.withLocalCharBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LocalStack localStack = null;
                    try {
                        localStack = LocalBufferMixin.withLocalCharBuffer$(this);
                        object2 = localStack == null ? LazyVals.NullValue$.MODULE$ : localStack;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.withLocalCharBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return localStack;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final LocalStack withLocalByteBuffer() {
        Object object = this.withLocalByteBuffer$lzy1;
        if (object instanceof LocalStack) {
            return (LocalStack)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LocalStack)this.withLocalByteBuffer$lzyINIT1();
    }

    private Object withLocalByteBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.withLocalByteBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LocalStack localStack = null;
                    try {
                        localStack = LocalBufferMixin.withLocalByteBuffer$(this);
                        object2 = localStack == null ? LazyVals.NullValue$.MODULE$ : localStack;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.withLocalByteBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return localStack;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_;
    }

    @Override
    public ZeroLengthStatus org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_;
    }

    @Override
    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging_;
    }

    @Override
    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_;
    }

    @Override
    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_;
    }

    @Override
    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_;
    }

    @Override
    public long maybeAbsBitLimit0b() {
        return this.maybeAbsBitLimit0b;
    }

    @Override
    public long org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_;
    }

    @Override
    public int bitStartOffset0b() {
        return this.bitStartOffset0b;
    }

    @Override
    public Object debugOutputStream() {
        return this.debugOutputStream;
    }

    @Override
    public int org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte_;
    }

    @Override
    public int org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit_() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit_;
    }

    @Override
    public DOSState org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState;
    }

    @Override
    public ByteBuffer unionByteBuffer() {
        return this.unionByteBuffer;
    }

    @Override
    public DoubleBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer;
    }

    @Override
    public FloatBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer;
    }

    @Override
    public IntBuffer org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer() {
        return this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer;
    }

    @Override
    public LongBuffer unionLongBuffer() {
        return this.unionLongBuffer;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b__$eq(long x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$relBitPos0b_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus__$eq(ZeroLengthStatus x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$zlStatus_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging__$eq(long x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeStartingRelBitPos0bAfterMerging_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b__$eq(long x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsStartingBitPos0b_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits__$eq(long x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeAbsolutizedRelativeStartingBitPosInBits_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits__$eq(long x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeLengthInBits_ = x$1;
    }

    @Override
    public void maybeAbsBitLimit0b_$eq(long x$1) {
        this.maybeAbsBitLimit0b = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b__$eq(long x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$maybeRelBitLimit0b_ = x$1;
    }

    @Override
    public void bitStartOffset0b_$eq(int x$1) {
        this.bitStartOffset0b = x$1;
    }

    @Override
    public void debugOutputStream_$eq(Object x$1) {
        this.debugOutputStream = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte__$eq(int x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByte_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit__$eq(int x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$fragmentLastByteLimit_ = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState_$eq(DOSState x$1) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$_dosState = x$1;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$unionByteBuffer_$eq(ByteBuffer x$0) {
        this.unionByteBuffer = x$0;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer_$eq(DoubleBuffer x$0) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionDoubleBuffer = x$0;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer_$eq(FloatBuffer x$0) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionFloatBuffer = x$0;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer_$eq(IntBuffer x$0) {
        this.org$apache$daffodil$io$DataOutputStreamImplMixin$$unionIntBuffer = x$0;
    }

    @Override
    public void org$apache$daffodil$io$DataOutputStreamImplMixin$_setter_$unionLongBuffer_$eq(LongBuffer x$0) {
        this.unionLongBuffer = x$0;
    }

    @Override
    public /* synthetic */ void org$apache$daffodil$io$DataOutputStreamImplMixin$$super$assignFrom(DataStreamCommonState other) {
        DataStreamCommonState.assignFrom$(this, other);
    }

    public DirectOrBufferedDataOutputStream splitFrom() {
        return this.splitFrom;
    }

    public void splitFrom_$eq(DirectOrBufferedDataOutputStream x$1) {
        this.splitFrom = x$1;
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    @Override
    public int chunkSizeInBytes() {
        return this.chunkSizeInBytes;
    }

    @Override
    public long maxBufferSizeInBytes() {
        return this.maxBufferSizeInBytes;
    }

    @Override
    public File tempDirPath() {
        return this.tempDirPath;
    }

    @Override
    public Object maybeExistingFile() {
        return this.maybeExistingFile;
    }

    @Override
    public boolean putULong(long unsignedLong, int bitLengthFrom1To64, FormatInfo finfo) {
        boolean res = this.putLongChecked(unsignedLong, bitLengthFrom1To64, finfo);
        return res;
    }

    @Override
    public boolean putLong(long signedLong, int bitLengthFrom1To64, FormatInfo finfo) {
        boolean res = this.putLongChecked(Predef$.MODULE$.long2Long(signedLong), bitLengthFrom1To64, finfo);
        return res;
    }

    private int layerID() {
        return this.layerID;
    }

    private int splitID() {
        return this.splitID;
    }

    @Override
    public String id() {
        Object object = this.id$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.id$lzyINIT1();
    }

    private Object id$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.id$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = BoxesRunTime.boxToInteger((int)this.layerID()).toString() + "." + BoxesRunTime.boxToInteger((int)this.splitID()).toString();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.id$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean equals(Object other) {
        return package$.MODULE$.AnyRef().equals(other);
    }

    public int hashCode() {
        return package$.MODULE$.AnyRef().hashCode();
    }

    public String toString() {
        String string;
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        LazyRef lazyRef3 = new LazyRef();
        String string2 = this.id();
        DOSState dOSState = this.dosState();
        String string3 = this.isBuffering() ? ", Buffered" : ", Direct";
        if (MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitPos0b())) {
            long srt = this.isDirect() ? 0L : MaybeULong$.MODULE$.get$extension(this.maybeAbsStartingBitPos0b());
            long end = MaybeULong$.MODULE$.get$extension(this.maybeAbsBitPos0b());
            long len = ULong$.MODULE$.apply(end - srt);
            string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" Absolute from %d to %d (length %d)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)srt), BoxesRunTime.boxToLong((long)end), BoxesRunTime.boxToLong((long)len)}));
        } else {
            string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" at rel bit pos %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.relBitPos0b())}));
        }
        Object object = this._following();
        String toDisplay = "DOS(id=" + string2 + ", " + dOSState + string3 + string + (MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitLimit0b()) ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" limit %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)MaybeULong$.MODULE$.get$extension(this.maybeAbsBitLimit0b()))})) : (MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b()) ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" length limit %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)MaybeULong$.MODULE$.get$extension(this.maybeRelBitLimit0b()))})) : "")) + (String)(this.isBuffering() && !this.bufferingJOS.isFile() ? ", data=" + this.upTo16BytesInHex$1(lazyRef3, lazyRef2, lazyRef) : "") + (Maybe$.MODULE$.isEmpty$extension(object) ? " no following" : "") + ")";
        return toDisplay;
    }

    public DirectOrBufferedDataOutputStream findFirstBlocking() {
        if (MaybeULong$.MODULE$.isEmpty$extension(this.maybeAbsBitPos0b()) || !this.isFinished()) {
            return this;
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.maybeAbsBitPos0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: this.maybeAbsBitPos0b.isEmpty");
        }
        if (this.splitFrom() == null) {
            throw Assert$.MODULE$.abort("Invariant broken: this.splitFrom.ne(null)");
        }
        return this.splitFrom().findFirstBlocking();
    }

    @Override
    public final boolean isBuffering() {
        OutputStream outputStream = (OutputStream)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(this.getJavaOutputStream());
        boolean res = package$TypeEqual$.MODULE$._eq_$extension(outputStream, this.bufferingJOS, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
        return res;
    }

    @Override
    public void setJavaOutputStream(OutputStream newOutputStream) {
        if (newOutputStream == null) {
            throw Assert$.MODULE$.usageError("newOutputStream.ne(null)");
        }
        this._javaOutputStream = newOutputStream;
        if (newOutputStream == this.bufferingJOS) {
            throw Assert$.MODULE$.usageError("newOutputStream.ne(DirectOrBufferedDataOutputStream.this.bufferingJOS)");
        }
    }

    @Override
    public OutputStream getJavaOutputStream() {
        if (this._javaOutputStream == null) {
            throw Assert$.MODULE$.usageError("DirectOrBufferedDataOutputStream.this._javaOutputStream.ne(null)");
        }
        return this._javaOutputStream;
    }

    private Object _following() {
        return this._following;
    }

    private void _following_$eq(Object x$0) {
        this._following = x$0;
    }

    @Override
    public Object maybeNextInChain() {
        return this._following();
    }

    private DirectOrBufferedDataOutputStream lastInChain() {
        Object object;
        while (!Maybe$.MODULE$.isEmpty$extension(object = this_._following())) {
            Object object2 = this_._following();
            DirectOrBufferedDataOutputStream this_ = (DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object2);
        }
        return this_;
    }

    public void dumpChain() {
        for (DirectOrBufferedDataOutputStream curDOS = this.lastInChain(); curDOS != null; curDOS = curDOS.splitFrom()) {
            String marker = curDOS == this ? " > " : "   ";
            System.err.println(marker + curDOS.toString());
        }
    }

    public DirectOrBufferedDataOutputStream addBuffered() {
        DirectOrBufferedDataOutputStream buffered = new DirectOrBufferedDataOutputStream(this, this.isLayer(), this.chunkSizeInBytes(), this.maxBufferSizeInBytes(), this.tempDirPath(), Maybe$.MODULE$.Nope());
        this.addBufferedDOS(buffered);
        return buffered;
    }

    public DirectOrBufferedDataOutputStream addBufferedBlob(Path path, long lengthInBits, int blobChunkSizeInBytes, FormatInfo finfo) {
        DirectOrBufferedDataOutputStream bufferedBlob = new DirectOrBufferedDataOutputStream(this, this.isLayer(), blobChunkSizeInBytes, 0L, this.tempDirPath(), Maybe$.MODULE$.apply(path));
        this.addBufferedDOS(bufferedBlob);
        bufferedBlob.setRelBitPos0b(ULong$.MODULE$.$plus$extension(bufferedBlob.relBitPos0b(), ULong$.MODULE$.apply(lengthInBits)));
        if (lengthInBits > 0L) {
            bufferedBlob.setNonZeroLength();
        }
        bufferedBlob.setFinished(finfo);
        DirectOrBufferedDataOutputStream buffered = bufferedBlob.addBuffered();
        return buffered;
    }

    private void addBufferedDOS(DirectOrBufferedDataOutputStream newBufStr) {
        Object object = this._following();
        if (!Maybe$.MODULE$.isEmpty$extension(object)) {
            throw Assert$.MODULE$.usageError("DirectOrBufferedDataOutputStream.this._following.isEmpty");
        }
        this._following_$eq(Maybe$One$.MODULE$.apply(newBufStr));
        newBufStr.assignFrom(this);
        newBufStr.resetAllBitPos();
        if (MaybeULong$.MODULE$.isDefined$extension(this.maybeRelBitLimit0b())) {
            newBufStr.setMaybeRelBitLimit0b(MaybeULong$.MODULE$.apply(MaybeULong$.MODULE$.get$extension(this.maybeRelBitLimit0b()) - ULong$.MODULE$.toLong$extension(this.relBitPos0b())), newBufStr.setMaybeRelBitLimit0b$default$2());
            return;
        }
    }

    private void convertToDirect(DirectOrBufferedDataOutputStream oldDirectDOS) {
        if (!this.isBuffering()) {
            throw Assert$.MODULE$.usageError("DirectOrBufferedDataOutputStream.this.isBuffering");
        }
        if (!oldDirectDOS.isDirect()) {
            throw Assert$.MODULE$.usageError("oldDirectDOS.isDirect");
        }
        this.setJavaOutputStream(oldDirectDOS.getJavaOutputStream());
        if (!this.isDirect()) {
            throw Assert$.MODULE$.abort("Invariant broken: DirectOrBufferedDataOutputStream.this.isDirect");
        }
        this.setAbsStartingBitPos0b(ULong$.MODULE$.apply(0L));
        if (!MaybeULong$.MODULE$.isDefined$extension(oldDirectDOS.maybeAbsStartingBitPos0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: oldDirectDOS.maybeAbsStartingBitPos0b.isDefined");
        }
        long mabl = oldDirectDOS.maybeAbsBitLimit0b();
        long absLargerLimit = scala.math.package$.MODULE$.max(MaybeULong$.MODULE$.isDefined$extension(mabl) ? MaybeULong$.MODULE$.get$extension(mabl) : 0L, MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitLimit0b()) ? MaybeULong$.MODULE$.get$extension(this.maybeAbsBitLimit0b()) : 0L);
        if (MaybeULong$.MODULE$.isDefined$extension(mabl) || MaybeULong$.MODULE$.isDefined$extension(this.maybeAbsBitLimit0b())) {
            long newRelLimit = absLargerLimit - MaybeULong$.MODULE$.get$extension(this.maybeAbsStartingBitPos0b());
            this.setMaybeRelBitLimit0b(MaybeULong$.MODULE$.apply(newRelLimit), this.setMaybeRelBitLimit0b$default$2());
        }
        this.setFragmentLastByte(oldDirectDOS.fragmentLastByte(), oldDirectDOS.fragmentLastByteLimit());
        this.splitFrom_$eq(null);
        if (!this.isDirect()) {
            throw Assert$.MODULE$.abort("Invariant broken: DirectOrBufferedDataOutputStream.this.isDirect");
        }
    }

    private Object finishedFormatInfo() {
        return this.finishedFormatInfo;
    }

    private void finishedFormatInfo_$eq(Object x$0) {
        this.finishedFormatInfo = x$0;
    }

    @Override
    public void setFinished(FormatInfo finfo) {
        if (this.isFinished()) {
            throw Assert$.MODULE$.usageError("DirectOrBufferedDataOutputStream.this.isFinished.unary_!");
        }
        Object object = this.finishedFormatInfo();
        if (!Maybe$.MODULE$.isEmpty$extension(object)) {
            throw Assert$.MODULE$.usageError("DirectOrBufferedDataOutputStream.this.finishedFormatInfo.isEmpty");
        }
        this.finishedFormatInfo_$eq(Maybe$One$.MODULE$.apply(finfo));
        if (this.isDirect()) {
            Object object2;
            DirectOrBufferedDataOutputStream directStream = this;
            boolean keepMerging = true;
            while (Maybe$.MODULE$.isDefined$extension(object2 = directStream._following()) && keepMerging) {
                Object object3 = directStream._following();
                DirectOrBufferedDataOutputStream first = (DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object3);
                keepMerging = first.isFinished();
                if (!first.isBuffering()) {
                    throw Assert$.MODULE$.abort("Invariant broken: first.isBuffering");
                }
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("merging direct DOS {} into DOS {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{directStream, first}), Object.class));
                }
                long dabp = MaybeULong$.MODULE$.getULong$extension(directStream.maybeAbsBitPos0b());
                if (MaybeULong$.MODULE$.isEmpty$extension(first.maybeAbsStartingBitPos0b())) {
                    first.setAbsStartingBitPos0b(dabp);
                }
                Object object4 = directStream.finishedFormatInfo();
                DirectOrBufferedDataOutputStream$.MODULE$.org$apache$daffodil$io$DirectOrBufferedDataOutputStream$$$deliverBufferContent(directStream, first, (FormatInfo)Maybe$.MODULE$.get$extension(object4));
                first.convertToDirect(directStream);
                directStream.setDOSState(Uninitialized$.MODULE$);
                directStream = first;
                Logger LoggerImpl_this2 = Logger$.MODULE$.log();
                if (!LoggerImpl_this2.underlying().isDebugEnabled()) continue;
                LoggerImpl_this2.underlying().debug("New direct DOS {}", (Object)directStream);
            }
            Object object5 = directStream._following();
            if (Maybe$.MODULE$.isDefined$extension(object5)) {
                Object object6;
                if (keepMerging) {
                    throw Assert$.MODULE$.abort("Invariant broken: keepMerging.unary_!");
                }
                if (!directStream.isActive()) {
                    throw Assert$.MODULE$.abort("Invariant broken: directStream.isActive");
                }
                Object object7 = directStream._following();
                if (!((DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object7)).isActive() && !((DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object6 = directStream._following())).isFinished()) {
                    throw Assert$.MODULE$.abort("Invariant broken: directStream._following.get.isActive.||(directStream._following.get.isFinished)");
                }
                return;
            }
            if (keepMerging) {
                if (directStream.cst().fragmentLastByteLimit() > 0) {
                    directStream.getJavaOutputStream().write(directStream.cst().fragmentLastByte());
                    directStream.cst().setFragmentLastByte(0, 0);
                }
                directStream.getJavaOutputStream().flush();
                if (directStream.isLayer()) {
                    OutputStream jos = directStream.getJavaOutputStream();
                    jos.close();
                }
                directStream.setDOSState(Uninitialized$.MODULE$);
                return;
            }
            if (!directStream.isActive()) {
                throw Assert$.MODULE$.abort("Invariant broken: directStream.isActive");
            }
            return;
        }
        if (!this.isBuffering()) {
            throw Assert$.MODULE$.abort("Invariant broken: DirectOrBufferedDataOutputStream.this.isBuffering");
        }
        this.setDOSState(Finished$.MODULE$);
        this.getJavaOutputStream().close();
        Object object8 = this._following();
        if (Maybe$.MODULE$.isDefined$extension(object8)) {
            Object object9 = this._following();
            DirectOrBufferedDataOutputStream f = (DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object9);
            f.maybeAbsBitPos0b();
            return;
        }
    }

    @Override
    public long maybeAbsBitPos0b() {
        long mSuper = DataOutputStreamImplMixin.maybeAbsBitPos0b$(this);
        if (MaybeULong$.MODULE$.isDefined$extension(mSuper)) {
            return mSuper;
        }
        if (this.splitFrom() == null) {
            return MaybeULong$.MODULE$.Nope();
        }
        DirectOrBufferedDataOutputStream prior = this.splitFrom();
        if (prior == null) {
            throw Assert$.MODULE$.abort("Invariant broken: prior.ne(null)");
        }
        Object object = prior._following();
        if (!Maybe$.MODULE$.isDefined$extension(object)) {
            throw Assert$.MODULE$.abort("Invariant broken: prior._following.isDefined");
        }
        Object object2 = prior._following();
        if ((DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object2) != this) {
            throw Assert$.MODULE$.abort("Invariant broken: prior._following.get.eq(this)");
        }
        if (prior.isFinished()) {
            long pmabp = prior.maybeAbsBitPos0b();
            if (MaybeULong$.MODULE$.isDefined$extension(pmabp)) {
                long pabp = MaybeULong$.MODULE$.getULong$extension(pmabp);
                this.setAbsStartingBitPos0b(pabp);
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("for {} propagated absolute starting bit pos {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this, new ULong(pabp)}), Object.class));
                }
                return DataOutputStreamImplMixin.maybeAbsBitPos0b$(this);
            }
            return MaybeULong$.MODULE$.Nope();
        }
        return MaybeULong$.MODULE$.Nope();
    }

    @Override
    public final boolean putLong_BE_MSBFirst(long signedLong, int bitLengthFrom1To64) {
        int nBitsRemaining = bitLengthFrom1To64;
        long mask = bitLengthFrom1To64 == 64 ? (long)-1 : ((long)1 << bitLengthFrom1To64) - 1L;
        long bits = signedLong & mask;
        if (this.fragmentLastByteLimit() > 0) {
            int nFragBitsAvailableToWrite = 8 - this.fragmentLastByteLimit();
            int nBitsOfFragToBeFilled = bitLengthFrom1To64 >= nFragBitsAvailableToWrite ? nFragBitsAvailableToWrite : bitLengthFrom1To64;
            int nFragBitsAfter = this.fragmentLastByteLimit() + nBitsOfFragToBeFilled;
            long bitsToGoIntoFrag = bits >> bitLengthFrom1To64 - nBitsOfFragToBeFilled;
            long bitsToGoIntoFragInPosition = bitsToGoIntoFrag << 8 - nFragBitsAfter;
            int newFragByte = Bits$.MODULE$.asUnsignedByte((long)this.fragmentLastByte() | bitsToGoIntoFragInPosition);
            if (newFragByte > 255 || newFragByte < 0) {
                throw Assert$.MODULE$.abort("Invariant broken: newFragByte.<=(255).&&(newFragByte.>=(0))");
            }
            int shift1 = 64 - (bitLengthFrom1To64 - nBitsOfFragToBeFilled);
            bits = bits << shift1 >>> shift1;
            nBitsRemaining = bitLengthFrom1To64 - nBitsOfFragToBeFilled;
            this.handleFragmentLastByte(nFragBitsAfter, newFragByte, this.realStream());
        }
        if (nBitsRemaining < 0) {
            throw Assert$.MODULE$.abort("Invariant broken: nBitsRemaining.>=(0)");
        }
        if (nBitsRemaining == 0) {
            return true;
        }
        if (this.fragmentLastByteLimit() != 0) {
            throw Assert$.MODULE$.abort("Invariant broken: DirectOrBufferedDataOutputStream.this.fragmentLastByteLimit.==(0)");
        }
        int nWholeBytes = nBitsRemaining / 8;
        int nFragBits = nBitsRemaining % 8;
        int shift = 64 - nBitsRemaining;
        long shiftedBits = bits << shift;
        for (int i = 0; i < nWholeBytes; ++i) {
            long byt = shiftedBits >>> 56;
            if (byt > 255L) {
                throw Assert$.MODULE$.abort("Invariant broken: byt.<=(255)");
            }
            this.realStream().write(Byte$.MODULE$.byte2int((byte)byt));
            shiftedBits <<= 8;
        }
        if (nFragBits > 0) {
            long newFragByte = shiftedBits >>> 56;
            this.setFragmentLastByte((int)newFragByte, nFragBits);
        }
        return true;
    }

    private void handleFragmentLastByte(int nFragBitsAfter, int newFragByte, OutputStream realStream) {
        if (nFragBitsAfter == 8) {
            realStream.write(Byte$.MODULE$.byte2int((byte)newFragByte));
            this.setFragmentLastByte(0, 0);
            return;
        }
        this.setFragmentLastByte(newFragByte, nFragBitsAfter);
    }

    @Override
    public final boolean putLong_LE_MSBFirst(long signedLong, int bitLengthFrom1To64) {
        int bitLengthRemaining;
        long bits = signedLong;
        int nWholeBytesAtStart = bitLengthFrom1To64 / 8;
        int nUsedBitsLastByte = bitLengthFrom1To64 % 8;
        int nUnusedBitsLastByte = nUsedBitsLastByte == 0 ? 0 : 8 - nUsedBitsLastByte;
        int indexOfLastByteLE = nWholeBytesAtStart - (nUnusedBitsLastByte > 0 ? 0 : 1);
        this.unionLongBuffer().put(0, bits);
        Bits$.MODULE$.reverseBytes(this.unionByteBuffer());
        byte lastByte = this.unionByteBuffer().get(indexOfLastByteLE);
        byte newLastByte = (byte)(lastByte << nUnusedBitsLastByte & 0xFF);
        this.unionByteBuffer().put(indexOfLastByteLE, newLastByte);
        int nBitsOfFragToBeFilled = 0;
        if (this.fragmentLastByteLimit() > 0) {
            int nFragBitsAvailableToWrite = 8 - this.fragmentLastByteLimit();
            nBitsOfFragToBeFilled = bitLengthFrom1To64 >= nFragBitsAvailableToWrite ? nFragBitsAvailableToWrite : bitLengthFrom1To64;
            int nFragBitsAfter = this.fragmentLastByteLimit() + nBitsOfFragToBeFilled;
            int newFragBitsMask = (byte)128 >> nBitsOfFragToBeFilled - 1 & 0xFF;
            byte LSByte = this.unionByteBuffer().get(0);
            int bitsToGoIntoFragInPosition = (LSByte & newFragBitsMask & 0xFF) >>> this.fragmentLastByteLimit();
            int newFragByte = Bits$.MODULE$.asUnsignedByte((byte)(this.fragmentLastByte() | bitsToGoIntoFragInPosition));
            this.handleFragmentLastByte(nFragBitsAfter, newFragByte, this.realStream());
            bits = this.unionLongBuffer().get(0);
            this.unionLongBuffer().put(0, bits <<= nBitsOfFragToBeFilled);
        }
        if ((bitLengthRemaining = bitLengthFrom1To64 - nBitsOfFragToBeFilled) < 0) {
            throw Assert$.MODULE$.abort("Invariant broken: bitLengthRemaining.>=(0)");
        }
        if (bitLengthRemaining > 0) {
            int nWholeBytesNow = bitLengthRemaining / 8;
            int nBitsInFinalFrag = bitLengthRemaining % 8;
            int indexOfFinalFragByte = nWholeBytesNow;
            for (int i = 0; i < nWholeBytesNow; ++i) {
                this.realStream().write(Byte$.MODULE$.byte2int(this.unionByteBuffer().get(i)));
            }
            if (nBitsInFinalFrag > 0) {
                int finalFragByte = Bits$.MODULE$.asUnsignedByte(this.unionByteBuffer().get(indexOfFinalFragByte));
                this.setFragmentLastByte(finalFragByte, nBitsInFinalFrag);
            }
        }
        return true;
    }

    @Override
    public final boolean putLong_LE_LSBFirst(long signedLong, int bitLengthFrom1To64) {
        int nBitsRemaining = bitLengthFrom1To64;
        long bits = signedLong;
        if (this.fragmentLastByteLimit() > 0) {
            int nFragBitsAvailableToWrite = 8 - this.fragmentLastByteLimit();
            int nBitsOfFragToBeFilled = bitLengthFrom1To64 >= nFragBitsAvailableToWrite ? nFragBitsAvailableToWrite : bitLengthFrom1To64;
            int nFragBitsAfter = this.fragmentLastByteLimit() + nBitsOfFragToBeFilled;
            int fragLastByteMask = 255 >> 8 - nFragBitsAfter;
            int bitsToGoIntoFragInPosition = (int)(bits << this.fragmentLastByteLimit() & (long)fragLastByteMask);
            int newFragByte = this.fragmentLastByte() | bitsToGoIntoFragInPosition;
            if (newFragByte > 255 || newFragByte < 0) {
                throw Assert$.MODULE$.abort("Invariant broken: newFragByte.<=(255).&&(newFragByte.>=(0))");
            }
            bits >>>= nBitsOfFragToBeFilled;
            nBitsRemaining = bitLengthFrom1To64 - nBitsOfFragToBeFilled;
            this.handleFragmentLastByte(nFragBitsAfter, newFragByte, this.realStream());
        }
        if (nBitsRemaining < 0) {
            throw Assert$.MODULE$.abort("Invariant broken: nBitsRemaining.>=(0)");
        }
        if (nBitsRemaining == 0) {
            return true;
        }
        if (this.fragmentLastByteLimit() != 0) {
            throw Assert$.MODULE$.abort("Invariant broken: DirectOrBufferedDataOutputStream.this.fragmentLastByteLimit.==(0)");
        }
        int nWholeBytes = nBitsRemaining / 8;
        int nFragBits = nBitsRemaining % 8;
        int fragUsedBitsMask = (1 << nFragBits) - 1;
        long shiftedBits = bits;
        for (int i = 0; i < nWholeBytes; ++i) {
            long byt = shiftedBits & 0xFFL;
            this.realStream().write(Byte$.MODULE$.byte2int((byte)byt));
            shiftedBits >>>= 8;
        }
        if (nFragBits > 0) {
            int newFragByte = Bits$.MODULE$.asUnsignedByte((byte)(shiftedBits & (long)fragUsedBitsMask));
            this.setFragmentLastByte(newFragByte, nFragBits);
        }
        return true;
    }

    public void deliverContent(DirectOrBufferedDataOutputStream directDOS, FormatInfo finfo) {
        long wholeBytesWritten;
        long bufferNBits = this.relBitPos0b();
        ByteArrayOrFileOutputStream bufOS = this.bufferingJOS;
        long nBytes = ULong$.MODULE$.$div$extension(bufferNBits, 8, DummyImplicit$.MODULE$.dummyImplicit());
        int nFragBits = this.fragmentLastByteLimit();
        if (bufOS.isFile()) {
            long l;
            bufOS.close();
            try {
                l = directDOS.putFile(bufOS.getFile().toPath(), ULong$.MODULE$.toLong$extension(bufferNBits), this.chunkSizeInBytes(), finfo);
            }
            finally {
                if (bufOS.isTempFile()) {
                    bufOS.getFile().delete();
                }
            }
            long nBitsPut = l;
            v1 = nBitsPut / 8L;
        } else {
            if (nBytes > Integer.MAX_VALUE) {
                throw Assert$.MODULE$.abort("Invariant broken: nBytes.<=(scala.Int.MaxValue)");
            }
            v1 = wholeBytesWritten = directDOS.putBytes(bufOS.getBuf(), 0, (int)nBytes, finfo);
        }
        if (nBytes != wholeBytesWritten) {
            throw Assert$.MODULE$.abort("Invariant broken: nBytes.==(wholeBytesWritten)");
        }
        if (nFragBits > 0) {
            if (directDOS.isEndOnByteBoundary()) {
                directDOS.setFragmentLastByte(this.fragmentLastByte(), this.fragmentLastByteLimit());
            } else {
                int fragNum;
                int origfrag = this.fragmentLastByte();
                int n = fragNum = finfo.bitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$ ? origfrag >> 8 - nFragBits : origfrag;
                if (!directDOS.putLongUnchecked(Int$.MODULE$.int2long(fragNum), nFragBits, finfo, this.bufferingJOS.isFile())) {
                    throw Assert$.MODULE$.abort("Invariant broken: directDOS.putLongUnchecked(scala.Int.int2long(fragNum), nFragBits, finfo, ignoreByteOrder = this.bufferingJOS.isFile)");
                }
            }
        }
        bufOS.close();
    }

    @Override
    public void cleanUp() {
        Object object;
        if (this.isBuffering() && this.bufferingJOS.isTempFile()) {
            this.bufferingJOS.getFile().delete();
        }
        while (Maybe$.MODULE$.isDefined$extension(object = this._following())) {
            Object object2 = this._following();
            ((DirectOrBufferedDataOutputStream)Maybe$.MODULE$.get$extension(object2)).cleanUp();
        }
    }

    private final byte[] buf$lzyINIT1$1(LazyRef buf$lzy1$1) {
        byte[] byArray;
        LazyRef lazyRef = buf$lzy1$1;
        synchronized (lazyRef) {
            byArray = (byte[])(buf$lzy1$1.initialized() ? buf$lzy1$1.value() : buf$lzy1$1.initialize((Object)this.bufferingJOS.getBuf()));
        }
        return byArray;
    }

    private final byte[] buf$1(LazyRef buf$lzy1$2) {
        return (byte[])(buf$lzy1$2.initialized() ? buf$lzy1$2.value() : (Object)this.buf$lzyINIT1$1(buf$lzy1$2));
    }

    private final byte[] max16ByteArray$lzyINIT1$1(LazyRef max16ByteArray$lzy1$1, LazyRef buf$lzy1$3) {
        byte[] byArray;
        LazyRef lazyRef = max16ByteArray$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (max16ByteArray$lzy1$1.initialized()) {
                object = max16ByteArray$lzy1$1.value();
            } else {
                Object object2 = Predef$.MODULE$.byteArrayOps(this.buf$1(buf$lzy1$3));
                object = max16ByteArray$lzy1$1.initialize((Object)((byte[])ArrayOps$.MODULE$.slice$extension(object2, 0, 16)));
            }
            byArray = (byte[])object;
        }
        return byArray;
    }

    private final byte[] max16ByteArray$1(LazyRef max16ByteArray$lzy1$2, LazyRef buf$lzy1$4) {
        return (byte[])(max16ByteArray$lzy1$2.initialized() ? max16ByteArray$lzy1$2.value() : (Object)this.max16ByteArray$lzyINIT1$1(max16ByteArray$lzy1$2, buf$lzy1$4));
    }

    private final String upTo16BytesInHex$lzyINIT1$1(LazyRef upTo16BytesInHex$lzy1$1, LazyRef max16ByteArray$lzy1$3, LazyRef buf$lzy1$5) {
        String string;
        LazyRef lazyRef = upTo16BytesInHex$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(upTo16BytesInHex$lzy1$1.initialized() ? upTo16BytesInHex$lzy1$1.value() : upTo16BytesInHex$lzy1$1.initialize((Object)Misc$.MODULE$.bytes2Hex(this.max16ByteArray$1(max16ByteArray$lzy1$3, buf$lzy1$5))));
        }
        return string;
    }

    private final String upTo16BytesInHex$1(LazyRef upTo16BytesInHex$lzy1$2, LazyRef max16ByteArray$lzy1$4, LazyRef buf$lzy1$6) {
        return (String)(upTo16BytesInHex$lzy1$2.initialized() ? upTo16BytesInHex$lzy1$2.value() : this.upTo16BytesInHex$lzyINIT1$1(upTo16BytesInHex$lzy1$2, max16ByteArray$lzy1$4, buf$lzy1$6));
    }
}

