/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.daffodil.io.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSize;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$;
import org.apache.daffodil.io.processors.charset.ProxyJavaCharsetEncoder;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder$MostSignificantBitFirst$;
import org.apache.daffodil.lib.util.MaybeInt$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public final class BitsCharsetNonByteSizeEncoder
extends BitsCharsetEncoder {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(BitsCharsetNonByteSizeEncoder.class.getDeclaredField("proxy$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BitsCharsetNonByteSizeEncoder.class.getDeclaredField("ProxyJavaCharset$lzy1"));
    private final BitsCharsetNonByteSize bitsCharset;
    private final int replacementChar;
    private final BitsCharsetNonByteSizeEncoder thisEncoder;
    private volatile Object ProxyJavaCharset$lzy1;
    private volatile Object proxy$lzy1;
    private int partialByte;
    private int partialByteLenInBits;

    public BitsCharsetNonByteSizeEncoder(BitsCharsetNonByteSize bitsCharset, int replacementChar) {
        this.bitsCharset = bitsCharset;
        this.replacementChar = replacementChar;
        this.thisEncoder = this;
        this.partialByte = 0;
        this.partialByteLenInBits = 0;
    }

    @Override
    public BitsCharsetNonByteSize bitsCharset() {
        return this.bitsCharset;
    }

    public final int bitWidthOfACodeUnit() {
        return this.bitsCharset().bitWidthOfACodeUnit();
    }

    public final BitOrder requiredBitOrder() {
        return this.bitsCharset().requiredBitOrder();
    }

    public float averageCharsPerBit() {
        return this.bitsCharset().averageCharsPerBit();
    }

    public float averageCharsPerByte() {
        return this.bitsCharset().averageCharsPerByte();
    }

    public float maxCharsPerBit() {
        return this.bitsCharset().maxCharsPerBit();
    }

    public float maxCharsPerByte() {
        return this.bitsCharset().maxCharsPerByte();
    }

    @Override
    public float averageBitsPerChar() {
        return this.bitsCharset().averageBitsPerChar();
    }

    @Override
    public float averageBytesPerChar() {
        return this.bitsCharset().averageBytesPerChar();
    }

    @Override
    public float maxBitsPerChar() {
        return this.bitsCharset().maxBitsPerChar();
    }

    @Override
    public float maxBytesPerChar() {
        return this.bitsCharset().maxBytesPerChar();
    }

    @Override
    public boolean isMandatoryAlignmentNeeded() {
        return false;
    }

    public BitsCharsetNonByteSizeEncoder thisEncoder() {
        return this.thisEncoder;
    }

    public final BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$ ProxyJavaCharset() {
        Object object = this.ProxyJavaCharset$lzy1;
        if (object instanceof BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$) {
            return (BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$)this.ProxyJavaCharset$lzyINIT1();
    }

    private Object ProxyJavaCharset$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ProxyJavaCharset$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$ bitsCharsetNonByteSizeEncoder$ProxyJavaCharset$ = null;
                    try {
                        bitsCharsetNonByteSizeEncoder$ProxyJavaCharset$ = new BitsCharsetNonByteSizeEncoder$ProxyJavaCharset$(this);
                        object2 = bitsCharsetNonByteSizeEncoder$ProxyJavaCharset$ == null ? LazyVals.NullValue$.MODULE$ : bitsCharsetNonByteSizeEncoder$ProxyJavaCharset$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ProxyJavaCharset$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bitsCharsetNonByteSizeEncoder$ProxyJavaCharset$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private ProxyJavaCharsetEncoder proxy() {
        Object object = this.proxy$lzy1;
        if (object instanceof ProxyJavaCharsetEncoder) {
            return (ProxyJavaCharsetEncoder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ProxyJavaCharsetEncoder)this.proxy$lzyINIT1();
    }

    private Object proxy$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.proxy$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ProxyJavaCharsetEncoder proxyJavaCharsetEncoder = null;
                    try {
                        proxyJavaCharsetEncoder = new ProxyJavaCharsetEncoder(this.ProxyJavaCharset(), this);
                        object2 = proxyJavaCharsetEncoder == null ? LazyVals.NullValue$.MODULE$ : proxyJavaCharsetEncoder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.proxy$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return proxyJavaCharsetEncoder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public CodingErrorAction malformedInputAction() {
        return this.proxy().malformedInputAction();
    }

    @Override
    public CodingErrorAction unmappableCharacterAction() {
        return this.proxy().unmappableCharacterAction();
    }

    @Override
    public BitsCharsetEncoder onMalformedInput(CodingErrorAction action) {
        this.proxy().onMalformedInput(action);
        return this;
    }

    @Override
    public BitsCharsetEncoder onUnmappableCharacter(CodingErrorAction action) {
        this.proxy().onUnmappableCharacter(action);
        return this;
    }

    @Override
    public byte[] replacement() {
        return this.proxy().replacement();
    }

    @Override
    public BitsCharsetEncoder replaceWith(byte[] newReplacement) {
        this.proxy().replaceWith(newReplacement);
        return this;
    }

    @Override
    public CoderResult encode(CharBuffer in, ByteBuffer out, boolean endOfInput) {
        return this.proxy().encode(in, out, endOfInput);
    }

    @Override
    public CoderResult flush(ByteBuffer out) {
        return this.proxy().flush(out);
    }

    @Override
    public BitsCharsetEncoder reset() {
        this.partialByte = 0;
        this.partialByteLenInBits = 0;
        this.proxy().reset();
        this.isReset_$eq(true);
        return this;
    }

    @Override
    public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        this.isReset_$eq(false);
        while (true) {
            int unusedPartialByteMask;
            int unusedPartialByteBits;
            int n;
            boolean inHasRemainingData = in.hasRemaining();
            boolean outHasRemainingSpace = out.hasRemaining();
            if (!inHasRemainingData) {
                if (this.partialByteLenInBits > 0) {
                    if (!outHasRemainingSpace) {
                        return CoderResult.OVERFLOW;
                    }
                    out.put((byte)this.partialByte);
                    this.partialByte = 0;
                    this.partialByteLenInBits = 0;
                    return CoderResult.UNDERFLOW;
                }
                return CoderResult.UNDERFLOW;
            }
            if (!outHasRemainingSpace) {
                return CoderResult.OVERFLOW;
            }
            long charCode = this.charToCharCode(in.get());
            if (MaybeInt$.MODULE$.isDefined$extension(charCode)) {
                n = MaybeInt$.MODULE$.get$extension(charCode);
            } else {
                CodingErrorAction unmappableAction;
                CodingErrorAction codingErrorAction = unmappableAction = this.unmappableCharacterAction();
                CodingErrorAction codingErrorAction2 = CodingErrorAction.REPLACE;
                if (!(codingErrorAction != null ? !codingErrorAction.equals(codingErrorAction2) : codingErrorAction2 != null)) {
                    n = this.replacementChar;
                } else {
                    CodingErrorAction codingErrorAction3 = unmappableAction;
                    CodingErrorAction codingErrorAction4 = CodingErrorAction.REPORT;
                    if (codingErrorAction3 == null ? codingErrorAction4 != null : !codingErrorAction3.equals(codingErrorAction4)) {
                        throw Assert$.MODULE$.abort("Invariant broken: unmappableAction.==(java.nio.charset.CodingErrorAction.REPORT)");
                    }
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
            }
            int charCodeToWrite = n;
            if (this.partialByteLenInBits == 0) {
                this.partialByte = this.requiredBitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$ ? charCodeToWrite << 8 - this.bitWidthOfACodeUnit() : charCodeToWrite;
                this.partialByteLenInBits = this.bitWidthOfACodeUnit();
            } else if (this.partialByteLenInBits + this.bitWidthOfACodeUnit() >= 8) {
                int nUsedBits = 8 - this.partialByteLenInBits;
                if (this.requiredBitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$) {
                    int nLeftOverBits = this.bitWidthOfACodeUnit() - nUsedBits;
                    if (nLeftOverBits < 0) {
                        throw Assert$.MODULE$.abort("Invariant broken: nLeftOverBits.>=(0)");
                    }
                    this.partialByte |= charCodeToWrite >> nLeftOverBits & 0xFF;
                    out.put((byte)this.partialByte);
                    int leftOverMask = (1 << nLeftOverBits) - 1;
                    int newPartialByte = (charCodeToWrite & leftOverMask) << 8 - nLeftOverBits;
                    this.partialByte = newPartialByte & 0xFF;
                    this.partialByteLenInBits = nLeftOverBits;
                } else {
                    this.partialByte |= charCodeToWrite << this.partialByteLenInBits & 0xFF;
                    out.put((byte)this.partialByte);
                    this.partialByte = charCodeToWrite >> nUsedBits;
                    this.partialByteLenInBits = this.bitWidthOfACodeUnit() - nUsedBits;
                }
            } else {
                this.partialByte = this.requiredBitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$ ? (this.partialByte |= charCodeToWrite << 8 - this.partialByteLenInBits - this.bitWidthOfACodeUnit() & 0xFF) : (this.partialByte |= charCodeToWrite << this.partialByteLenInBits & 0xFF);
                this.partialByteLenInBits = this.bitWidthOfACodeUnit() + this.partialByteLenInBits;
            }
            if ((unusedPartialByteBits = this.partialByte & (unusedPartialByteMask = this.requiredBitOrder() == BitOrder$MostSignificantBitFirst$.MODULE$ ? (1 << 8 - this.partialByteLenInBits) - 1 : -1 << this.partialByteLenInBits & 0xFF)) == 0) continue;
            throw Assert$.MODULE$.abort("Invariant broken: {\n  val unusedPartialByteMask: scala.Int = if (BitsCharsetNonByteSizeEncoder.this.requiredBitOrder.eq(org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder.MostSignificantBitFirst)) 1.<<(8.-(BitsCharsetNonByteSizeEncoder.this.partialByteLenInBits)).-(1) else -1.<<(BitsCharsetNonByteSizeEncoder.this.partialByteLenInBits).&(255)\n  val unusedPartialByteBits: scala.Int = BitsCharsetNonByteSizeEncoder.this.partialByte.&(unusedPartialByteMask)\n  unusedPartialByteBits.==(0)\n}");
        }
        throw Assert$.MODULE$.impossible("Incorrect return from encodeLoop");
    }

    public long charToCharCode(char c) {
        return this.bitsCharset().charToCode(c);
    }
}

