/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.OccursCountKind;
import org.apache.daffodil.lib.schema.annotation.props.gen.OccursCountKind$Implicit$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.runtime1.infoset.InfosetAccessor;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.SequenceRuntimeData;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.EndArrayChecksMixin;
import org.apache.daffodil.runtime1.processors.parsers.MinMaxRepeatsMixin;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import org.apache.daffodil.unparsers.runtime1.SequenceChildUnparser;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class RepeatingChildUnparser
extends SequenceChildUnparser
implements MinMaxRepeatsMixin,
EndArrayChecksMixin {
    private OccursCountKind ock;
    private long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_;
    private long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_;
    private boolean org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_;
    private final Unparser childUnparser;
    private final SequenceRuntimeData srd;
    private final ElementRuntimeData erd;

    public RepeatingChildUnparser(Unparser childUnparser, SequenceRuntimeData srd, ElementRuntimeData erd) {
        this.childUnparser = childUnparser;
        this.srd = srd;
        this.erd = erd;
        super(childUnparser, srd, erd);
        MinMaxRepeatsMixin.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public final OccursCountKind ock() {
        return this.ock;
    }

    @Override
    public long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_() {
        return this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_;
    }

    @Override
    public long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_() {
        return this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_;
    }

    @Override
    public boolean org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_() {
        return this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$ock_$eq(OccursCountKind x$0) {
        this.ock = x$0;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats__$eq(long x$0) {
        this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_ = x$0;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats__$eq(long x$0) {
        this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_ = x$0;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax__$eq(boolean x$0) {
        this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_ = x$0;
    }

    @Override
    public Unparser childUnparser() {
        return this.childUnparser;
    }

    @Override
    public SequenceRuntimeData srd() {
        return this.srd;
    }

    @Override
    public ElementRuntimeData erd() {
        return this.erd;
    }

    @Override
    public void unparse(UState state) {
        this.childUnparser().unparse1(state, this.childUnparser().unparse1$default$2());
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public String toString() {
        return "RepUnparser(" + this.childUnparser().toString() + ")";
    }

    @Override
    public String toBriefXML(int depthLimit) {
        if (depthLimit == 0) {
            return "...";
        }
        return "<RepUnparser name='" + this.erd().name() + "'>" + this.childUnparser().toBriefXML(depthLimit - 1) + "</RepUnparser>";
    }

    @Override
    public int toBriefXML$default$1() {
        return -1;
    }

    public final void startArrayOrOptional(UState state) {
        InfosetAccessor ev = (InfosetAccessor)state.inspectAccessor();
        if (ev.erd().isArray()) {
            InfosetAccessor event = state.advanceOrError();
            if (!event.isStart() || !event.isArray()) {
                throw Assert$.MODULE$.abort("Invariant broken: event.isStart.&&(event.isArray)");
            }
            state.inspect();
            return;
        }
    }

    public final void endArrayOrOptional(ElementRuntimeData currentArrayERD, UState state) {
        InfosetAccessor event;
        if (!(!currentArrayERD.isArray() || (event = state.advanceOrError()).isEnd() && event.isArray())) {
            throw this.UE(state, "Expected array end event for %s, but received %s.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.erd().namedQName().toExtendedSyntax(), event}));
        }
        this.endArray(state, state.occursPos() - 1L);
    }

    public final boolean shouldDoUnparser(RepeatingChildUnparser unparser, UState state) {
        boolean bl;
        TermRuntimeData childRD = unparser.trd();
        TermRuntimeData termRuntimeData = childRD;
        if (termRuntimeData instanceof ElementRuntimeData) {
            ElementRuntimeData erd = (ElementRuntimeData)termRuntimeData;
            if (state.inspect()) {
                InfosetAccessor ev = (InfosetAccessor)state.inspectAccessor();
                if (ev.isStart()) {
                    bl = ev.erd() == erd;
                } else {
                    if (!ev.isEnd()) {
                        throw Assert$.MODULE$.abort("Invariant broken: ev.isEnd");
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        boolean res = bl;
        boolean chk = res ? unparser.checkArrayPosAgainstMaxOccurs(state) : false;
        return chk;
    }

    public abstract boolean checkArrayPosAgainstMaxOccurs(UState var1);

    public void checkFinalOccursCountBetweenMinAndMaxOccurs(UState state, RepeatingChildUnparser unparser, int numOccurrences, long maxReps, long arrPos) {
        long minReps = unparser.minRepeats(state);
        InfosetAccessor ev = (InfosetAccessor)state.inspectAccessor();
        ElementRuntimeData erd = unparser.erd();
        if ((long)numOccurrences < minReps) {
            throw this.UE(state, "Expected %s additional %s elements, but received %s.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(minReps - (long)numOccurrences)), erd.namedQName(), ev}));
        }
        OccursCountKind ock = (OccursCountKind)Maybe$.MODULE$.get$extension(erd.maybeOccursCountKind());
        if (ock == OccursCountKind$Implicit$.MODULE$ && unparser.isBoundedMax() && arrPos > maxReps + 1L) {
            throw this.UE(state, "Expected maximum of %s elements, but received %s.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)maxReps), BoxesRunTime.boxToLong((long)(arrPos - 1L))}));
        }
        if (arrPos < maxReps && minReps < maxReps && ock != OccursCountKind$Implicit$.MODULE$) {
            if (state.inspect()) {
                InfosetAccessor ev2 = (InfosetAccessor)state.inspectAccessor();
                if (ev2.isStart()) {
                    NamedQName namedQName = ev2.erd().namedQName();
                    ElementRuntimeData elementRuntimeData = erd;
                    if (!(namedQName != null ? !((Object)namedQName).equals(elementRuntimeData) : elementRuntimeData != null)) {
                        throw this.UE(state, "More than maxOccurs %s occurrences of %s in Infoset input: Expected no more events for %s, but received %s.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)maxReps), erd.namedQName(), ev2}));
                    }
                }
                return;
            }
            return;
        }
    }
}

