/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.accum;

import java.util.function.BiConsumer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceableComponent;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleTarget;

public class AccumulatorRule
implements RuleTarget,
TraceableComponent {
    private Expression newValueExpression;
    private final SlotManager stackFrameMap;
    private final boolean postDescent;
    private boolean capturing;
    private Location location;
    private StructuredQName accumulatorName;

    public AccumulatorRule(Expression newValueExpression, SlotManager stackFrameMap, boolean postDescent) {
        this.newValueExpression = newValueExpression;
        this.stackFrameMap = stackFrameMap;
        this.postDescent = postDescent;
    }

    public Expression getNewValueExpression() {
        return this.newValueExpression;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        this.newValueExpression.export(out);
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    @Override
    public void registerRule(Rule rule) {
    }

    public void setCapturing(boolean capturing) {
        this.capturing = capturing;
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public boolean isPostDescent() {
        return this.postDescent;
    }

    @Override
    public Expression getBody() {
        return this.newValueExpression;
    }

    public void setLocation(Location loc) {
        this.location = loc;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public StructuredQName getObjectName() {
        return null;
    }

    @Override
    public void setBody(Expression expression) {
        this.newValueExpression = expression;
    }

    @Override
    public String getTracingTag() {
        return "xsl:accumulator-rule";
    }

    public void setAccumulatorName(StructuredQName name) {
        this.accumulatorName = name;
    }

    @Override
    public void gatherProperties(BiConsumer<String, Object> consumer) {
        if (this.accumulatorName != null) {
            consumer.accept("name", this.accumulatorName.getDisplayName());
        }
        consumer.accept("phase", this.isPostDescent() ? "end" : "start");
    }
}

