/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import org.apache.daffodil.lib.calendar.DFDLCalendar;
import org.apache.daffodil.lib.calendar.DFDLDateTime;
import org.apache.daffodil.lib.calendar.DFDLDateTime$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.FNDateTime$;
import org.apache.daffodil.runtime1.dpath.FNTwoArgs;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class FNDateTime
extends FNTwoArgs
implements Product {
    private final List recipes;
    private final String name;

    public static FNDateTime apply(List<CompiledDPath> list) {
        return FNDateTime$.MODULE$.apply(list);
    }

    public static FNDateTime fromProduct(Product product) {
        return FNDateTime$.MODULE$.fromProduct(product);
    }

    public static FNDateTime unapply(FNDateTime fNDateTime) {
        return FNDateTime$.MODULE$.unapply(fNDateTime);
    }

    public FNDateTime(List<CompiledDPath> recipes) {
        this.recipes = recipes;
        super(recipes);
        this.name = "FNDateTime";
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FNDateTime)) return false;
        FNDateTime fNDateTime = (FNDateTime)object;
        List<CompiledDPath> list = this.recipes();
        List<CompiledDPath> list2 = fNDateTime.recipes();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!fNDateTime.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FNDateTime;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "FNDateTime";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipes";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public List<CompiledDPath> recipes() {
        return this.recipes;
    }

    public String name() {
        return this.name;
    }

    private DFDLCalendar calendarToDFDLDateTime(Calendar calendar, boolean hasTZ, DState dstate, String fncName, String toType) {
        try {
            DFDLDateTime cal = DFDLDateTime$.MODULE$.apply(calendar, hasTZ);
            return cal;
        }
        catch (IllegalArgumentException ex) {
            throw dstate.SDE("Conversion Error: %s failed to convert \"%s\" to %s. Due to %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fncName, calendar.toString(), toType, ex.getMessage()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DFDLCalendar computeValue(Object arg1, Object arg2, DState dstate) {
        DFDLCalendar dateCalendar = DataValue$.MODULE$.getCalendar$extension(arg1);
        DFDLCalendar timeCalendar = DataValue$.MODULE$.getCalendar$extension(arg2);
        Calendar dateCal = dateCalendar.calendar();
        Calendar timeCal = timeCalendar.calendar();
        int year = dateCal.get(1);
        int day = dateCal.get(5);
        int month = dateCal.get(2);
        TimeZone dateTZ = dateCal.getTimeZone();
        TimeZone timeTZ = timeCal.getTimeZone();
        Calendar newCal = (Calendar)timeCal.clone();
        newCal.set(1, year);
        newCal.set(5, day);
        newCal.set(2, month);
        boolean hasTZ = true;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)dateCalendar.hasTimeZone()), (Object)BoxesRunTime.boxToBoolean((boolean)timeCalendar.hasTimeZone()));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        boolean bl = tuple2._1$mcZ$sp();
        boolean bl2 = tuple2._2$mcZ$sp();
        if (!bl && !bl2) {
            newCal.setTimeZone(TimeZone.UNKNOWN_ZONE);
            hasTZ = false;
        } else if (bl && !bl2) {
            newCal.setTimeZone(dateTZ);
        } else if (!bl && bl2) {
            newCal.setTimeZone(timeTZ);
        } else {
            if (!bl || !bl2) throw new MatchError((Object)tuple2);
            TimeZone timeZone = dateTZ;
            TimeZone timeZone2 = timeTZ;
            if (timeZone == null ? timeZone2 != null : !timeZone.equals(timeZone2)) {
                throw dstate.SDE("The two arguments to fn:dateTime have inconsistent timezones", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            newCal.setTimeZone(dateTZ);
        }
        DFDLCalendar finalCal = this.calendarToDFDLDateTime(newCal, hasTZ, dstate, this.name(), "DateTime");
        return DataValue$.MODULE$.toDataValue(finalCal);
    }

    public FNDateTime copy(List<CompiledDPath> recipes) {
        return new FNDateTime(recipes);
    }

    public List<CompiledDPath> copy$default$1() {
        return this.recipes();
    }

    public List<CompiledDPath> _1() {
        return this.recipes();
    }
}

