/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.ProcessingError;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import scala.MatchError;

public interface BinaryNumberCheckWidth {
    public static boolean checkMinWidth$(BinaryNumberCheckWidth $this, ParseOrUnparseState state, boolean isSigned, int nBits, int minWidth) {
        return $this.checkMinWidth(state, isSigned, nBits, minWidth);
    }

    default public boolean checkMinWidth(ParseOrUnparseState state, boolean isSigned, int nBits, int minWidth) {
        if (!(nBits >= minWidth || isSigned && state.tunable().allowSignedIntegerLength1Bit() && nBits == 1)) {
            String signedStr = isSigned ? "a signed" : "an unsigned";
            String outOfRangeStr = "Minimum length for " + signedStr + " binary number is " + minWidth + " bit(s), number of bits " + nBits + " out of range. An unsigned number with length 1 bit could be used instead.";
            ProcessingError procErr = state.toProcessingError(outOfRangeStr);
            ParseOrUnparseState parseOrUnparseState = state;
            if (parseOrUnparseState instanceof PState) {
                PState s = (PState)parseOrUnparseState;
                s.setFailed(procErr);
                return false;
            }
            if (!(parseOrUnparseState instanceof UState)) {
                throw new MatchError((Object)parseOrUnparseState);
            }
            UState s = (UState)parseOrUnparseState;
            throw s.toss(procErr);
        }
        return true;
    }

    public static boolean checkMaxWidth$(BinaryNumberCheckWidth $this, ParseOrUnparseState state, int nBits, int maxWidth) {
        return $this.checkMaxWidth(state, nBits, maxWidth);
    }

    default public boolean checkMaxWidth(ParseOrUnparseState state, int nBits, int maxWidth) {
        if (nBits > maxWidth) {
            ProcessingError procErr = state.toProcessingError("Number of bits " + nBits + " out of range, must be between 1 and " + maxWidth + " bits.");
            ParseOrUnparseState parseOrUnparseState = state;
            if (parseOrUnparseState instanceof PState) {
                PState s = (PState)parseOrUnparseState;
                s.setFailed(procErr);
                return false;
            }
            if (!(parseOrUnparseState instanceof UState)) {
                throw new MatchError((Object)parseOrUnparseState);
            }
            UState s = (UState)parseOrUnparseState;
            throw s.toss(procErr);
        }
        return true;
    }
}

