/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.core.exceptions.UnsupportedOption;
import java.util.HashMap;
import java.util.Map;

public class EncodingOptions {
    public static final String INCLUDE_COOKIE = "INCLUDE_COOKIE";
    public static final String INCLUDE_OPTIONS = "INCLUDE_OPTIONS";
    public static final String INCLUDE_SCHEMA_ID = "INCLUDE_SCHEMA_ID";
    public static final String RETAIN_ENTITY_REFERENCE = "KEEP_ENTITY_REFERENCES_UNRESOLVED";
    public static final String INCLUDE_XSI_SCHEMALOCATION = "INCLUDE_XSI_SCHEMALOCATION";
    public static final String INCLUDE_INSIGNIFICANT_XSI_NIL = "INCLUDE_INSIGNIFICANT_XSI_NIL";
    public static final String INCLUDE_PROFILE_VALUES = "INCLUDE_PROFILE_VALUES";
    public static final String UTC_TIME = "UTC_TIME";
    public static final String CANONICAL_EXI = "http://www.w3.org/TR/exi-c14n";
    public static final String DEFLATE_COMPRESSION_VALUE = "DEFLATE_COMPRESSION_VALUE";
    protected Map<String, Object> options = new HashMap<String, Object>();

    protected EncodingOptions() {
    }

    public static EncodingOptions createDefault() {
        EncodingOptions ho = new EncodingOptions();
        return ho;
    }

    public void setOption(String key) throws UnsupportedOption {
        this.setOption(key, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String key, Object value) throws UnsupportedOption {
        if (key.equals(INCLUDE_COOKIE)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(INCLUDE_OPTIONS)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(INCLUDE_SCHEMA_ID)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(RETAIN_ENTITY_REFERENCE)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(INCLUDE_XSI_SCHEMALOCATION)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(INCLUDE_INSIGNIFICANT_XSI_NIL)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(INCLUDE_PROFILE_VALUES)) {
            this.options.put(key, null);
            return;
        } else if (key.equals(CANONICAL_EXI)) {
            this.options.put(key, null);
            this.setOption(INCLUDE_OPTIONS);
            return;
        } else if (key.equals(UTC_TIME)) {
            this.options.put(key, null);
            return;
        } else {
            if (!key.equals(DEFLATE_COMPRESSION_VALUE)) throw new UnsupportedOption("EncodingOption '" + key + "' is unknown!");
            if (value == null || !(value instanceof Integer)) throw new UnsupportedOption("EncodingOption '" + key + "' requires value of type Integer");
            this.options.put(key, value);
        }
    }

    public boolean unsetOption(String key) {
        boolean b = this.options.containsKey(key);
        this.options.remove(key);
        return b;
    }

    public boolean isOptionEnabled(String key) {
        return this.options.containsKey(key);
    }

    public Object getOptionValue(String key) {
        return this.options.get(key);
    }

    public boolean equals(Object o) {
        if (o instanceof EncodingOptions) {
            EncodingOptions other = (EncodingOptions)o;
            return this.options.equals(other.options);
        }
        return false;
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return this.options.toString();
    }
}

