/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceConnector
implements Connector {
    private TestConfiguration config;
    private DataSource ds;

    @Override
    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = JDBCDataSource.getDataSource(config, null);
    }

    @Override
    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getConnection();
        }
    }

    @Override
    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            DataSource tmpDs = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getConnection();
        }
    }

    @Override
    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getConnection(user, password);
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getConnection(user, password);
        }
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        return this.openConnection(databaseName, user, password, null);
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password, Properties connectionProperties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getConnection(user, password);
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            HashMap<String, Object> hm = DataSourceConnector.makeCreateDBAttributes(this.config);
            DataSourceConnector.copyProperties(connectionProperties, hm);
            DataSource tmpDs = this.singleUseDS(hm);
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getConnection(user, password);
        }
    }

    @Override
    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getConnection();
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean deregisterDriver) throws SQLException {
        DataSource tmpDs = this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config));
        JDBCDataSource.setBeanProperty(tmpDs, "databaseName", "");
        tmpDs.getConnection();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    private DataSource singleUseDS(HashMap hm) throws SQLException {
        DataSource sds = JDBCDataSource.getDataSource(this.config, hm);
        return sds;
    }

    static HashMap<String, Object> makeCreateDBAttributes(TestConfiguration configuration) {
        HashMap<String, Object> hm = JDBCDataSource.getDataSourceProperties(configuration);
        hm.put("createDatabase", "create");
        return hm;
    }

    static HashMap<String, Object> makeShutdownDBAttributes(TestConfiguration configuration) {
        HashMap<String, Object> hm = JDBCDataSource.getDataSourceProperties(configuration);
        hm.put("shutdownDatabase", "shutdown");
        return hm;
    }

    @Override
    public String getDatabaseName() {
        String databaseName = null;
        try {
            databaseName = (String)JDBCDataSource.getBeanProperty(this.ds, "databaseName");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return databaseName;
    }

    static void copyProperties(Properties src, Map<String, Object> dest) {
        if (src != null) {
            for (String key : src.stringPropertyNames()) {
                dest.put(key, src.getProperty(key));
            }
        }
    }
}

