/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.Permission;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class LuceneSupportPermsTest
extends GeneratedColumnsHelper {
    private static final String LUCENE_VERSION_PROPERTY = "derby.tests.lucene.version";
    private static String LUCENE_VERSION = "LUCENE_47";
    private static final String DB_NAME = "lucenesupportpermsdb";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};
    private static final String AUTH_NO_ACCESS_NOT_OWNER = "42507";
    private static final String DBO_ONLY = "4251D";
    private static final String FUNCTION_EXISTS = "X0Y68";
    private static final String NOT_INDEXABLE = "42XBA";
    private static final String NO_PRIMARY_KEY = "42XBB";
    private static final String NONEXISTENT_INDEX = "42XBE";
    private static final String NO_DDL_PRIV = "42XBF";
    private static final String DOUBLE_LOAD_ILLEGAL = "42XBG";
    private static final String DOUBLE_UNLOAD_ILLEGAL = "42XBH";
    private static final String BAD_DIRECTORY = "42XBI";
    private static final String BAD_COLUMN_NAME = "42XBJ";
    private static final String NONEXISTENT_TABLE_FUNCTION = "42ZB4";
    private static final String INCOMPATIBLE_ENCRYPTION = "42XBL";
    private static final String ILLEGAL_NULL_ARG = "42XBM";
    private static final String BAD_FIELD_NAME = "42XBN";
    private static final String DUPLICATE_FIELD_NAME = "42XBO";
    private static final String NULL_PRIMITIVE_ARG = "39004";
    private static final String POLICY_FILE = "org/apache/derbyTesting/functionTests/tests/lang/luceneSupport.policy";
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', null )";
    private static final String UPDATE_POEMS_INDEX = "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', null )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'poems', 'poemText' )";
    private static final String DROP_PRIMARY_KEY = "alter table poems drop constraint poemsKey";
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final String LANGUAGE = "en";
    private static final String COUNTRY = "US";
    private static final String DEFAULT_INDEX_DESCRIPTOR = "org.apache.derby.optional.api.LuceneUtils.defaultIndexDescriptor";
    private static final String CONSTANT_QUERY_PARSER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.constantStringIndexDescriptor";
    static String[] _fieldNames;

    public LuceneSupportPermsTest(String string) {
        super(string);
    }

    public static Test suite() {
        String string = LuceneSupportPermsTest.getSystemProperty(LUCENE_VERSION_PROPERTY);
        if (string != null) {
            LUCENE_VERSION = string;
        }
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(LuceneSupportPermsTest.class);
        SecurityManagerSetup securityManagerSetup = new SecurityManagerSetup((Test)baseTestSuite, POLICY_FILE);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)securityManagerSetup, LEGAL_USERS, "LuceneSupportPermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecoratorSingleUse(test, DB_NAME, true);
        LocaleTestSetup localeTestSetup = new LocaleTestSetup(test2, new Locale(LANGUAGE, COUNTRY));
        return localeTestSetup;
    }

    public void test_001_basicNoGrant() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        this.createSchema(connection2, 4);
        this.expectExecutionError(connection2, "42504", LOAD_TOOL);
        this.goodStatement(connection, LOAD_TOOL);
        this.expectExecutionError(connection2, NONEXISTENT_INDEX, UPDATE_POEMS_INDEX);
        this.expectExecutionError(connection3, "42502", INDEX_POEMS);
        this.goodStatement(connection2, INDEX_POEMS);
        this.expectExecutionError(connection2, FUNCTION_EXISTS, INDEX_POEMS);
        this.expectExecutionError(connection2, NONEXISTENT_INDEX, "call LuceneSupport.updateIndex( 'ruth', 'poems', 'foo', null )");
        this.expectExecutionError(connection2, NONEXISTENT_INDEX, "call LuceneSupport.updateIndex( 'ruth', 'poems', 'originalAuthor', null )");
        String string = "select * from table ( ruth.poems__poemText( 'star', 1000, null ) ) luceneResults order by poemID";
        this.expectExecutionError(connection3, "42504", string);
        this.assertResults(connection2, string, new String[][]{{"3", "3", "2", "0.22933942"}, {"4", "4", "3", "0.22933942"}, {"5", "5", "4", "0.26756266"}}, false);
        String string2 = "select schemaName, tableName, columnName from table ( LuceneSupport.listIndexes() ) listindexes";
        this.assertResults(connection3, string2, new String[][]{{RUTH, "POEMS", "POEMTEXT"}}, false);
        this.expectExecutionError(connection3, NO_DDL_PRIV, UPDATE_POEMS_INDEX);
        this.expectExecutionError(connection3, AUTH_NO_ACCESS_NOT_OWNER, DROP_POEMS_INDEX);
        this.goodStatement(connection2, UPDATE_POEMS_INDEX);
        this.goodStatement(connection2, DROP_PRIMARY_KEY);
        this.goodStatement(connection2, UPDATE_POEMS_INDEX);
        this.goodStatement(connection2, "alter table poems drop column versionStamp");
        this.expectExecutionError(connection2, "42X04", UPDATE_POEMS_INDEX);
        this.expectExecutionError(connection2, "42X04", string);
        this.goodStatement(connection2, DROP_POEMS_INDEX);
        this.assertResults(connection2, string2, new String[0][], false);
        this.expectExecutionError(connection2, "42Y55", DROP_POEMS_INDEX);
        this.dropSchema(connection2);
        this.createSchema(connection2, 4);
        this.goodStatement(connection2, DROP_PRIMARY_KEY);
        this.expectExecutionError(connection2, NO_PRIMARY_KEY, INDEX_POEMS);
        this.expectExecutionError(connection2, "42504", UNLOAD_TOOL);
        this.goodStatement(connection, UNLOAD_TOOL);
        this.dropSchema(connection2);
    }

    public void test_002_userGrant() throws Exception {
        Permission[] permissionArray;
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        this.createSchema(connection2, 4);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, INDEX_POEMS);
        for (Permission permission : permissionArray = new Permission[]{new Permission("execute on function poems__poemText", "42504"), new Permission("select ( poemID ) on poems", "42502"), new Permission("select ( versionStamp ) on poems", "42502"), new Permission("select ( poemText ) on poems", "42502")}) {
            this.grantPermission(connection2, permission.text, ALICE);
        }
        String string = "select * from table ( ruth.poems__poemText( 'star', 1000, null ) ) luceneResults order by poemid";
        String[][] stringArray = new String[][]{{"3", "3", "2", "0.22933942"}, {"4", "4", "3", "0.22933942"}, {"5", "5", "4", "0.26756266"}};
        this.assertResults(connection3, string, stringArray, false);
        for (Permission permission : permissionArray) {
            this.vetPermission_002(permission, connection2, connection3, string, stringArray);
        }
        this.expectExecutionError(connection3, AUTH_NO_ACCESS_NOT_OWNER, DROP_POEMS_INDEX);
        this.goodStatement(connection, UNLOAD_TOOL);
        this.dropSchema(connection2);
    }

    private void vetPermission_002(Permission permission, Connection connection, Connection connection2, String string, String[][] stringArray) throws Exception {
        this.revokePermission(connection, permission.text, ALICE);
        this.expectExecutionError(connection2, permission.sqlStateWhenMissing, string);
        this.grantPermission(connection, permission.text, ALICE);
        this.assertResults(connection2, string, stringArray, false);
    }

    private void grantPermission(Connection connection, String string, String string2) throws Exception {
        String string3 = "grant " + string + " to " + string2;
        this.goodStatement(connection, string3);
    }

    private void revokePermission(Connection connection, String string, String string2) throws Exception {
        String string3 = "revoke " + string + " from " + string2;
        if (string.startsWith("execute") || string.startsWith("usage")) {
            string3 = string3 + " restrict";
        }
        this.goodStatement(connection, string3);
    }

    public void test_003_loading() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.createSchema(connection2, 4);
        this.goodStatement(connection, "grant execute on procedure syscs_util.syscs_register_tool to public");
        this.expectExecutionError(connection2, DBO_ONLY, LOAD_TOOL);
        this.goodStatement(connection, LOAD_TOOL);
        this.expectExecutionError(connection, DOUBLE_LOAD_ILLEGAL, LOAD_TOOL);
        this.expectExecutionError(connection2, NOT_INDEXABLE, "call LuceneSupport.createIndex( 'ruth', 'foo', 'poemText', null )");
        this.expectExecutionError(connection2, NOT_INDEXABLE, "call LuceneSupport.createIndex( 'ruth', 'poems', 'fooText', null )");
        this.expectExecutionError(connection2, NOT_INDEXABLE, "call LuceneSupport.createIndex( 'ruth', 'poems', 'versionStamp', null )");
        this.expectExecutionError(connection2, "42Y55", "call LuceneSupport.dropIndex( 'ruth', 'foo', 'poemText' )");
        this.expectExecutionError(connection2, "42Y55", "call LuceneSupport.dropIndex( 'ruth', 'poems', 'versionStamp' )");
        this.expectExecutionError(connection2, DBO_ONLY, UNLOAD_TOOL);
        this.goodStatement(connection, "revoke execute on procedure syscs_util.syscs_register_tool from public restrict");
        this.goodStatement(connection, UNLOAD_TOOL);
        this.expectExecutionError(connection, DOUBLE_UNLOAD_ILLEGAL, UNLOAD_TOOL);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection, UNLOAD_TOOL);
        this.dropSchema(connection2);
    }

    public void test_004_datatypes() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, LOAD_TOOL);
        this.vet_004(connection2, -5);
        this.vet_004(connection2, 16);
        this.vet_004(connection2, 1);
        this.vet_004(connection2, -2);
        this.vet_004(connection2, 91);
        this.vet_004(connection2, 3);
        this.vet_004(connection2, 8);
        this.vet_004(connection2, 6);
        this.vet_004(connection2, 4);
        this.vet_004(connection2, 2);
        this.vet_004(connection2, 7);
        this.vet_004(connection2, 5);
        this.vet_004(connection2, 92);
        this.vet_004(connection2, 93);
        this.vet_004(connection2, 12);
        this.vet_004(connection2, -3);
        this.goodStatement(connection, UNLOAD_TOOL);
    }

    private void vet_004(Connection connection, int n) throws Exception {
        this.createSchema(connection, n);
        this.goodStatement(connection, INDEX_POEMS);
        this.assertResults(connection, "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n", new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}}, false);
        this.goodStatement(connection, DROP_POEMS_INDEX);
        this.dropSchema(connection);
    }

    public void test_005_deleteDirectory() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.createSchema(connection2, 4);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, INDEX_POEMS);
        TestConfiguration testConfiguration = this.getTestConfiguration();
        String string = testConfiguration.getDefaultDatabaseName();
        String string2 = testConfiguration.getPhysicalDatabaseName(string);
        String string3 = testConfiguration.getDatabasePath(string2);
        File file = new File(string3);
        File file2 = new File(file, "LUCENE");
        File file3 = new File(file2, RUTH);
        File file4 = new File(file3, "POEMS");
        File file5 = new File(file4, "POEMTEXT");
        LuceneSupportPermsTest.assertTrue((boolean)this.deleteFile(file5));
        this.goodStatement(connection2, DROP_POEMS_INDEX);
        this.expectCompilationError(connection2, NONEXISTENT_TABLE_FUNCTION, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, null ) ) t");
        this.goodStatement(connection, UNLOAD_TOOL);
        this.dropSchema(connection2);
    }

    public void test_006_changeAnalyzer() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.createSchema(connection2, 4);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, INDEX_POEMS);
        this.assertResults(connection2, "values ( substr( getDatabaseLocale(), 1, 2 ) )", new String[][]{{LANGUAGE}}, false);
        String string = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        this.assertResults(connection2, string, new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}}, false);
        this.goodStatement(connection2, "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.assertResults(connection2, string, new String[][]{{"Walt Whitman", "0.3304931"}, {"John Milton", "0.2832798"}}, false);
        this.goodStatement(connection2, "call LuceneSupport.createIndex( 'ruth', 'poems', 'originalAuthor', null )");
        this.assertResults(connection2, "select schemaName, tableName, columnName, luceneVersion, analyzer, indexDescriptorMaker\nfrom table( LuceneSupport.listIndexes() ) l\norder by schemaName, tableName, columnName\n", new String[][]{{RUTH, "POEMS", "ORIGINALAUTHOR", LUCENE_VERSION, "org.apache.lucene.analysis.en.EnglishAnalyzer", DEFAULT_INDEX_DESCRIPTOR}, {RUTH, "POEMS", "POEMTEXT", LUCENE_VERSION, "org.apache.lucene.analysis.standard.StandardAnalyzer", "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer"}}, false);
        this.goodStatement(connection2, DROP_POEMS_INDEX);
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'poems', 'originalAuthor' )");
        this.goodStatement(connection, UNLOAD_TOOL);
        this.dropSchema(connection2);
    }

    public void test_007_indexViews() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.createSchema(connection2, 4);
        this.createPoemView(connection2);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, INDEX_POEMS);
        this.expectExecutionError(connection2, NO_PRIMARY_KEY, "call LuceneSupport.createIndex( 'ruth', 'poemView', 'poemText', null )");
        this.goodStatement(connection2, "call LuceneSupport.createIndex( 'ruth', 'poemView', 'poemText', null, 'poemID', 'versionStamp' )");
        this.expectExecutionError(connection2, FUNCTION_EXISTS, "call LuceneSupport.createIndex( 'ruth', 'poemView', 'poemText', null, 'poemID' )");
        String string = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poemView__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        this.assertResults(connection2, string, new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}}, false);
        String string2 = "select schemaName, tableName, columnName, indexDescriptorMaker\nfrom table( LuceneSupport.listIndexes() ) l\norder by schemaName, tableName, columnName\n";
        this.assertResults(connection2, string2, new String[][]{{RUTH, "POEMS", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}, {RUTH, "POEMVIEW", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}}, false);
        this.goodStatement(connection2, "call LuceneSupport.updateIndex( 'ruth', 'poemView', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.assertResults(connection2, string, new String[][]{{"Walt Whitman", "0.3304931"}, {"John Milton", "0.2832798"}}, false);
        this.assertResults(connection2, string2, new String[][]{{RUTH, "POEMS", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}, {RUTH, "POEMVIEW", "POEMTEXT", "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer"}}, false);
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'poemView', 'poemText' )");
        this.assertResults(connection2, string2, new String[][]{{RUTH, "POEMS", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}}, false);
        this.goodStatement(connection2, DROP_POEMS_INDEX);
        this.goodStatement(connection2, "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', null, 'poemID' )");
        this.assertResults(connection2, "select *\nfrom table ( ruth.poems__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", new String[][]{{"5", "4", "0.26756266"}, {"4", "3", "0.22933942"}, {"3", "2", "0.22933942"}}, false);
        this.goodStatement(connection2, DROP_POEMS_INDEX);
        this.goodStatement(connection, UNLOAD_TOOL);
        this.goodStatement(connection2, "drop view poemView");
        this.dropSchema(connection2);
    }

    public void test_008_columnNames() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, "create table badTable1( keyCol int primary key, score clob )");
        this.goodStatement(connection2, "create table badTable2( keyCol int primary key, documentID clob )");
        this.goodStatement(connection2, "create table badTable3( score int primary key, textCol clob )");
        this.goodStatement(connection2, "create table badTable4( documentID int primary key, textCol clob )");
        this.expectExecutionError(connection2, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable1', 'score', null )");
        this.expectExecutionError(connection2, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable2', 'documentID', null )");
        this.expectExecutionError(connection2, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable3', 'textCol', null )");
        this.expectExecutionError(connection2, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable4', 'textCol', null )");
        this.goodStatement(connection, UNLOAD_TOOL);
        this.goodStatement(connection2, "drop table badTable1");
        this.goodStatement(connection2, "drop table badTable2");
        this.goodStatement(connection2, "drop table badTable3");
        this.goodStatement(connection2, "drop table badTable4");
    }

    public void test_009_searchArgs() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        LuceneSupportPermsTest.loadTestTable(connection2);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, "call LuceneSupport.createIndex( 'ruth', 'textTable', 'textCol', null )");
        this.assertResults(connection2, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, null ) ) t", new String[][]{{"10", "9", "2.2791052"}, {"9", "8", "1.6305782"}, {"8", "7", "1.1616905"}, {"7", "6", "0.97469425"}, {"6", "5", "0.6597747"}, {"5", "4", "0.49575216"}, {"4", "3", "0.33803377"}, {"3", "2", "0.17799875"}, {"2", "1", "0.09289266"}, {"1", "0", "0.035006654"}}, false);
        this.assertResults(connection2, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 3, null ) ) t", new String[][]{{"10", "9", "2.2791052"}, {"9", "8", "1.6305782"}, {"8", "7", "1.1616905"}}, false);
        this.assertResults(connection2, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 4, 1.0 ) ) t", new String[][]{{"7", "6", "0.97469425"}, {"6", "5", "0.6597747"}, {"5", "4", "0.49575216"}, {"4", "3", "0.33803377"}}, false);
        this.assertResults(connection2, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, 0.2 ) ) t", new String[][]{{"3", "2", "0.17799875"}, {"2", "1", "0.09289266"}, {"1", "0", "0.035006654"}}, false);
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'textTable', 'textCol' )");
        this.goodStatement(connection2, "call LuceneSupport.createIndex( 'ruth', 'textTable', 'textCol', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.constantStringIndexDescriptor' )");
        this.assertResults(connection2, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, null ) ) t", new String[][]{{"1", "0", "1.597837"}, {"2", "1", "0.9986481"}, {"3", "2", "0.7989185"}, {"4", "3", "0.7989185"}, {"5", "4", "0.69905365"}, {"6", "5", "0.59918886"}, {"7", "6", "0.59918886"}, {"8", "7", "0.49932405"}, {"9", "8", "0.49932405"}, {"10", "9", "0.49932405"}}, false);
        this.goodStatement(connection, UNLOAD_TOOL);
        LuceneSupportPermsTest.unloadTestTable(connection2);
    }

    static void loadTestTable(Connection connection) throws Exception {
        connection.prepareStatement("create table textTable( keyCol int primary key, textCol clob )").execute();
        connection.prepareStatement("insert into textTable values\n( 1, 'one' ),\n( 2, 'one two' ),\n( 3, 'one two three' ),\n( 4, 'one two three four' ),\n( 5, 'one two three four five' ),\n( 6, 'one two three four five six' ),\n( 7, 'one two three four five six seven' ),\n( 8, 'one two three four five six seven eight' ),\n( 9, 'one two three four five six seven eight nine' ),\n( 10, 'one two three four five six seven eight nine ten' ),\n( 101, 'bricks' ),\n( 102, 'bricks and mortar' ),\n( 103, 'bricks and mortar, tea' ),\n( 104, 'bricks and mortar, tea, tears' ),\n( 105, 'bricks and mortar, tea, tears, turtle' ),\n( 106, 'bricks and mortar, tea, tears, turtle, soup' ),\n( 107, 'bricks and mortar, tea, tears, turtle, soup, when in the course' ),\n( 108, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events' ),\n( 109, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events you want' ),\n( 110, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events you want better cell coverage' )\n").execute();
    }

    static void unloadTestTable(Connection connection) throws Exception {
        connection.prepareStatement("drop table textTable").execute();
    }

    public void test_010_encryption() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        String string = this.getTestConfiguration().getPassword(TEST_DBO);
        String string2 = "jdbc:derby:lucenesupportpermsdb;user=TEST_DBO;password=" + string + ";dataEncryption=true;bootPassword=tryToGuessThis";
        String string3 = "jdbc:derby:lucenesupportpermsdb;user=TEST_DBO;password=" + string + ";decryptDatabase=true;bootPassword=tryToGuessThis";
        this.goodStatement(connection, LOAD_TOOL);
        this.getTestConfiguration().shutdownDatabase();
        try {
            DriverManager.getConnection(string2);
            LuceneSupportPermsTest.fail((String)"Should not have been able to get a connection!");
        }
        catch (SQLException sQLException) {
            LuceneSupportPermsTest.assertSQLState(INCOMPATIBLE_ENCRYPTION, sQLException);
        }
        connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, UNLOAD_TOOL);
        this.getTestConfiguration().shutdownDatabase();
        connection = DriverManager.getConnection(string2);
        this.expectExecutionError(connection, INCOMPATIBLE_ENCRYPTION, LOAD_TOOL);
        this.getTestConfiguration().shutdownDatabase();
        connection = DriverManager.getConnection(string3);
    }

    public void test_011_fieldNames() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        LuceneSupportPermsTest.loadTestTable(connection2);
        this.goodStatement(connection, LOAD_TOOL);
        String string = "call LuceneSupport.createIndex\n(\n    'ruth', 'textTable', 'textCol',\n    'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.makeFieldNameIndexDescriptor'\n)\n";
        this.goodStatement(connection2, "create procedure setFieldNames( fieldName varchar( 32672 )... )\nlanguage java parameter style derby no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.setFieldNames'\n");
        this.goodStatement(connection2, "call setFieldNames( 'KEYCOL' )");
        this.expectExecutionError(connection2, BAD_FIELD_NAME, string);
        this.goodStatement(connection2, "call setFieldNames( 'FOO', 'FOO' )");
        this.expectExecutionError(connection2, DUPLICATE_FIELD_NAME, string);
        this.goodStatement(connection2, "call setFieldNames( 'FOO', null )");
        this.expectExecutionError(connection2, DUPLICATE_FIELD_NAME, string);
        this.goodStatement(connection2, "call setFieldNames( null, 'FOO' )");
        this.expectExecutionError(connection2, DUPLICATE_FIELD_NAME, string);
        this.goodStatement(connection2, "drop procedure setFieldNames");
        this.goodStatement(connection, UNLOAD_TOOL);
        LuceneSupportPermsTest.unloadTestTable(connection2);
    }

    public void test_6602() throws Exception {
        CD[] cDArray = new CD[]{new CD("bigintCol", "bigint"), new CD("blobCol", "blob"), new CD("booleanCol", "boolean"), new CD("charCol", "char( 10 )"), new CD("clobCol", "clob"), new CD("dataCol", "date"), new CD("decimalCol", "decimal"), new CD("doubleCol", "double"), new CD("floatCol", "float"), new CD("intCol", "int"), new CD("longvarcharCol", "long varchar"), new CD("longvarcharforbitdataCol", "long varchar for bit data"), new CD("numericCol", "numeric"), new CD("realCol", "real"), new CD("smallintCol", "smallint"), new CD("timeCol", "time"), new CD("varcharCol", "varchar( 10 )"), new CD("varcharforbitdataCol", "varchar( 10 ) for bit data")};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create table t_6602\n(\ttextcol clob");
        for (CD cD : cDArray) {
            stringBuilder.append(",\n\t" + cD.name + " " + cD.type);
        }
        stringBuilder.append("\n)");
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection, stringBuilder.toString());
        this.goodStatement(connection, "insert into t_6602( textcol ) values ( 'abc'), ( 'def')");
        for (CD cD : cDArray) {
            this.vet6602(connection, cD);
        }
        this.goodStatement(connection, "drop table t_6602");
        this.goodStatement(connection, UNLOAD_TOOL);
    }

    private void vet6602(Connection connection, CD cD) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "call lucenesupport.createindex\n( 'TEST_DBO', 't_6602', 'textcol', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer', ? )");
        preparedStatement.setString(1, cD.name);
        preparedStatement.execute();
        this.assertResults(connection, "select * from table( t_6602__textcol( 'abc or def', 3, null ) ) tc order by documentid", new String[][]{{null, "0", "0.35355338"}, {null, "1", "0.35355338"}}, false);
        this.goodStatement(connection, "call lucenesupport.dropIndex( 'TEST_DBO', 't_6602', 'textcol' )");
    }

    public void test_6596_null_args() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection, "create table t_6596( x int primary key, c clob )");
        this.goodStatement(connection, "insert into t_6596 values ( 1, 'abc' ), ( 2, 'def' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( null, 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', null, 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', null,  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer', null )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer', 'x', null )");
        this.goodStatement(connection, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.assertResults(connection, "select * from table( t_6596__c( 'abc or def', 3, null ) ) tc order by documentid", new String[][]{{"1", "0", "0.35355338"}, {"2", "1", "0.35355338"}}, false);
        this.goodStatement(connection, "call lucenesupport.updateindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.updateindex( null, 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.updateindex( 'TEST_DBO', null, 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.updateindex( 'TEST_DBO', 't_6596', null,  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "select * from table( t_6596__c( null, 3, null ) ) tc order by documentid");
        this.expectExecutionError(connection, NULL_PRIMITIVE_ARG, "select * from table( t_6596__c( 'abc or def', null, null ) ) tc order by documentid");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.dropindex( null, 't_6596', 'c' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.dropindex( 'TEST_DBO', null, 'c' )");
        this.expectExecutionError(connection, ILLEGAL_NULL_ARG, "call lucenesupport.dropindex( 'TEST_DBO', 't_6596', null )");
        this.goodStatement(connection, "call lucenesupport.dropindex( 'TEST_DBO', 't_6596', 'c' )");
        this.goodStatement(connection, "drop table t_6596");
        this.goodStatement(connection, UNLOAD_TOOL);
    }

    public void test_6730() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.createSchema(connection2, 4);
        this.goodStatement(connection2, "create view v_6730_1 ( poemID, poemText ) as select poemID, poemText from ruth.poems");
        this.goodStatement(connection2, "create view v_6730_2 ( poemID, \"poemText\" ) as select poemID, poemText from ruth.poems");
        this.goodStatement(connection2, "create view v_6730_3 ( \"poemID\", poemText ) as select poemID, poemText from ruth.poems");
        this.goodStatement(connection2, "create view v_6730_4 ( \"poemID\", \"poemText\" ) as select poemID, poemText from ruth.poems");
        this.goodStatement(connection2, "create view v_6730_5 ( poemID, \"c l o b\" ) as select poemID, poemText from ruth.poems");
        this.goodStatement(connection2, "create view v_6730_6 ( \"k e y\", poemText ) as select poemID, poemText from ruth.poems");
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_1',\n  'poemText',\n  null,\n  'poemID'\n)\n");
        this.goodStatement(connection2, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_2',\n  '\"poemText\"',\n  null,\n  'poemID'\n)\n");
        this.goodStatement(connection2, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_3',\n  'poemText',\n  null,\n  '\"poemID\"'\n)\n");
        this.goodStatement(connection2, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_4',\n  '\"poemText\"',\n  null,\n  '\"poemID\"'\n)\n");
        this.goodStatement(connection2, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_5',\n  '\"c l o b\"',\n  null,\n  'poemID'\n)\n");
        this.goodStatement(connection2, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_6',\n  'poemText',\n  null,\n  '\"k e y\"'\n)\n");
        this.vet6730(connection2);
        this.goodStatement(connection2, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_1',\n  'poemText',\n  null\n)\n");
        this.goodStatement(connection2, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_2',\n  '\"poemText\"',\n  null\n)\n");
        this.goodStatement(connection2, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_3',\n  'poemText',\n  null\n)\n");
        this.goodStatement(connection2, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_4',\n  '\"poemText\"',\n  null\n)\n");
        this.goodStatement(connection2, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_5',\n  '\"c l o b\"',\n  null\n)\n");
        this.goodStatement(connection2, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_6',\n  'poemText',\n  null\n)\n");
        this.vet6730(connection2);
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_1', 'poemText' )");
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_2', '\"poemText\"' )");
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_3', 'poemText' )");
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_4', '\"poemText\"' )");
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_5', '\"c l o b\"' )");
        this.goodStatement(connection2, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_6', 'poemText' )");
        this.goodStatement(connection, UNLOAD_TOOL);
        this.goodStatement(connection2, "drop view v_6730_6");
        this.goodStatement(connection2, "drop view v_6730_5");
        this.goodStatement(connection2, "drop view v_6730_4");
        this.goodStatement(connection2, "drop view v_6730_3");
        this.goodStatement(connection2, "drop view v_6730_2");
        this.goodStatement(connection2, "drop view v_6730_1");
        this.dropSchema(connection2);
    }

    private void vet6730(Connection connection) throws Exception {
        String[][] stringArray = new String[][]{{"5", "0.26756266"}, {"4", "0.22933942"}, {"3", "0.22933942"}};
        this.assertResults(connection, "select i.poemID, i.score\nfrom table ( ruth.v_6730_1__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", stringArray, false);
        this.assertResults(connection, "select i.poemID, i.score\nfrom table ( ruth.\"V_6730_2__poemText\"( 'star', 1000, null ) ) i\norder by i.score desc\n", stringArray, false);
        this.assertResults(connection, "select i.\"poemID\", i.score\nfrom table ( ruth.v_6730_3__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", stringArray, false);
        this.assertResults(connection, "select i.\"poemID\", i.score\nfrom table ( ruth.\"V_6730_4__poemText\"( 'star', 1000, null ) ) i\norder by i.score desc\n", stringArray, false);
        this.assertResults(connection, "select i.poemID, i.score\nfrom table ( ruth.\"V_6730_5__c l o b\"( 'star', 1000, null ) ) i\norder by i.score desc\n", stringArray, false);
        this.assertResults(connection, "select i.\"k e y\", i.score\nfrom table ( ruth.v_6730_6__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", stringArray, false);
        String[][] stringArray2 = new String[][]{{RUTH, "V_6730_1", "POEMTEXT", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_2", "poemText", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_3", "POEMTEXT", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_4", "poemText", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_5", "c l o b", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_6", "POEMTEXT", "org.apache.lucene.analysis.en.EnglishAnalyzer"}};
        this.assertResults(connection, "select schemaName, tableName, columnName, analyzer\nfrom table( lucenesupport.listIndexes() ) t\norder by schemaName, tableName, columnName\n", stringArray2, false);
    }

    private void createSchema(Connection connection, int n) throws Exception {
        this.createPoemsTable(connection, n);
        this.createLocaleFunction(connection);
    }

    private void createPoemsTable(Connection connection, int n) throws Exception {
        this.goodStatement(connection, "create table poems\n(\n    poemID " + this.getType(n) + ",\n    versionStamp int not null,\n    originalAuthor       varchar( 50 ),\n    lastEditor           varchar( 50 ),\n    poemText            clob,\n    constraint poemsKey primary key( poemID, versionStamp )\n)\n");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into poems values ( ?, ?, ?, ?, ? )");
        int n2 = 1;
        int n3 = 1;
        this.setNextPoemID(preparedStatement, n, n2++);
        preparedStatement.setInt(2, n3++);
        preparedStatement.setString(3, "Geoffrey Chaucer");
        preparedStatement.setString(4, "Geoffrey Chaucer");
        preparedStatement.setString(5, "Whan that Aprill, with his shoures soote The droghte of March hath perced to the roote And bathed every veyne in swich licour, Of which vertu engendred is the flour;");
        preparedStatement.executeUpdate();
        this.setNextPoemID(preparedStatement, n, n2++);
        preparedStatement.setInt(2, n3++);
        preparedStatement.setString(3, "Andrew Marvell");
        preparedStatement.setString(4, "Andrew Marvell");
        preparedStatement.setString(5, "Had we but world enough, and time, This coyness, lady, were no crime.");
        preparedStatement.executeUpdate();
        this.setNextPoemID(preparedStatement, n, n2++);
        preparedStatement.setInt(2, n3++);
        preparedStatement.setString(3, "John Milton");
        preparedStatement.setString(4, "John Milton");
        preparedStatement.setString(5, "From morn to noon he fell, from noon to dewy eve, a summers day, and with the setting sun dropped from the ze4ith like a falling star on Lemnos, the Aegean isle");
        preparedStatement.executeUpdate();
        this.setNextPoemID(preparedStatement, n, n2++);
        preparedStatement.setInt(2, n3++);
        preparedStatement.setString(3, "Lord Byron");
        preparedStatement.setString(4, "Lord Byron");
        preparedStatement.setString(5, "The Assyrian came down like the wolf on the fold, And his cohorts were gleaming in purple and gold; And the sheen of their spears was like stars on the sea, When the blue wave rolls nightly on deep Galilee.");
        preparedStatement.executeUpdate();
        this.setNextPoemID(preparedStatement, n, n2++);
        preparedStatement.setInt(2, n3++);
        preparedStatement.setString(3, "Walt Whitman");
        preparedStatement.setString(4, "Walt Whitman");
        preparedStatement.setString(5, "When lilacs last in the dooryard bloomd, And the great star early droopd in the western sky in the night, I mournd, and yet shall mourn with ever-returning spring.");
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void createPoemView(Connection connection) throws Exception {
        this.goodStatement(connection, "create view poemView as select poemID, versionStamp, poemText from poems");
    }

    private void createLocaleFunction(Connection connection) throws Exception {
        this.goodStatement(connection, "create function getDatabaseLocale() returns varchar( 20 )\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.getDatabaseLocale()'\n");
    }

    private String getType(int n) throws Exception {
        switch (n) {
            case -2: {
                return "char( 100 ) for bit data";
            }
            case 16: {
                return "boolean";
            }
            case 3: {
                return "decimal";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "bigint";
            }
            case 5: {
                return "smallint";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "real";
            }
            case 2: {
                return "numeric";
            }
            case 1: {
                return "char( 5 )";
            }
            case 7: {
                return "real";
            }
            case 12: {
                return "varchar( 5 )";
            }
            case -3: {
                return "varchar( 256 ) for bit data";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
        }
        throw new Exception("Unsupported datatype: " + n);
    }

    private void setNextPoemID(PreparedStatement preparedStatement, int n, int n2) throws Exception {
        switch (n) {
            case -2: {
                preparedStatement.setBytes(1, LuceneSupportPermsTest.makeBytes(n2));
                break;
            }
            case 16: {
                preparedStatement.setBoolean(1, n2 % 2 == 0);
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(1, new BigDecimal(n2));
                break;
            }
            case 4: {
                preparedStatement.setInt(1, n2);
                break;
            }
            case -5: {
                preparedStatement.setLong(1, (long)n2 + Integer.MAX_VALUE);
                break;
            }
            case 5: {
                preparedStatement.setShort(1, (short)n2);
                break;
            }
            case 8: {
                preparedStatement.setDouble(1, n2);
                break;
            }
            case 6: 
            case 7: {
                preparedStatement.setFloat(1, n2);
                break;
            }
            case 1: 
            case 12: {
                preparedStatement.setString(1, this.makeStringKey(n2));
                break;
            }
            case -3: {
                preparedStatement.setBytes(1, LuceneSupportPermsTest.makeAllBytes(n2));
                break;
            }
            case 91: {
                preparedStatement.setDate(1, new Date(86400000L * (long)(500 + n2)));
                break;
            }
            case 92: {
                preparedStatement.setTime(1, new Time(3600000L * (long)n2));
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(1, new Timestamp(86400000L * (long)(500 + n2)));
                break;
            }
            default: {
                throw new Exception("Unsupported datatype: " + n);
            }
        }
    }

    private String makeStringKey(int n) {
        String string = Integer.toString(n);
        return string + string + string + string + string;
    }

    private void dropSchema(Connection connection) throws Exception {
        this.goodStatement(connection, "drop table poems");
        this.goodStatement(connection, "drop function getDatabaseLocale");
    }

    public static String getDatabaseLocale() throws SQLException {
        return ConnectionUtil.getCurrentLCC().getDatabase().getLocale().toString();
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Arrays.toString(byArray);
    }

    public static byte[] makeAllBytes(int n) {
        int n2 = 256;
        byte[] byArray = new byte[n2];
        int n3 = n;
        if (n3 < -128) {
            n3 = -128;
        }
        if (n3 > 127) {
            n3 = 127;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)n3++;
            if (n3 <= 127) continue;
            n3 = -128;
        }
        return byArray;
    }

    public static byte[] makeBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)n;
        }
        return byArray;
    }

    public static LuceneIndexDescriptor constantStringIndexDescriptor() {
        return new ConstantIndexDescriptor();
    }

    private boolean deleteFile(File file) throws IOException, PrivilegedActionException {
        boolean bl = true;
        if (this.isDirectory(file)) {
            for (File file2 : this.listFiles(file)) {
                bl = bl && this.deleteFile(file2);
            }
        }
        return bl && this.clobberFile(file);
    }

    private boolean isDirectory(final File file) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                if (file == null) {
                    return false;
                }
                return file.isDirectory();
            }
        });
    }

    private boolean clobberFile(final File file) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                return file.delete();
            }
        });
    }

    private File[] listFiles(final File file) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<File[]>(){

            @Override
            public File[] run() throws IOException {
                return file.listFiles();
            }
        });
    }

    public static void setFieldNames(String ... stringArray) {
        _fieldNames = stringArray;
    }

    public static LuceneIndexDescriptor makeFieldNameIndexDescriptor() {
        return new FieldNameIndexDescriptor();
    }

    public static class FieldNameIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public String[] getFieldNames() {
            return _fieldNames;
        }
    }

    public static class ConstantIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public QueryParser getQueryParser() throws SQLException {
            return new ConstantQueryParser(LuceneUtils.currentVersion(), this.getFieldNames(), this.getAnalyzer());
        }
    }

    public static class CD {
        public final String name;
        public final String type;

        public CD(String string, String string2) {
            this.name = string;
            this.type = string2;
        }

        public String toString() {
            return "[ " + this.name + ", " + this.type + " ]";
        }
    }

    public static class ConstantQueryParser
    extends MultiFieldQueryParser {
        public ConstantQueryParser(Version version, String[] stringArray, Analyzer analyzer) {
            super(version, stringArray, analyzer);
        }

        public Query parse(String string) throws ParseException {
            return super.parse("one");
        }
    }
}

