/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.util;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValueExpressionEvaluationInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger(ValueExpressionEvaluationInputStream.class.getName());
    private FacesContext facesContext;
    private PushbackInputStream wrapped;
    private String currentValue;
    private int currentValueIndex = -1;

    public ValueExpressionEvaluationInputStream(FacesContext facesContext, InputStream inputStream) {
        this.facesContext = facesContext;
        this.wrapped = new PushbackInputStream(inputStream, 512);
    }

    @Override
    public int read() throws IOException {
        boolean insideString;
        int c1;
        if (this.currentValueIndex != -1) {
            if (this.currentValueIndex < this.currentValue.length()) {
                return this.currentValue.charAt(this.currentValueIndex++);
            }
            this.currentValueIndex = -1;
        }
        if ((c1 = this.wrapped.read()) != 35) {
            return c1;
        }
        int c2 = this.wrapped.read();
        if (c2 != 123) {
            this.wrapped.unread(c2);
            return c1;
        }
        LinkedList<Integer> possibleValueExpression = new LinkedList<Integer>();
        int c = this.wrapped.read();
        boolean bl = insideString = c == 39;
        while (c != -1 && c != 10 && (insideString || c != 125)) {
            possibleValueExpression.add(c);
            c = this.wrapped.read();
            if (c != 39) continue;
            insideString = !insideString;
        }
        if (c != 125) {
            if (c != -1) {
                this.wrapped.unread(c);
            }
            ListIterator it = possibleValueExpression.listIterator(possibleValueExpression.size());
            while (it.hasPrevious()) {
                this.wrapped.unread((Integer)it.previous());
            }
            this.wrapped.unread(c2);
            return c1;
        }
        String expressionString = this.createExpressionString(possibleValueExpression);
        String expressionValue = (String)this.facesContext.getApplication().evaluateExpressionGet(this.facesContext, expressionString, String.class);
        if (expressionValue == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("ValueExpression " + expressionString + " evaluated to null.");
            }
            expressionValue = "null";
        }
        this.currentValue = expressionValue;
        if (this.currentValue.length() != 0) {
            this.currentValueIndex = 0;
            return this.currentValue.charAt(this.currentValueIndex++);
        }
        this.currentValueIndex = -1;
        return this.read();
    }

    private String createExpressionString(List<Integer> expressionList) {
        char[] expressionChars = new char[expressionList.size() + 3];
        int i = 0;
        expressionChars[i++] = 35;
        expressionChars[i++] = 123;
        for (Integer c : expressionList) {
            expressionChars[i++] = (char)c.intValue();
        }
        expressionChars[i] = 125;
        return String.valueOf(expressionChars);
    }
}

