/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import utils from '@/utils'
import { useMessage } from 'naive-ui'
import { useI18n } from 'vue-i18n'

/**
 * Text copy with success message
 */
export function useTextCopy() {
  const { t } = useI18n()
  const message = useMessage()
  const copyText = (text: string) => {
    if (utils.copy(text)) {
      message.success(t('project.dag.copy_success'))
    }
  }
  return {
    copy: copyText
  }
}
