/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataview.MapViewSerializer;
import org.apache.flink.table.dataview.NullAwareMapSerializer;
import org.apache.flink.table.dataview.NullSerializer;

@Deprecated
@Internal
public class MapViewTypeInfo<K, V>
extends TypeInformation<MapView<K, V>> {
    private static final long serialVersionUID = -2883944144965318259L;
    private final TypeInformation<K> keyType;
    private final TypeInformation<V> valueType;
    private final boolean nullAware;
    private boolean nullSerializer;

    public MapViewTypeInfo(TypeInformation<K> keyType, TypeInformation<V> valueType, boolean nullSerializer, boolean nullAware) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.nullSerializer = nullSerializer;
        this.nullAware = nullAware;
    }

    public MapViewTypeInfo(TypeInformation<K> keyType, TypeInformation<V> valueType) {
        this(keyType, valueType, false, false);
    }

    public TypeInformation<K> getKeyType() {
        return this.keyType;
    }

    public TypeInformation<V> getValueType() {
        return this.valueType;
    }

    public boolean isNullAware() {
        return this.nullAware;
    }

    public boolean isNullSerializer() {
        return this.nullSerializer;
    }

    public void setNullSerializer(boolean nullSerializer) {
        this.nullSerializer = nullSerializer;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<MapView<K, V>> getTypeClass() {
        return MapView.class;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<MapView<K, V>> createSerializer(SerializerConfig config) {
        if (this.nullSerializer) {
            return NullSerializer.INSTANCE;
        }
        TypeSerializer keySer = this.keyType.createSerializer(config);
        TypeSerializer valueSer = this.valueType.createSerializer(config);
        if (this.nullAware) {
            return new MapViewSerializer(new NullAwareMapSerializer(keySer, valueSer));
        }
        return new MapViewSerializer(new MapSerializer(keySer, valueSer));
    }

    public TypeSerializer<MapView<K, V>> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    public String toString() {
        return "MapView<" + this.keyType + ", " + this.valueType + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapViewTypeInfo) {
            MapViewTypeInfo other = (MapViewTypeInfo)((Object)obj);
            return this.keyType.equals(other.keyType) && this.valueType.equals(other.valueType) && this.nullSerializer == other.nullSerializer && this.nullAware == other.nullAware;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType, this.nullSerializer, this.nullAware);
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }
}

