/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.util.function.Function;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.lang.utils.ClassUtils;

public class ObjectInputFilterUtils {
    private static final String UNSUPPORTED_MESSAGE = "ObjectInputFilter is not available.";

    public static boolean supportsObjectInputFilter() {
        return ObjectInputFilterUtils.supportsObjectInputFilter(ClassUtils::isClassAvailable);
    }

    static void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE, null);
    }

    static void throwUnsupportedOperationException(Throwable cause) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE, cause);
    }

    static void throwUnsupportedOperationException(String message) {
        throw new UnsupportedOperationException(message, null);
    }

    static void throwUnsupportedOperationException(String message, Throwable cause) {
        throw new UnsupportedOperationException(message, cause);
    }

    @VisibleForTesting
    static boolean supportsObjectInputFilter(Function<String, Boolean> isClassAvailable) {
        return isClassAvailable.apply("sun.misc.ObjectInputFilter") != false || isClassAvailable.apply("java.io.ObjectInputFilter") != false;
    }

    private ObjectInputFilterUtils() {
    }
}

