/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.geode.distributed.internal.membership.api.MemberData;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.serialization.VersioningIO;
import org.jgroups.util.UUID;

public class GMSMemberData
implements MemberData,
Comparable<GMSMemberData> {
    public static final int NORMAL_DM_TYPE = 10;
    public static final int LOCATOR_DM_TYPE = 11;
    public static final int ADMIN_ONLY_DM_TYPE = 12;
    public static final int LONER_DM_TYPE = 13;
    public static final int NPD_ENABLED_BIT = 1;
    public static final int COORD_ENABLED_BIT = 2;
    public static final int PARTIAL_ID_BIT = 4;
    public static final int VERSION_BIT = 8;
    private String hostName;
    private int udpPort = 0;
    private boolean preferredForCoordinator;
    private boolean networkPartitionDetectionEnabled;
    private byte memberWeight;
    private InetAddress inetAddr;
    private int processId;
    private byte vmKind;
    private int vmViewId = -1;
    private int directPort;
    private String name;
    private String[] groups;
    private long uuidLSBs;
    private long uuidMSBs;
    private String durableId;
    private int durableTimeout;
    private String uniqueTag = null;
    private transient Version version = KnownVersion.CURRENT;
    private boolean isPartial;

    @Override
    public boolean isPartial() {
        return this.isPartial;
    }

    public GMSMemberData() {
    }

    public GMSMemberData(InetAddress i, String hostName, int membershipPort, int processId, byte vmKind, int directPort, int vmViewId, String name, String[] groups, String durableId, int durableTimeout, boolean networkPartitionDetectionEnabled, boolean preferredForCoordinator, short versionOrdinal, long msbs, long lsbs, byte memberWeight, boolean isPartial, String uniqueTag) {
        this.inetAddr = i;
        this.hostName = hostName;
        this.udpPort = membershipPort;
        this.processId = processId;
        this.vmKind = vmKind;
        this.directPort = directPort;
        this.vmViewId = vmViewId;
        this.name = name;
        this.groups = groups;
        this.durableId = durableId;
        this.durableTimeout = durableTimeout;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.preferredForCoordinator = preferredForCoordinator;
        this.version = Versioning.getVersion((short)versionOrdinal);
        this.uuidMSBs = msbs;
        this.uuidLSBs = lsbs;
        this.memberWeight = memberWeight;
        this.isPartial = isPartial;
        this.uniqueTag = uniqueTag;
    }

    public GMSMemberData(InetAddress i, int p, short versionOrdinal, long msbs, long lsbs, int viewId) {
        this.inetAddr = i;
        this.hostName = i.getHostName();
        this.udpPort = p;
        this.version = Versioning.getVersion((short)versionOrdinal);
        this.uuidMSBs = msbs;
        this.uuidLSBs = lsbs;
        this.vmViewId = viewId;
        this.vmKind = (byte)10;
        this.preferredForCoordinator = true;
    }

    public GMSMemberData(GMSMemberData other) {
        this.hostName = other.hostName;
        this.udpPort = other.udpPort;
        this.preferredForCoordinator = other.preferredForCoordinator;
        this.networkPartitionDetectionEnabled = other.networkPartitionDetectionEnabled;
        this.memberWeight = other.memberWeight;
        this.inetAddr = other.inetAddr;
        this.processId = other.processId;
        this.vmKind = other.vmKind;
        this.vmViewId = other.vmViewId;
        this.directPort = other.directPort;
        this.name = other.name;
        this.durableId = other.durableId;
        this.durableTimeout = other.durableTimeout;
        this.groups = other.groups;
        this.version = other.version;
        this.uuidLSBs = other.uuidLSBs;
        this.uuidMSBs = other.uuidMSBs;
        this.isPartial = other.isPartial;
        this.uniqueTag = other.uniqueTag;
    }

    @Override
    public int getMembershipPort() {
        return this.udpPort;
    }

    @Override
    public boolean isPreferredForCoordinator() {
        return this.preferredForCoordinator;
    }

    @Override
    public void setPreferredForCoordinator(boolean preferred) {
        this.preferredForCoordinator = preferred;
    }

    @Override
    public String getDurableId() {
        return this.durableId;
    }

    @Override
    public int getDurableTimeout() {
        return this.durableTimeout;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddr;
    }

    @Override
    public short getVersionOrdinal() {
        return this.version.ordinal();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Override
    public void setUUID(UUID u) {
        if (u == null) {
            this.uuidLSBs = 0L;
            this.uuidMSBs = 0L;
        } else {
            this.uuidLSBs = u.getLeastSignificantBits();
            this.uuidMSBs = u.getMostSignificantBits();
        }
    }

    @Override
    public UUID getUUID() {
        if (this.uuidLSBs == 0L && this.uuidMSBs == 0L) {
            return null;
        }
        return new UUID(this.uuidMSBs, this.uuidLSBs);
    }

    @Override
    public long getUuidMostSignificantBits() {
        return this.uuidMSBs;
    }

    @Override
    public long getUuidLeastSignificantBits() {
        return this.uuidLSBs;
    }

    @Override
    public int compareTo(GMSMemberData o) {
        return this.compareTo(o, true);
    }

    @Override
    public int compareTo(MemberData o, boolean compareUUIDs) {
        return this.compareTo(o, compareUUIDs, true);
    }

    @Override
    public int compareTo(MemberData o, boolean compareUUIDs, boolean compareViewIds) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            throw new ClassCastException("GMSMember.compareTo(): comparison between different classes");
        }
        byte[] myAddr = this.inetAddr.getAddress();
        GMSMemberData his = (GMSMemberData)o;
        byte[] hisAddr = his.inetAddr.getAddress();
        if (myAddr != hisAddr) {
            for (int idx = 0; idx < myAddr.length; ++idx) {
                if (idx >= hisAddr.length) {
                    return 1;
                }
                if (myAddr[idx] > hisAddr[idx]) {
                    return 1;
                }
                if (myAddr[idx] >= hisAddr[idx]) continue;
                return -1;
            }
            if (hisAddr.length > myAddr.length) {
                return -1;
            }
        }
        if (this.udpPort < his.udpPort) {
            return -1;
        }
        if (his.udpPort < this.udpPort) {
            return 1;
        }
        int result = 0;
        if (compareViewIds && this.vmViewId >= 0 && his.vmViewId >= 0) {
            if (this.vmViewId < his.vmViewId) {
                result = -1;
            } else if (his.vmViewId < this.vmViewId) {
                result = 1;
            }
        }
        if (compareUUIDs && result == 0 && this.uuidMSBs != 0L && his.uuidMSBs != 0L) {
            if (this.uuidMSBs < his.uuidMSBs) {
                result = -1;
            } else if (his.uuidMSBs < this.uuidMSBs) {
                result = 1;
            } else if (this.uuidLSBs < his.uuidLSBs) {
                result = -1;
            } else if (his.uuidLSBs < this.uuidLSBs) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public int compareAdditionalData(MemberData o) {
        GMSMemberData his = (GMSMemberData)o;
        int result = 0;
        if (this.uuidMSBs != 0L && his.uuidMSBs != 0L) {
            if (this.uuidMSBs < his.uuidMSBs) {
                result = -1;
            } else if (his.uuidMSBs < this.uuidMSBs) {
                result = 1;
            } else if (this.uuidLSBs < his.uuidLSBs) {
                result = -1;
            } else if (his.uuidLSBs < this.uuidLSBs) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public int getVmPid() {
        return this.processId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GMSMemberData)) {
            return false;
        }
        return this.compareTo((GMSMemberData)obj) == 0;
    }

    public int hashCode() {
        if (this.inetAddr == null) {
            return this.udpPort;
        }
        return this.udpPort + this.inetAddr.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("MemberData[");
        if (this.name != null && this.name.length() > 0) {
            sb.append("name=").append(this.name).append(';');
        }
        sb.append("addr=").append(this.inetAddr).append(";port=").append(this.udpPort).append(";kind=").append(this.vmKind).append(";processId=").append(this.processId).append(";viewId=").append(this.vmViewId);
        if (this.getVersionOrdinal() != KnownVersion.CURRENT_ORDINAL) {
            sb.append(";version=").append(this.getVersionOrdinal());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    @Override
    public byte getMemberWeight() {
        return this.memberWeight;
    }

    @Override
    public InetAddress getInetAddr() {
        return this.inetAddr;
    }

    @Override
    public int getProcessId() {
        return this.processId;
    }

    @Override
    public byte getVmKind() {
        return this.vmKind;
    }

    @Override
    public int getVmViewId() {
        return this.vmViewId;
    }

    @Override
    public void setVmViewId(int id) {
        this.vmViewId = id;
    }

    @Override
    public int getDirectChannelPort() {
        return this.directPort;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getRoles() {
        return this.groups;
    }

    @Override
    public void setUdpPort(int udpPort) {
        this.udpPort = udpPort;
    }

    @Override
    public void setNetworkPartitionDetectionEnabled(boolean networkPartitionDetectionEnabled) {
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
    }

    @Override
    public void setMemberWeight(byte memberWeight) {
        this.memberWeight = memberWeight;
    }

    @Override
    public void setInetAddr(InetAddress inetAddr) {
        this.inetAddr = inetAddr;
    }

    @Override
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    @Override
    public void setVmKind(int vmKind) {
        this.vmKind = (byte)vmKind;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public void setDirectChannelPort(int directPort) {
        this.directPort = directPort;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String[] getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    @Override
    public void setPort(int p) {
        this.udpPort = p;
    }

    @Override
    public boolean hasUUID() {
        return this.uuidLSBs != 0L || this.uuidMSBs != 0L;
    }

    @Override
    public void writeEssentialData(DataOutput out, SerializationContext context) throws IOException {
        VersioningIO.writeOrdinal((DataOutput)out, (short)this.getVersionOrdinal(), (boolean)true);
        int flags = 0;
        if (this.networkPartitionDetectionEnabled) {
            flags |= 1;
        }
        if (this.preferredForCoordinator) {
            flags |= 2;
        }
        out.writeShort(flags);
        StaticSerialization.writeInetAddress((InetAddress)this.inetAddr, (DataOutput)out);
        out.writeInt(this.udpPort);
        out.writeInt(this.vmViewId);
        out.writeLong(this.uuidMSBs);
        out.writeLong(this.uuidLSBs);
        if (context.getSerializationVersion().ordinal() >= KnownVersion.GEODE_1_2_0.ordinal()) {
            out.writeByte(this.vmKind);
        }
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public void readEssentialData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.setVersion(Versioning.getVersion((short)VersioningIO.readOrdinal((DataInput)in)));
        short flags = in.readShort();
        this.networkPartitionDetectionEnabled = (flags & 1) != 0;
        this.preferredForCoordinator = (flags & 2) != 0;
        this.inetAddr = StaticSerialization.readInetAddress((DataInput)in);
        if (this.inetAddr != null) {
            this.hostName = this.inetAddr.getHostAddress();
        }
        this.udpPort = in.readInt();
        this.vmViewId = in.readInt();
        this.uuidMSBs = in.readLong();
        this.uuidLSBs = in.readLong();
        if (context.getSerializationVersion().ordinal() >= KnownVersion.GEODE_1_2_0.ordinal()) {
            this.vmKind = in.readByte();
        }
        this.isPartial = true;
    }

    @Override
    public boolean hasAdditionalData() {
        return this.uuidMSBs != 0L || this.uuidLSBs != 0L || this.memberWeight != 0;
    }

    @Override
    public void writeAdditionalData(DataOutput out) throws IOException {
        out.writeLong(this.uuidMSBs);
        out.writeLong(this.uuidLSBs);
        out.write(this.memberWeight);
    }

    @Override
    public void readAdditionalData(DataInput in) throws ClassNotFoundException, IOException {
        try {
            this.uuidMSBs = in.readLong();
            this.uuidLSBs = in.readLong();
            this.memberWeight = (byte)(in.readByte() & 0xFF);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void setDurableTimeout(int newValue) {
        this.durableTimeout = newValue;
    }

    @Override
    public void setDurableId(String id) {
        this.durableId = id;
    }

    @Override
    public void setIsPartial(boolean value) {
        this.isPartial = value;
    }

    @Override
    public void setUniqueTag(String tag) {
        this.uniqueTag = tag;
    }
}

