/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectRequest;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class SuspectMembersMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID> {
    final List<SuspectRequest<ID>> suspectRequests;

    public SuspectMembersMessage(List<ID> recipients, List<SuspectRequest<ID>> s) {
        this.setRecipients(recipients);
        this.suspectRequests = s;
    }

    public SuspectMembersMessage() {
        this.suspectRequests = new ArrayList<SuspectRequest<ID>>();
    }

    public int getDSFID() {
        return -156;
    }

    public List<SuspectRequest<ID>> getMembers() {
        return this.suspectRequests;
    }

    public String toString() {
        return "SuspectMembersMessage [suspectRequests=" + this.suspectRequests + "]";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        if (this.suspectRequests != null) {
            out.writeInt(this.suspectRequests.size());
            for (SuspectRequest<ID> sr : this.suspectRequests) {
                context.getSerializer().writeObject(sr.getSuspectMember(), out);
                StaticSerialization.writeString((String)sr.getReason(), (DataOutput)out);
            }
        } else {
            out.writeInt(0);
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SuspectRequest<MemberIdentifier> sr = new SuspectRequest<MemberIdentifier>((MemberIdentifier)context.getDeserializer().readObject(in), StaticSerialization.readString((DataInput)in));
            this.suspectRequests.add(sr);
        }
    }
}

