/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.results;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.offheap.StoredObject;

public class PageEntry {
    public Object key;
    public Object value;

    public PageEntry() {
    }

    public PageEntry(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.value instanceof CachedDeserializable) {
            return ((CachedDeserializable)this.value).getDeserializedValue(null, null);
        }
        return this.value;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject((Object)this.key, (DataOutput)out);
        if (this.value instanceof StoredObject) {
            ((StoredObject)this.value).sendTo(out);
            return;
        }
        if (this.value instanceof CachedDeserializable) {
            this.value = ((CachedDeserializable)this.value).getValue();
            if (this.value instanceof byte[]) {
                out.write((byte[])this.value);
                return;
            }
        }
        DataSerializer.writeObject((Object)this.value, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readObject((DataInput)in);
        this.value = DataSerializer.readObject((DataInput)in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageEntry pageEntry = (PageEntry)o;
        if (!this.getKey().equals(pageEntry.getKey())) {
            return false;
        }
        return this.getValue().equals(pageEntry.getValue());
    }

    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + this.getValue().hashCode();
        return result;
    }
}

