/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.internal.GemFireHealthConfigImpl;
import org.apache.geode.admin.jmx.internal.GemFireHealthJmxImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtils;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;

@SuppressWarnings(justification="This class is deprecated. Also, any further changes so close to the release is inadvisable.")
public class GemFireHealthConfigJmxImpl
implements GemFireHealthConfig,
ManagedResource,
Serializable {
    private static final long serialVersionUID = 1482719647163239953L;
    private final GemFireHealth health;
    private final String mbeanName;
    private ModelMBean modelMBean;
    private final GemFireHealthConfig delegate;
    private final ObjectName objectName;

    GemFireHealthConfigJmxImpl(GemFireHealthJmxImpl health, String hostName) throws AdminException {
        this.delegate = new GemFireHealthConfigImpl(hostName);
        this.health = health;
        this.mbeanName = "GemFire:type=GemFireHealthConfig,id=" + MBeanUtils.makeCompliantMBeanNameProperty(health.getDistributedSystem().getId()) + ",host=" + (hostName == null ? "default" : MBeanUtils.makeCompliantMBeanNameProperty(hostName));
        this.objectName = MBeanUtils.createMBean(this);
    }

    public void applyChanges() {
        String hostName = this.getHostName();
        if (hostName == null) {
            this.health.setDefaultGemFireHealthConfig(this);
        } else {
            this.health.setGemFireHealthConfig(hostName, this);
        }
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.GEMFIRE_HEALTH_CONFIG;
    }

    public Object writeReplace() {
        return this.delegate;
    }

    @Override
    public long getMaxVMProcessSize() {
        return this.delegate.getMaxVMProcessSize();
    }

    @Override
    public void setMaxVMProcessSize(long size) {
        this.delegate.setMaxVMProcessSize(size);
    }

    @Override
    public long getMaxMessageQueueSize() {
        return this.delegate.getMaxMessageQueueSize();
    }

    @Override
    public void setMaxMessageQueueSize(long maxMessageQueueSize) {
        this.delegate.setMaxMessageQueueSize(maxMessageQueueSize);
    }

    @Override
    public long getMaxReplyTimeouts() {
        return this.delegate.getMaxReplyTimeouts();
    }

    @Override
    public void setMaxReplyTimeouts(long maxReplyTimeouts) {
        this.delegate.setMaxReplyTimeouts(maxReplyTimeouts);
    }

    @Override
    public double getMaxRetransmissionRatio() {
        return this.delegate.getMaxRetransmissionRatio();
    }

    @Override
    public void setMaxRetransmissionRatio(double ratio) {
        this.delegate.setMaxRetransmissionRatio(ratio);
    }

    @Override
    public long getMaxNetSearchTime() {
        return this.delegate.getMaxNetSearchTime();
    }

    @Override
    public void setMaxNetSearchTime(long maxNetSearchTime) {
        this.delegate.setMaxNetSearchTime(maxNetSearchTime);
    }

    @Override
    public long getMaxLoadTime() {
        return this.delegate.getMaxLoadTime();
    }

    @Override
    public void setMaxLoadTime(long maxLoadTime) {
        this.delegate.setMaxLoadTime(maxLoadTime);
    }

    @Override
    public double getMinHitRatio() {
        return this.delegate.getMinHitRatio();
    }

    @Override
    public void setMinHitRatio(double minHitRatio) {
        this.delegate.setMinHitRatio(minHitRatio);
    }

    @Override
    public long getMaxEventQueueSize() {
        return this.delegate.getMaxEventQueueSize();
    }

    @Override
    public void setMaxEventQueueSize(long maxEventQueueSize) {
        this.delegate.setMaxEventQueueSize(maxEventQueueSize);
    }

    @Override
    public String getHostName() {
        return this.delegate.getHostName();
    }

    @Override
    public void setHealthEvaluationInterval(int interval) {
        this.delegate.setHealthEvaluationInterval(interval);
    }

    @Override
    public int getHealthEvaluationInterval() {
        return this.delegate.getHealthEvaluationInterval();
    }

    @Override
    public void cleanupResource() {
    }
}

