/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client;

import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;

public class ServerOperationException
extends ServerConnectivityException {
    private static final long serialVersionUID = -3106323103325266219L;

    public ServerOperationException() {
    }

    public ServerOperationException(String message) {
        super(ServerOperationException.getServerMessage(message));
    }

    public ServerOperationException(String message, Throwable cause) {
        super(ServerOperationException.getServerMessage(message), cause);
    }

    public ServerOperationException(Throwable cause) {
        super(ServerOperationException.getServerMessage(cause), cause);
    }

    private static String getServerMessage(Throwable cause) {
        return ServerOperationException.getServerMessage(cause != null ? cause.toString() : null);
    }

    private static String getServerMessage(String msg) {
        InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
        if (ids != null) {
            if (msg != null) {
                return "remote server on " + ids.getMemberId() + ": " + msg;
            }
            return "remote server on " + ids.getMemberId();
        }
        if (msg != null) {
            return "remote server on unknown location: " + msg;
        }
        return "remote server on unknown location";
    }
}

