/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.QRegion;

public class CompiledIndexOperation
extends AbstractCompiledValue
implements MapIndexable {
    private final CompiledValue receiver;
    private final CompiledValue indexExpr;
    private boolean evalRegionAsEntry = false;

    public CompiledIndexOperation(CompiledValue receiver, CompiledValue indexExpr) {
        this.receiver = receiver;
        this.indexExpr = indexExpr;
    }

    public CompiledIndexOperation(CompiledValue receiver, CompiledValue indexExpr, boolean evalRegionAsEntry) {
        this.receiver = receiver;
        this.indexExpr = indexExpr;
        this.evalRegionAsEntry = evalRegionAsEntry;
    }

    @Override
    public List getChildren() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>();
        list.add(this.receiver);
        list.add(this.indexExpr);
        return list;
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        context.addDependencies(this, this.receiver.computeDependencies(context));
        return context.addDependencies(this, this.indexExpr.computeDependencies(context));
    }

    @Override
    public Object evaluate(ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Object rcvr = this.receiver.evaluate(context);
        Object index = this.indexExpr.evaluate(context);
        if (rcvr == null || rcvr == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (context.isCqQueryContext() && (rcvr instanceof Region.Entry || rcvr instanceof CqEntry)) {
            try {
                Object re;
                if (rcvr instanceof Region.Entry) {
                    re = (Region.Entry)rcvr;
                    if (re.isDestroyed()) {
                        return QueryService.UNDEFINED;
                    }
                    rcvr = re.getValue();
                } else if (rcvr instanceof CqEntry) {
                    re = (CqEntry)rcvr;
                    rcvr = ((CqEntry)re).getValue();
                }
            }
            catch (EntryDestroyedException ede) {
                return QueryService.UNDEFINED;
            }
        }
        if (rcvr instanceof Map) {
            return ((Map)rcvr).get(index);
        }
        if ((rcvr instanceof List || rcvr.getClass().isArray() || rcvr instanceof String) && !(index instanceof Integer)) {
            throw new TypeMismatchException("index expression must be an integer for lists or arrays");
        }
        if (rcvr instanceof List) {
            return ((List)rcvr).get((Integer)index);
        }
        if (rcvr instanceof String) {
            return Character.valueOf(((String)rcvr).charAt((Integer)index));
        }
        if (rcvr.getClass().isArray()) {
            return Array.get(rcvr, (Integer)index);
        }
        if (rcvr instanceof QRegion) {
            Region.Entry entry = ((QRegion)rcvr).getEntry(index);
            if (entry == null) {
                return null;
            }
            return this.evalRegionAsEntry ? entry : entry.getValue();
        }
        throw new TypeMismatchException(String.format("index expression not supported on objects of type %s", rcvr.getClass().getName()));
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ']');
        this.indexExpr.generateCanonicalizedExpression(clauseBuffer, context);
        clauseBuffer.insert(0, '[');
        this.receiver.generateCanonicalizedExpression(clauseBuffer, context);
    }

    @Override
    public CompiledValue getReceiver() {
        return this.receiver;
    }

    @Override
    public boolean hasIdentifierAtLeafNode() {
        if (this.receiver.getType() == 35) {
            return true;
        }
        return this.receiver.hasIdentifierAtLeafNode();
    }

    public CompiledValue getExpression() {
        return this.indexExpr;
    }

    @Override
    public CompiledValue getMapLookupKey() {
        return this.indexExpr;
    }

    @Override
    public CompiledValue getReceiverSansIndexArgs() {
        return this.receiver;
    }

    @Override
    public List<CompiledValue> getIndexingKeys() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>(1);
        list.add(this.indexExpr);
        return list;
    }
}

