/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.SortedStructSet;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class LinkedStructSet
extends LinkedHashSet<Struct>
implements SelectResults<Struct>,
Ordered,
DataSerializableFixedID {
    private static final long serialVersionUID = -1687142950781718156L;
    protected StructTypeImpl structType;
    private boolean modifiable = true;

    public LinkedStructSet() {
    }

    public LinkedStructSet(StructTypeImpl structType) {
        if (structType == null) {
            throw new IllegalArgumentException("structType must not be null");
        }
        this.structType = structType;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SortedStructSet && this.structType.equals(((SortedStructSet)other).structType) && super.equals(other);
    }

    @Override
    public boolean add(Struct obj) {
        if (!(obj instanceof StructImpl)) {
            throw new IllegalArgumentException("This set only accepts StructImpl");
        }
        StructImpl s = (StructImpl)obj;
        if (!s.getStructType().equals(this.structType)) {
            throw new IllegalArgumentException("obj does not have the same StructType");
        }
        return super.add(s);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        return this.structType.equals(StructTypeImpl.typeFromStruct(s)) && this.contains(s);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)o;
        return this.structType.equals(StructTypeImpl.typeFromStruct(s)) && this.remove(s);
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Ordered.class, (ObjectType)this.structType);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (!(elementType instanceof StructTypeImpl)) {
            throw new IllegalArgumentException("element type must be struct");
        }
        this.structType = (StructTypeImpl)elementType;
    }

    @Override
    public List asList() {
        return new ArrayList<Struct>(this);
    }

    @Override
    public Set asSet() {
        return this;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public int occurrences(Struct element) {
        return this.contains(element) ? 1 : 0;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            buf.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(",\n ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.modifiable = in.readBoolean();
        int size = in.readInt();
        this.structType = (StructTypeImpl)context.getDeserializer().readObject(in);
        for (int j = size; j > 0; --j) {
            Object[] fieldValues = (Object[])context.getDeserializer().readObject(in);
            this.add(new StructImpl(this.structType, fieldValues));
        }
    }

    public int getDSFID() {
        return 2123;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeBoolean(this.modifiable);
        out.writeInt(this.size());
        context.getSerializer().writeObject((Object)this.structType, out);
        for (Struct struct : this) {
            context.getSerializer().writeObject((Object)struct.getFieldValues(), out);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    public Comparator comparator() {
        return null;
    }

    @Override
    public boolean dataPreordered() {
        return true;
    }
}

