/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.pdx.internal.PdxString;

public class PrimaryKeyIndex
extends AbstractIndex {
    protected long numUses = 0L;
    ObjectType indexResultType;

    public PrimaryKeyIndex(InternalCache cache, String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndxExpr, String[] defintions, IndexStatistics indexStatistics) {
        super(cache, indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndxExpr, defintions, indexStatistics);
        Class<Object> constr = region.getAttributes().getValueConstraint();
        if (constr == null) {
            constr = Object.class;
        }
        this.indexResultType = new ObjectTypeImpl(constr);
        this.markValid(true);
    }

    @Override
    public IndexType getType() {
        return IndexType.PRIMARY_KEY;
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    @Override
    public ObjectType getResultSetType() {
        return this.indexResultType;
    }

    @Override
    void removeMapping(RegionEntry entry, int opCode) {
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper indexCreationHelper) {
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        Boolean applyLimit;
        assert (keysToRemove == null);
        int limit = -1;
        if (key instanceof PdxString) {
            key = key.toString();
        }
        if ((applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index")) != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (limit != -1 && results.size() == limit) {
            observer.limitAppliedAtIndexLevel(this, limit, results);
            return;
        }
        switch (operator) {
            case 13: {
                Object value;
                Region.Entry entry;
                if (key == null || key == QueryService.UNDEFINED || (entry = ((LocalRegion)this.getRegion()).accessEntry(key, false)) == null || (value = entry.getValue()) == null) break;
                this.addResultToResults(context, results, key, value);
                break;
            }
            case 20: 
            case 21: {
                Iterator itr;
                Region.Entry entry;
                boolean removeOneRow;
                Set values = (Set)this.getRegion().values();
                if (limit != -1) {
                    ++limit;
                }
                for (Object value : values) {
                    QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
                    this.addResultToResults(context, results, key, value);
                    if (limit == -1 || results.size() != limit) continue;
                    observer.limitAppliedAtIndexLevel(this, limit, results);
                    return;
                }
                boolean bl = removeOneRow = limit != -1;
                if (key != null && key != QueryService.UNDEFINED && (entry = ((LocalRegion)this.getRegion()).accessEntry(key, false)) != null && entry.getValue() != null) {
                    results.remove(entry.getValue());
                    removeOneRow = false;
                }
                if (!removeOneRow || !(itr = results.iterator()).hasNext()) break;
                itr.next();
                itr.remove();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Operator");
            }
        }
        ++this.numUses;
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        int limit = -1;
        Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        if (applyLimit != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        if (limit != -1 && results.size() == limit) {
            observer.limitAppliedAtIndexLevel(this, limit, results);
            return;
        }
        if (key instanceof PdxString) {
            key = key.toString();
        }
        block0 : switch (operator) {
            case 13: {
                Object value;
                Region.Entry entry;
                if (key == null || key == QueryService.UNDEFINED || (entry = ((LocalRegion)this.getRegion()).accessEntry(key, false)) == null || (value = entry.getValue()) == null) break;
                boolean ok = true;
                if (runtimeItr != null) {
                    runtimeItr.setCurrent(value);
                    ok = QueryUtils.applyCondition(iterOps, context);
                }
                if (!ok) break;
                this.applyCqOrProjection(projAttrib, context, results, value, intermediateResults, isIntersection, key);
                break;
            }
            case 20: 
            case 21: {
                Set entries = this.getRegion().entrySet();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Object val;
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    if (key != null && key != QueryService.UNDEFINED && key.equals(entry.getKey()) || (val = entry.getValue()) == null) continue;
                    boolean ok = true;
                    if (runtimeItr != null) {
                        runtimeItr.setCurrent(val);
                        ok = QueryUtils.applyCondition(iterOps, context);
                    }
                    if (ok) {
                        this.applyCqOrProjection(projAttrib, context, results, val, intermediateResults, isIntersection, key);
                    }
                    if (limit == -1 || results.size() != limit) continue;
                    observer.limitAppliedAtIndexLevel(this, limit, results);
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Operator");
            }
        }
        ++this.numUses;
    }

    @Override
    void recreateIndexData() throws IMQException {
        Support.Assert(false, "PrimaryKeyIndex::recreateIndexData: This method should not have got invoked at all");
    }

    @Override
    public boolean clear() throws QueryException {
        return true;
    }

    private void addResultToResults(ExecutionContext context, Collection results, Object key, Object result) {
        if (context != null && context.isCqQueryContext()) {
            results.add(new CqEntry(key, result));
        } else {
            results.add(result);
        }
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        return new PrimaryKeyIndexStatistics();
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        throw new UnsupportedOperationException("For a PrimaryKey Index , a range has no meaning");
    }

    @Override
    public int getSizeEstimate(Object key, int op, int matchLevel) {
        return 1;
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    public boolean isEmpty() {
        return this.createStats("primaryKeyIndex").getNumberOfKeys() == 0L;
    }

    class PrimaryKeyIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        PrimaryKeyIndexStatistics() {
        }

        @Override
        public long getTotalUses() {
            return PrimaryKeyIndex.this.numUses;
        }

        @Override
        public long getNumberOfKeys() {
            return PrimaryKeyIndex.this.getRegion().keySet().size();
        }

        @Override
        public long getNumberOfValues() {
            return PrimaryKeyIndex.this.getRegion().values().size();
        }

        @Override
        public long getNumberOfValues(Object key) {
            if (PrimaryKeyIndex.this.getRegion().containsValueForKey(key)) {
                return 1L;
            }
            return 0L;
        }

        public String toString() {
            return "No Keys = " + this.getNumberOfKeys() + "\nNo Values = " + this.getNumberOfValues() + "\nNo Uses = " + this.getTotalUses() + "\nNo Updates = " + this.getNumUpdates() + "\nTotal Update time = " + this.getTotalUpdateTime() + "\n";
        }
    }
}

