/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.ToDataException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.Distribution;
import org.apache.geode.distributed.internal.DistributionException;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.ShutdownMessage;
import org.apache.geode.distributed.internal.SizeableRunnable;
import org.apache.geode.distributed.internal.direct.DirectChannel;
import org.apache.geode.distributed.internal.direct.ShunnedMemberException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.adapter.ServiceConfig;
import org.apache.geode.distributed.internal.membership.adapter.auth.GMSAuthenticator;
import org.apache.geode.distributed.internal.membership.api.Authenticator;
import org.apache.geode.distributed.internal.membership.api.LifecycleListener;
import org.apache.geode.distributed.internal.membership.api.MemberDisconnectedException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifierFactory;
import org.apache.geode.distributed.internal.membership.api.MemberShunnedException;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.distributed.internal.membership.api.MembershipBuilder;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipListener;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipStatistics;
import org.apache.geode.distributed.internal.membership.api.MembershipView;
import org.apache.geode.distributed.internal.membership.api.Message;
import org.apache.geode.distributed.internal.membership.api.MessageListener;
import org.apache.geode.distributed.internal.membership.api.QuorumChecker;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.serialization.DSFIDSerializer;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.tcp.ConnectExceptions;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class DistributionImpl
implements Distribution {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    public static final InternalDistributedMember[] EMPTY_MEMBER_ARRAY = new InternalDistributedMember[0];
    private final ClusterDistributionManager clusterDistributionManager;
    private final boolean tcpDisabled;
    private final boolean mcastEnabled;
    private final long ackSevereAlertThreshold;
    private final long ackWaitThreshold;
    private final RemoteTransportConfig transportConfig;
    private final Membership<InternalDistributedMember> membership;
    private DirectChannel directChannel;
    private final ThreadLocal<Boolean> forceUseUDPMessaging = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private MyDCReceiver dcReceiver;
    private final long memberTimeout;
    private boolean disableAutoReconnect;

    public DistributionImpl(ClusterDistributionManager clusterDistributionManager, RemoteTransportConfig transport, InternalDistributedSystem system, MembershipListener<InternalDistributedMember> listener, MessageListener<InternalDistributedMember> messageListener, MembershipLocator<InternalDistributedMember> locator) {
        this.clusterDistributionManager = clusterDistributionManager;
        this.transportConfig = transport;
        this.tcpDisabled = this.transportConfig.isTcpDisabled();
        this.mcastEnabled = this.transportConfig.isMcastEnabled();
        this.ackSevereAlertThreshold = system.getConfig().getAckSevereAlertThreshold();
        this.ackWaitThreshold = system.getConfig().getAckWaitThreshold();
        this.disableAutoReconnect = system.getConfig().getDisableAutoReconnect();
        if (!this.tcpDisabled) {
            this.dcReceiver = new MyDCReceiver();
        }
        this.memberTimeout = system.getConfig().getMemberTimeout();
        try {
            TcpClient locatorClient = new TcpClient((TcpSocketCreator)SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT);
            SocketCreator socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.CLUSTER);
            this.membership = MembershipBuilder.newMembershipBuilder((TcpSocketCreator)socketCreator, (TcpClient)locatorClient, (DSFIDSerializer)InternalDataSerializer.getDSFIDSerializer(), (MemberIdentifierFactory)new ClusterDistributionManager.ClusterDistributionManagerIDFactory()).setMembershipLocator(locator).setAuthenticator((Authenticator)new GMSAuthenticator(system.getSecurityProperties(), system.getSecurityService(), system.getSecurityLogWriter(), system.getInternalLogWriter())).setStatistics((MembershipStatistics)clusterDistributionManager.stats).setMessageListener(messageListener).setMembershipListener(listener).setConfig((MembershipConfig)new ServiceConfig(transport, system.getConfig())).setLifecycleListener((LifecycleListener)new LifecycleListenerImpl(this)).create();
        }
        catch (MembershipConfigurationException e) {
            throw new GemFireConfigException(e.getMessage(), e.getCause());
        }
        catch (GemFireSecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("Unexpected problem starting up membership services", (Throwable)e);
            throw new SystemConnectException("Problem starting up membership services", e);
        }
    }

    @Override
    public Membership<InternalDistributedMember> getMembership() {
        return this.membership;
    }

    @Override
    public void start() {
        try {
            this.membership.start();
        }
        catch (ConnectionException e) {
            throw new DistributionException("Unable to create membership manager", e);
        }
        catch (SecurityException e) {
            String failReason = e.getMessage();
            if (failReason.contains("Failed to find credentials")) {
                throw new AuthenticationRequiredException(failReason);
            }
            throw new GemFireSecurityException(e.getMessage(), e);
        }
        catch (MembershipConfigurationException e) {
            throw new GemFireConfigException("Problem configuring membership services", e);
        }
        catch (MemberStartupException e) {
            throw new SystemConnectException("Problem starting up membership services", e);
        }
        catch (RuntimeException e) {
            logger.error("Unexpected problem starting up membership services", (Throwable)e);
            throw new SystemConnectException("Problem starting up membership services: " + e.getMessage() + ".  Consult log file for more details");
        }
    }

    @VisibleForTesting
    DistributionImpl(ClusterDistributionManager clusterDistributionManager, RemoteTransportConfig transport, InternalDistributedSystem system, Membership<InternalDistributedMember> membership) {
        this.clusterDistributionManager = clusterDistributionManager;
        this.transportConfig = transport;
        this.tcpDisabled = this.transportConfig.isTcpDisabled();
        this.mcastEnabled = this.transportConfig.isMcastEnabled();
        this.ackSevereAlertThreshold = system.getConfig().getAckSevereAlertThreshold();
        this.ackWaitThreshold = system.getConfig().getAckWaitThreshold();
        if (!this.tcpDisabled) {
            this.dcReceiver = new MyDCReceiver();
        }
        this.memberTimeout = system.getConfig().getMemberTimeout();
        this.membership = membership;
    }

    static DistributionImpl createDistribution(ClusterDistributionManager clusterDistributionManager, RemoteTransportConfig transport, InternalDistributedSystem system, MembershipListener<InternalDistributedMember> listener, MessageListener<InternalDistributedMember> messageListener, MembershipLocator<InternalDistributedMember> locator) {
        DistributionImpl distribution = new DistributionImpl(clusterDistributionManager, transport, system, listener, messageListener, locator);
        distribution.start();
        return distribution;
    }

    @Override
    public MembershipView<InternalDistributedMember> getView() {
        return this.membership.getView();
    }

    @Override
    public InternalDistributedMember getLocalMember() {
        return (InternalDistributedMember)this.membership.getLocalMember();
    }

    @Override
    public Set<InternalDistributedMember> send(List<InternalDistributedMember> destinations, DistributionMessage msg) throws NotSerializableException {
        boolean allDestinations = msg.forAll();
        this.checkCancelled();
        this.membership.waitIfPlayingDead();
        if (this.membership.isJoining()) {
            if (allDestinations) {
                return null;
            }
            return new HashSet<InternalDistributedMember>(destinations);
        }
        if (msg instanceof AdminMessageType && this.shutdownInProgress()) {
            return new HashSet<InternalDistributedMember>(msg.getRecipients());
        }
        if (destinations == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Message send: returning early because null set passed in: '{}'", (Object)msg);
            }
            return null;
        }
        if (destinations.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Message send: returning early because empty destination list passed in: '{}'", (Object)msg);
            }
            return null;
        }
        msg.setSender(this.getLocalMember());
        msg.setBreadcrumbsInSender();
        Breadcrumbs.setProblem(null);
        boolean useMcast = false;
        if (this.mcastEnabled) {
            useMcast = msg.getMulticast() || allDestinations;
        }
        boolean sendViaMessenger = this.isForceUDPCommunications() || msg instanceof ShutdownMessage;
        Set<InternalDistributedMember> result = useMcast || this.tcpDisabled || sendViaMessenger ? this.membership.send((MemberIdentifier[])destinations.toArray(EMPTY_MEMBER_ARRAY), (Message)msg) : this.directChannelSend(destinations, msg);
        if (allDestinations) {
            return null;
        }
        return result;
    }

    private void checkCancelled() {
        try {
            this.membership.checkCancelled();
        }
        catch (MembershipClosedException e) {
            if (e.getCause() instanceof MemberDisconnectedException) {
                ForcedDisconnectException fde = new ForcedDisconnectException(e.getCause().getMessage());
                throw new DistributedSystemDisconnectedException(e.getMessage(), fde);
            }
            throw new DistributedSystemDisconnectedException(e.getMessage());
        }
    }

    @Override
    public Set<InternalDistributedMember> directChannelSend(List<InternalDistributedMember> destinations, DistributionMessage content) throws NotSerializableException {
        InternalDistributedMember[] keys;
        boolean allDestinations;
        DMStats theStats = this.clusterDistributionManager.getStats();
        if (content.forAll()) {
            allDestinations = true;
            keys = (InternalDistributedMember[])this.membership.getAllMembers((MemberIdentifier[])EMPTY_MEMBER_ARRAY);
        } else {
            allDestinations = false;
            keys = destinations.toArray(EMPTY_MEMBER_ARRAY);
        }
        try {
            int sentBytes = this.directChannel.send(this.membership, keys, content, this.ackWaitThreshold, this.ackSevereAlertThreshold);
            if (theStats != null) {
                theStats.incSentBytes(sentBytes);
            }
            if (sentBytes == 0) {
                this.checkCancelled();
            }
        }
        catch (MembershipClosedException e) {
            this.checkCancelled();
            throw new DistributedSystemDisconnectedException(e.getMessage(), e.getCause());
        }
        catch (DistributedSystemDisconnectedException ex) {
            this.checkCancelled();
            throw ex;
        }
        catch (ConnectExceptions ex) {
            if (this.membership.shutdownInProgress()) {
                this.checkCancelled();
                throw new DistributedSystemDisconnectedException();
            }
            if (allDestinations) {
                return null;
            }
            List<InternalDistributedMember> members = ex.getMembers();
            Iterator<InternalDistributedMember> it_mem = members.iterator();
            Iterator<Throwable> it_causes = ex.getCauses().iterator();
            while (it_mem.hasNext()) {
                InternalDistributedMember member = it_mem.next();
                Throwable th = it_causes.next();
                if (!this.membership.hasMember((MemberIdentifier)member) || th instanceof ShunnedMemberException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(String.format("Failed to send message <%s> to member <%s> no longer in view", content.getShortClassName(), member), th);
                    continue;
                }
                logger.fatal(String.format("Failed to send message <%s> to member <%s> view, %s", content, member, this.membership.getView()), th);
            }
            return new HashSet<InternalDistributedMember>(members);
        }
        catch (CancelException | ToDataException e) {
            this.checkCancelled();
            throw e;
        }
        catch (NotSerializableException | Error | RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", (Object)e.getMessage(), (Object)e);
            }
            this.checkCancelled();
            throw e;
        }
        return null;
    }

    @Override
    public Map<String, Long> getMessageState(DistributedMember member, boolean includeMulticast) {
        HashMap result = new HashMap();
        DirectChannel dc = this.directChannel;
        if (dc != null) {
            dc.getChannelStates(member, result);
        }
        return this.membership.getMessageState((MemberIdentifier)((InternalDistributedMember)member), includeMulticast, result);
    }

    @Override
    public void waitForMessageState(InternalDistributedMember member, Map<String, Long> state) throws InterruptedException, TimeoutException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DirectChannel dc = this.directChannel;
        if (dc != null) {
            dc.waitForChannelState(member, state);
        }
        this.membership.waitForMessageState((MemberIdentifier)member, state);
        if (this.mcastEnabled && !this.tcpDisabled) {
            this.waitForSerialMessageProcessing(member);
        }
    }

    @Override
    public boolean requestMemberRemoval(InternalDistributedMember member, String reason) {
        try {
            return this.membership.requestMemberRemoval((MemberIdentifier)member, reason);
        }
        catch (MemberDisconnectedException | MembershipClosedException e) {
            this.checkCancelled();
            throw new DistributedSystemDisconnectedException("Distribution is closed");
        }
        catch (RuntimeException e) {
            this.checkCancelled();
            if (!this.membership.isConnected()) {
                throw new DistributedSystemDisconnectedException("Distribution is closed", e);
            }
            throw e;
        }
    }

    @Override
    public boolean verifyMember(InternalDistributedMember mbr, String reason) {
        return this.membership.verifyMember((MemberIdentifier)mbr, reason);
    }

    @Override
    public <V> V doWithViewLocked(Supplier<V> function) {
        return (V)this.membership.doWithViewLocked(function);
    }

    @Override
    public boolean memberExists(InternalDistributedMember m) {
        return this.membership.memberExists((MemberIdentifier)m);
    }

    @Override
    public boolean isConnected() {
        return this.membership.isConnected();
    }

    @Override
    public void beSick() {
        this.membership.beSick();
    }

    @Override
    public void beHealthy() {
        this.membership.beHealthy();
    }

    @Override
    public void playDead() {
        this.membership.playDead();
    }

    @Override
    public boolean isBeingSick() {
        return this.membership.isBeingSick();
    }

    @Override
    public void disconnect(boolean beforeJoined) {
        this.membership.disconnect(beforeJoined);
    }

    @Override
    public void shutdown() {
        this.membership.shutdown();
    }

    @Override
    public void shutdownMessageReceived(InternalDistributedMember id, String reason) {
        this.membership.shutdownMessageReceived((MemberIdentifier)id, reason);
    }

    @Override
    public void waitForEventProcessing() throws InterruptedException {
        this.membership.waitForEventProcessing();
    }

    @Override
    public void startEventProcessing() {
        this.membership.startEventProcessing();
    }

    @Override
    public void setShutdown() {
        this.membership.setShutdown();
    }

    @Override
    public void setReconnectCompleted(boolean reconnectCompleted) {
        this.membership.setReconnectCompleted(reconnectCompleted);
    }

    @Override
    public boolean shutdownInProgress() {
        return this.membership.shutdownInProgress();
    }

    @Override
    public void emergencyClose() {
        this.membership.emergencyClose();
        if (this.directChannel != null) {
            this.directChannel.emergencyClose();
        }
    }

    @Override
    public void addSurpriseMemberForTesting(InternalDistributedMember mbr, long birthTime) {
        this.membership.addSurpriseMemberForTesting((MemberIdentifier)mbr, birthTime);
    }

    @Override
    public void suspectMembers(Set<InternalDistributedMember> members, String reason) {
        this.membership.suspectMembers(members, reason);
    }

    @Override
    public void suspectMember(InternalDistributedMember member, String reason) {
        this.membership.suspectMember((MemberIdentifier)member, reason);
    }

    @Override
    public Throwable getShutdownCause() {
        Throwable cause = this.membership.getShutdownCause();
        if (cause instanceof MemberDisconnectedException) {
            cause = new ForcedDisconnectException(cause.getMessage());
        }
        return cause;
    }

    @Override
    public boolean addSurpriseMember(InternalDistributedMember mbr) {
        return this.membership.addSurpriseMember((MemberIdentifier)mbr);
    }

    @Override
    public void startupMessageFailed(InternalDistributedMember mbr, String failureMessage) {
        this.membership.startupMessageFailed((MemberIdentifier)mbr, failureMessage);
    }

    @Override
    public boolean testMulticast() {
        return this.membership.testMulticast();
    }

    @Override
    public boolean isSurpriseMember(InternalDistributedMember m) {
        return this.membership.isSurpriseMember((MemberIdentifier)m);
    }

    @Override
    public QuorumChecker getQuorumChecker() {
        return this.membership.getQuorumChecker();
    }

    @Override
    public DistributedMember getCoordinator() {
        return (DistributedMember)this.membership.getCoordinator();
    }

    @Override
    public Set<InternalDistributedMember> getMembersNotShuttingDown() {
        return this.membership.getMembersNotShuttingDown();
    }

    @VisibleForTesting
    void setDirectChannel(DirectChannel dc) {
        this.directChannel = dc;
    }

    private void startDirectChannel(MemberIdentifier memberID) {
        int dcPort = 0;
        if (!this.tcpDisabled) {
            this.directChannel = new DirectChannel(this.membership, this.dcReceiver, this.clusterDistributionManager);
            dcPort = this.directChannel.getPort();
        }
        memberID.setDirectChannelPort(dcPort);
    }

    private boolean disconnectDirectChannel(Exception exception) {
        if (this.directChannel != null) {
            this.directChannel.disconnect(exception);
            return true;
        }
        return false;
    }

    private void setDirectChannelLocalAddress(InternalDistributedMember address) {
        if (this.directChannel != null) {
            this.directChannel.setLocalAddr(address);
        }
    }

    private void destroyMember(InternalDistributedMember member, String reason) {
        DirectChannel dc = this.directChannel;
        if (dc != null) {
            new LoggingThread("disconnect thread for " + member, () -> {
                try {
                    Thread.sleep(Integer.getInteger("p2p.disconnectDelay", 3000).intValue());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                if (!dc.isOpen()) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Membership: closing connections for departed member {}", (Object)member);
                }
                dc.closeEndpoint(member, reason, false);
            }).start();
        }
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
        this.forceUseUDPMessaging.set(Boolean.TRUE);
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
        this.forceUseUDPMessaging.set(Boolean.FALSE);
    }

    @Override
    public void setCloseInProgress() {
        this.membership.setCloseInProgress();
    }

    private boolean isForceUDPCommunications() {
        return this.forceUseUDPMessaging.get();
    }

    @Override
    public boolean waitForDeparture(InternalDistributedMember mbr) throws TimeoutException, InterruptedException {
        return this.waitForDeparture(mbr, this.memberTimeout * 4L);
    }

    @Override
    public boolean waitForDeparture(InternalDistributedMember mbr, long timeoutMs) throws TimeoutException, InterruptedException {
        boolean wait;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean result = false;
        DirectChannel dc = this.directChannel;
        InternalDistributedMember idm = mbr;
        long pauseTime = timeoutMs < 4000L ? 100L : timeoutMs / 40L;
        int numWaits = 0;
        do {
            wait = false;
            if (dc != null) {
                if (dc.hasReceiversFor(idm)) {
                    wait = true;
                }
                if (wait && logger.isDebugEnabled()) {
                    logger.info("waiting for receivers for {} to shut down", (Object)mbr);
                }
            }
            if (!wait && (wait = this.memberExists(idm)) && logger.isDebugEnabled()) {
                logger.debug("waiting for {} to leave the membership view", (Object)mbr);
            }
            if (!wait && this.waitForSerialMessageProcessing(idm)) {
                result = true;
            }
            if (!wait) continue;
            if (++numWaits > 40) {
                throw new TimeoutException("waited too long for " + idm + " to be removed");
            }
            Thread.sleep(pauseTime);
        } while (wait && dc != null && dc.isOpen() && !this.shutdownInProgress());
        if (logger.isDebugEnabled()) {
            logger.debug("operations for {} should all be in the cache at this point", (Object)mbr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean waitForSerialMessageProcessing(InternalDistributedMember idm) throws InterruptedException {
        boolean result = false;
        OverflowQueueWithDMStats<Runnable> serialQueue = this.clusterDistributionManager.getExecutors().getSerialQueue(idm);
        if (serialQueue == null) return result;
        boolean[] done = new boolean[1];
        final FlushingMessage msg = new FlushingMessage(done);
        serialQueue.add(new SizeableRunnable(100){

            @Override
            public void run() {
                msg.invoke();
            }

            public String toString() {
                return "Processing fake message";
            }
        });
        boolean[] blArray = done;
        synchronized (done) {
            while (!done[0]) {
                done.wait(10L);
            }
            return true;
        }
    }

    public DirectChannel getDirectChannel() {
        return this.directChannel;
    }

    private static class LifecycleListenerImpl
    implements LifecycleListener<InternalDistributedMember> {
        private final DistributionImpl distribution;

        LifecycleListenerImpl(DistributionImpl distribution) {
            this.distribution = distribution;
        }

        public void start(InternalDistributedMember memberID) {
            this.distribution.startDirectChannel(memberID);
        }

        public boolean disconnect(Exception cause) {
            Exception exception = cause;
            if (cause instanceof MemberDisconnectedException) {
                exception = new ForcedDisconnectException(cause.getMessage());
                if (cause.getCause() != null) {
                    exception.initCause(cause.getCause());
                }
            }
            return this.distribution.disconnectDirectChannel(exception);
        }

        public void joinCompleted(InternalDistributedMember address) {
            this.distribution.setDirectChannelLocalAddress(address);
        }

        public void destroyMember(InternalDistributedMember member, String reason) {
            this.distribution.destroyMember(member, reason);
        }

        public void forcedDisconnect(String reason, LifecycleListener.RECONNECTING isReconnect) {
            InternalLocator loc;
            if (isReconnect == LifecycleListener.RECONNECTING.NOT_RECONNECTING && (loc = (InternalLocator)Locator.getLocator()) != null) {
                loc.stop(true, !this.distribution.disableAutoReconnect, true);
            }
            if (reason != null) {
                this.distribution.clusterDistributionManager.setRootCause(new ForcedDisconnectException(reason));
            }
        }
    }

    static class FlushingMessage
    extends DistributionMessage {
        final boolean[] done;

        FlushingMessage(boolean[] done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() {
            boolean[] blArray = this.done;
            synchronized (this.done) {
                this.done[0] = true;
                this.done.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public int getDSFID() {
            return 0;
        }

        @Override
        public int getProcessorType() {
            return 0;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnownVersion[] getSerializationVersions() {
            return null;
        }
    }

    class MyDCReceiver
    implements MessageListener<InternalDistributedMember> {
        MyDCReceiver() {
        }

        public void messageReceived(Message<InternalDistributedMember> msg) throws MemberShunnedException {
            DistributionImpl.this.membership.processMessage(msg);
        }
    }
}

