/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.adapter.auth;

import java.security.Principal;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.security.CallbackInstantiator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.ResourcePermission;

public class GMSAuthenticator
implements org.apache.geode.distributed.internal.membership.api.Authenticator<InternalDistributedMember> {
    private final Properties securityProps;
    private final SecurityService securityService;
    private final LogWriter securityLogWriter;
    private final LogWriter logWriter;

    public GMSAuthenticator(Properties securityProps, SecurityService securityService, LogWriter securityLogWriter, LogWriter logWriter) {
        this.securityProps = securityProps;
        this.securityService = securityService;
        this.securityLogWriter = securityLogWriter;
        this.logWriter = logWriter;
    }

    public String authenticate(InternalDistributedMember member, Properties credentials) {
        return this.authenticate(member, credentials, this.securityProps);
    }

    String authenticate(MemberIdentifier member, Properties credentials, Properties secProps) {
        String authMethod = secProps.getProperty("security-peer-authenticator");
        if (!this.securityService.isPeerSecurityRequired() && StringUtils.isBlank((CharSequence)authMethod)) {
            return null;
        }
        if (credentials == null) {
            this.securityLogWriter.warning(String.format("Failed to find credentials from [%s]", member));
            return String.format("Failed to find credentials from [%s]", member);
        }
        String failMsg = null;
        try {
            if (this.securityService.isIntegratedSecurity()) {
                this.securityService.login(credentials);
                this.securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE);
            } else {
                this.invokeAuthenticator(secProps, member, credentials);
            }
        }
        catch (Exception ex) {
            this.securityLogWriter.warning(String.format("Security check failed for [%s]. %s", member, ex.getLocalizedMessage()), ex);
            failMsg = String.format("Security check failed. %s", ex.getLocalizedMessage());
        }
        return failMsg;
    }

    Principal invokeAuthenticator(Properties securityProps, MemberIdentifier member, Properties credentials) throws AuthenticationFailedException {
        String authMethod = securityProps.getProperty("security-peer-authenticator");
        try (Authenticator auth = null;){
            auth = CallbackInstantiator.getObjectOfType(authMethod, Authenticator.class);
            auth.init(this.securityProps, this.logWriter, this.securityLogWriter);
            Principal principal = auth.authenticate(credentials, (InternalDistributedMember)member);
            return principal;
        }
    }

    public Properties getCredentials(InternalDistributedMember member) {
        try {
            return this.getCredentials(member, this.securityProps);
        }
        catch (Exception e) {
            String authMethod = this.securityProps.getProperty("security-peer-auth-init");
            this.securityLogWriter.warning(String.format("Failed to obtain credentials using AuthInitialize [%s]. %s", authMethod, e.getLocalizedMessage()));
            return null;
        }
    }

    Properties getCredentials(MemberIdentifier member, Properties secProps) {
        String authMethod = secProps.getProperty("security-peer-auth-init");
        return Handshake.getCredentials(authMethod, secProps, (InternalDistributedMember)member, true, this.logWriter, this.securityLogWriter);
    }

    Properties getSecurityProps() {
        return this.securityProps;
    }
}

