/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LoaderHelperFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;

public class InternalRegionFactory<K, V>
extends RegionFactory<K, V> {
    private InternalRegionArguments internalRegionArguments;

    public InternalRegionFactory(InternalCache cache) {
        super(cache);
    }

    public InternalRegionFactory(InternalCache cache, RegionShortcut pra) {
        super(cache, pra);
    }

    public InternalRegionFactory(InternalCache cache, RegionAttributes<K, V> ra) {
        super(cache, ra);
    }

    public InternalRegionFactory(InternalCache cache, String regionAttributesId) {
        super(cache, regionAttributesId);
    }

    public InternalRegionFactory(RegionFactory<K, V> regionFactory) {
        super(regionFactory);
    }

    public RegionAttributes<K, V> getCreateAttributes() {
        return this.getRegionAttributes();
    }

    @Override
    public Region<K, V> create(String name) throws CacheExistsException, RegionExistsException, CacheWriterException, TimeoutException {
        if (this.internalRegionArguments == null) {
            return super.create(name);
        }
        try {
            return this.getCache().createVMRegion(name, this.getRegionAttributes(), this.internalRegionArguments);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalGemFireError("unexpected exception", e);
        }
    }

    @Override
    public Region<K, V> createSubregion(Region<?, ?> parent, String name) throws RegionExistsException {
        if (this.internalRegionArguments == null) {
            return super.createSubregion(parent, name);
        }
        try {
            return ((InternalRegion)parent).createSubregion(name, this.getRegionAttributes(), this.internalRegionArguments);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalGemFireError("unexpected exception", e);
        }
    }

    public InternalRegionArguments getInternalRegionArguments() {
        return this.internalRegionArguments;
    }

    public InternalRegionFactory<K, V> setIsUsedForPartitionedRegionAdmin(boolean adminFlag) {
        this.makeInternal().setIsUsedForPartitionedRegionAdmin(adminFlag);
        return this;
    }

    public InternalRegionFactory<K, V> setPartitionedRegionBucketRedundancy(int redundancy) {
        this.makeInternal().setPartitionedRegionBucketRedundancy(redundancy);
        return this;
    }

    public InternalRegionFactory<K, V> setPartitionedRegionAdvisor(RegionAdvisor advisor) {
        this.makeInternal().setPartitionedRegionAdvisor(advisor);
        return this;
    }

    public InternalRegionFactory<K, V> setBucketAdvisor(BucketAdvisor advisor) {
        this.makeInternal().setBucketAdvisor(advisor);
        return this;
    }

    public InternalRegionFactory<K, V> setPersistenceAdvisor(PersistenceAdvisor persistenceAdvisor) {
        this.makeInternal().setPersistenceAdvisor(persistenceAdvisor);
        return this;
    }

    public InternalRegionFactory<K, V> setDiskRegion(DiskRegion diskRegion) {
        this.makeInternal().setDiskRegion(diskRegion);
        return this;
    }

    public InternalRegionFactory<K, V> setIsUsedForMetaRegion(boolean isMetaRegion) {
        this.makeInternal().setIsUsedForMetaRegion(isMetaRegion);
        return this;
    }

    public InternalRegionFactory<K, V> setMetaRegionWithTransactions(boolean metaRegionWithTransactions) {
        this.makeInternal().setMetaRegionWithTransactions(metaRegionWithTransactions);
        return this;
    }

    public InternalRegionFactory<K, V> setLoaderHelperFactory(LoaderHelperFactory loaderHelperFactory) {
        this.makeInternal().setLoaderHelperFactory(loaderHelperFactory);
        return this;
    }

    public InternalRegionFactory<K, V> setDestroyLockFlag(boolean getDestoryLock) {
        this.makeInternal().setDestroyLockFlag(getDestoryLock);
        return this;
    }

    public InternalRegionFactory<K, V> setSnapshotInputStream(InputStream snapshotInputStream) {
        this.makeInternal().setSnapshotInputStream(snapshotInputStream);
        return this;
    }

    public InternalRegionFactory<K, V> setImageTarget(InternalDistributedMember imageTarget) {
        this.makeInternal().setImageTarget(imageTarget);
        return this;
    }

    public InternalRegionFactory<K, V> setRecreateFlag(boolean recreate) {
        this.makeInternal().setRecreateFlag(recreate);
        return this;
    }

    public InternalRegionFactory<K, V> setInternalMetaRegion(LocalRegion r) {
        this.makeInternal().setInternalMetaRegion(r);
        return this;
    }

    public InternalRegionFactory<K, V> setCachePerfStatsHolder(HasCachePerfStats cachePerfStatsHolder) {
        this.makeInternal().setCachePerfStatsHolder(cachePerfStatsHolder);
        return this;
    }

    public InternalRegionFactory<K, V> setPartitionedRegion(PartitionedRegion partitionedRegion) {
        this.makeInternal().setPartitionedRegion(partitionedRegion);
        return this;
    }

    public InternalRegionFactory<K, V> setTestCallable(LocalRegion.TestCallable c) {
        this.makeInternal().setTestCallable(c);
        return this;
    }

    public InternalRegionFactory<K, V> setUserAttribute(Object userAttr) {
        this.makeInternal().setUserAttribute(userAttr);
        return this;
    }

    public InternalRegionFactory<K, V> setIsUsedForSerialGatewaySenderQueue(boolean queueFlag) {
        this.makeInternal().setIsUsedForSerialGatewaySenderQueue(queueFlag);
        return this;
    }

    public InternalRegionFactory<K, V> setIsUsedForParallelGatewaySenderQueue(boolean queueFlag) {
        this.makeInternal().setIsUsedForParallelGatewaySenderQueue(queueFlag);
        return this;
    }

    public InternalRegionFactory<K, V> setParallelGatewaySender(AbstractGatewaySender pgSender) {
        this.makeInternal().setParallelGatewaySender(pgSender);
        return this;
    }

    public InternalRegionFactory<K, V> setSerialGatewaySender(AbstractGatewaySender serialSender) {
        this.makeInternal().setSerialGatewaySender(serialSender);
        return this;
    }

    public InternalRegionFactory<K, V> setIndexes(List indexes) {
        this.makeInternal().setIndexes(indexes);
        return this;
    }

    public InternalRegionFactory<K, V> addCacheServiceProfile(CacheServiceProfile profile) {
        this.makeInternal().addCacheServiceProfile(profile);
        return this;
    }

    public InternalRegionFactory<K, V> addInternalAsyncEventQueueId(String aeqId) {
        this.makeInternal().addInternalAsyncEventQueueId(aeqId);
        return this;
    }

    public InternalRegionFactory<K, V> setInternalRegion(boolean internalRegion) {
        this.makeInternal().setInternalRegion(internalRegion);
        return this;
    }

    private InternalRegionArguments makeInternal() {
        if (this.internalRegionArguments == null) {
            this.internalRegionArguments = new InternalRegionArguments();
        }
        return this.internalRegionArguments;
    }
}

