/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DuplicatePrimaryPartitionException;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.Node;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionRegionConfigValidator {
    private static final Logger logger = LogService.getLogger();
    private final PartitionedRegion pr;
    public static final String EVICTION_ATTRIBUTE_MAXIMUM_MEMORY_MESSAGE = " the Eviction Attribute for maximum memory, ";
    public static final String EVICTION_ATTRIBUTE_MAXIMUM_ENTRIES_MESSAGE = " the Eviction Attribute for maximum entries, ";
    public static final String EVICTION_ATTRIBUTES_ARE_INCOMPATIBLE_MESSAGE = " is incompatible with other VMs which have EvictionAttributes ";

    public PartitionRegionConfigValidator(PartitionedRegion pr) {
        this.pr = pr;
    }

    void validatePartitionAttrsFromPRConfig(PartitionRegionConfig prconf) {
        PartitionAttributes prconfPA = prconf.getPartitionAttrs();
        PartitionAttributes userPA = this.pr.getAttributes().getPartitionAttributes();
        if (userPA.getTotalSize() != prconfPA.getTotalSize()) {
            throw new IllegalStateException(String.format("Total size in PartitionAttributes is incompatible with globally set total size. Set the total size to %sMB.", prconfPA.getTotalSize()));
        }
        if (userPA.getRedundantCopies() != prconfPA.getRedundantCopies()) {
            throw new IllegalStateException(String.format("Requested redundancy %s is incompatible with existing redundancy %s", userPA.getRedundantCopies(), prconfPA.getRedundantCopies()));
        }
        if (prconf.isFirstDataStoreCreated() && this.pr.isDataStore()) {
            this.validateDistributedEvictionAttributes(prconf.getEvictionAttributes());
        }
        Scope prconfScope = prconf.getScope();
        Scope myScope = this.pr.getScope();
        if (!myScope.equals(prconfScope)) {
            throw new IllegalStateException(String.format("Scope in PartitionAttributes is incompatible with already set scope.Set the scope to %s .", prconfScope));
        }
        int prconfTotalNumBuckets = prconfPA.getTotalNumBuckets();
        if (userPA.getTotalNumBuckets() != prconfTotalNumBuckets) {
            throw new IllegalStateException(String.format("The total number of buckets found in PartitionAttributes ( %s ) is incompatible with the total number of buckets used by other distributed members. Set the number of buckets to %s", userPA.getTotalNumBuckets(), prconfTotalNumBuckets));
        }
        this.validatePartitionListeners(prconf, userPA);
        this.validatePartitionResolver(prconf, userPA);
        this.validateColocatedWith(prconf, userPA);
        this.validateExpirationAttributes(this.pr.getAttributes(), prconf);
    }

    private void validatePartitionListeners(PartitionRegionConfig prconf, PartitionAttributes userPA) {
        ArrayList<String> prconfList = prconf.getPartitionListenerClassNames();
        if (userPA.getPartitionListeners() == null && userPA.getPartitionListeners().length == 0 && prconfList != null) {
            throw new IllegalStateException(String.format("The PartitionListeners=%s are incompatible with the PartitionListeners=%s used by other distributed members.", null, prconfList));
        }
        if (userPA.getPartitionListeners() != null && prconfList != null) {
            ArrayList<String> userPRList = new ArrayList<String>();
            for (int i = 0; i < userPA.getPartitionListeners().length; ++i) {
                userPRList.add(userPA.getPartitionListeners()[i].getClass().getName());
            }
            if (userPA.getPartitionListeners().length != prconfList.size()) {
                throw new IllegalStateException(String.format("The PartitionListeners=%s are incompatible with the PartitionListeners=%s used by other distributed members.", userPRList, prconfList));
            }
            for (String listener : prconfList) {
                if (userPRList.contains(listener)) continue;
                throw new IllegalStateException(String.format("The PartitionListeners=%s are incompatible with the PartitionListeners=%s used by other distributed members.", userPRList, prconfList));
            }
        }
    }

    private void validatePartitionResolver(PartitionRegionConfig prconf, PartitionAttributes userPA) {
        if (userPA.getPartitionResolver() != null && prconf.getResolverClassName() != null && !prconf.getResolverClassName().equals(userPA.getPartitionResolver().getClass().getName())) {
            throw new IllegalStateException(String.format("The PartitionResolver=%s is incompatible with the PartitionResolver=%s used by other distributed members.", userPA.getPartitionResolver().getClass().getName(), prconf.getResolverClassName()));
        }
    }

    private void validateColocatedWith(PartitionRegionConfig prconf, PartitionAttributes userPA) {
        if (userPA.getColocatedWith() == null && prconf.getColocatedWith() != null) {
            throw new IllegalStateException(String.format("The colocatedWith=%s found in PartitionAttributes is incompatible with the colocatedWith=%s used by other distributed members.", "null", prconf.getColocatedWith()));
        }
        if (userPA.getColocatedWith() != null && prconf.getColocatedWith() != null && !prconf.getColocatedWith().equals(userPA.getColocatedWith())) {
            throw new IllegalStateException(String.format("The colocatedWith=%s found in PartitionAttributes is incompatible with the colocatedWith=%s used by other distributed members.", userPA.getColocatedWith(), prconf.getColocatedWith()));
        }
    }

    private void validateExpirationAttributes(RegionAttributes userRA, PartitionRegionConfig prconf) {
        if (!userRA.getRegionIdleTimeout().equals(prconf.getRegionIdleTimeout())) {
            throw new IllegalStateException(String.format("The %1$s set in RegionAttributes is incompatible with %1$s used by other distributed members.", " region idle timout "));
        }
        if (!userRA.getRegionTimeToLive().equals(prconf.getRegionTimeToLive())) {
            throw new IllegalStateException(String.format("The %1$s set in RegionAttributes is incompatible with %1$s used by other distributed members.", " region time to live "));
        }
        if (!userRA.getEntryIdleTimeout().equals(prconf.getEntryIdleTimeout())) {
            throw new IllegalStateException(String.format("The %1$s set in RegionAttributes is incompatible with %1$s used by other distributed members.", " entry idle timout "));
        }
        if (!userRA.getEntryTimeToLive().equals(prconf.getEntryTimeToLive())) {
            throw new IllegalStateException(String.format("The %1$s set in RegionAttributes is incompatible with %1$s used by other distributed members.", " entry time to live "));
        }
    }

    private void validateDistributedEvictionAttributes(EvictionAttributes prconfEa) {
        boolean equivAlgoAndAction;
        EvictionAttributes ea = this.pr.getAttributes().getEvictionAttributes();
        Assert.assertTrue(ea != null);
        Assert.assertTrue(prconfEa != null);
        boolean bl = equivAlgoAndAction = ea.getAlgorithm().equals(prconfEa.getAlgorithm()) && ea.getAction().equals(prconfEa.getAction());
        if (!equivAlgoAndAction) {
            throw new IllegalStateException("For Partitioned Region " + this.pr.getFullPath() + " the configured EvictionAttributes " + ea + EVICTION_ATTRIBUTES_ARE_INCOMPATIBLE_MESSAGE + prconfEa);
        }
        if (ea.getAction().isLocalDestroy() && !ea.getAlgorithm().isLRUHeap() && ea.getMaximum() != prconfEa.getMaximum()) {
            logger.warn("For Partitioned Region {} the locally configured EvictionAttributes {} do not match with other EvictionAttributes {} and may cause misses during reads from VMs with smaller maximums.", new Object[]{this.pr.getFullPath(), ea, prconfEa});
        }
    }

    void validateEvictionAttributesAgainstLocalMaxMemory() {
        EvictionAttributes ea = this.pr.getEvictionAttributes();
        if (this.pr.getLocalMaxMemory() == 0 && !ea.getAction().isNone()) {
            logger.info("EvictionAttributes {} will have no effect for Partitioned Region {} on this VM because localMaxMemory is {}.", new Object[]{ea, this.pr.getFullPath(), this.pr.localMaxMemory});
        }
    }

    void validatePersistentMatchBetweenDataStores(PartitionRegionConfig prconf) {
        boolean isPersistent;
        boolean bl = isPersistent = this.pr.getAttributes().getDataPolicy() == DataPolicy.PERSISTENT_PARTITION;
        if (this.pr.getLocalMaxMemory() == 0 || prconf == null) {
            return;
        }
        Set<Node> nodes = prconf.getNodes();
        for (Node n : nodes) {
            if (n.getPRType() != 3 || n.isPersistent() == (this.pr.getAttributes().getDataPolicy() == DataPolicy.PERSISTENT_PARTITION)) continue;
            throw new IllegalStateException("DataPolicy for Datastore members should all be persistent or not.");
        }
    }

    void validateColocation() {
        PartitionAttributesImpl userPA = (PartitionAttributesImpl)this.pr.getAttributes().getPartitionAttributes();
        userPA.validateColocation(this.pr.getCache());
        PartitionedRegion colocatedPR = ColocationHelper.getColocatedRegion(this.pr);
        if (colocatedPR != null) {
            if (colocatedPR.getPartitionAttributes().getTotalNumBuckets() != userPA.getTotalNumBuckets()) {
                throw new IllegalStateException("Colocated regions should have same number of total-num-buckets");
            }
            if (colocatedPR.getPartitionAttributes().getRedundantCopies() != userPA.getRedundantCopies()) {
                throw new IllegalStateException("Colocated regions should have same number of redundant-copies");
            }
            if (colocatedPR.getPartitionAttributes().getLocalMaxMemory() == 0 && userPA.getLocalMaxMemory() != 0) {
                throw new IllegalStateException("Colocated regions should have accessors at the same node");
            }
            if (colocatedPR.getLocalMaxMemory() != 0 && userPA.getLocalMaxMemory() == 0) {
                throw new IllegalStateException("Colocated regions should have accessors at the same node");
            }
            if (!this.pr.isShadowPR() && this.pr.getAttributes().getDataPolicy().withPersistence() && !colocatedPR.getDataPolicy().withPersistence()) {
                throw new IllegalStateException("Cannot colocate a persistent region with a non persistent region");
            }
        }
    }

    public void validateCacheLoaderWriterBetweenDataStores(PartitionRegionConfig prconf) {
        if (this.pr.getLocalMaxMemory() == 0 || prconf == null) {
            return;
        }
        Set<Node> nodes = prconf.getNodes();
        for (Node n : nodes) {
            if (n.getPRType() != 3) continue;
            if (n.isCacheLoaderAttached() && this.pr.getAttributes().getCacheLoader() == null) {
                throw new IllegalStateException(String.format("Incompatible CacheLoader. CacheLoader is not null in partitionedRegion %s on another datastore.", this.pr.getName()));
            }
            if (!n.isCacheLoaderAttached() && this.pr.getAttributes().getCacheLoader() != null) {
                throw new IllegalStateException(String.format("Incompatible CacheLoader. CacheLoader is null in partitionedRegion %s on another datastore.", this.pr.getName()));
            }
            if (n.isCacheWriterAttached() && this.pr.getAttributes().getCacheWriter() == null) {
                throw new IllegalStateException(String.format("Incompatible CacheWriter. CacheWriter is not null in partitionedRegion %s on another datastore.", this.pr.getName()));
            }
            if (n.isCacheWriterAttached() || this.pr.getAttributes().getCacheWriter() == null) continue;
            throw new IllegalStateException(String.format("Incompatible CacheWriter. CacheWriter is null in partitionedRegion %s on another datastore.", this.pr.getName()));
        }
    }

    void validateFixedPartitionAttributes() {
        if (this.pr.getFixedPartitionAttributesImpl() != null) {
            this.validatePrimaryFixedPartitionAttributes();
            this.validateFixedPartitionAttributesAgainstRedundantCopies();
            this.validateFixedPartitionAttributesAgainstTotalNumberBuckets();
        }
    }

    private void validateFixedPartitionAttributesAgainstTotalNumberBuckets() {
        for (FixedPartitionAttributesImpl fpa : this.pr.getFixedPartitionAttributesImpl()) {
            int numBuckets = 0;
            HashSet<FixedPartitionAttributesImpl> allFPAs = new HashSet<FixedPartitionAttributesImpl>(this.pr.getRegionAdvisor().adviseAllFixedPartitionAttributes());
            allFPAs.add(fpa);
            for (FixedPartitionAttributes fixedPartitionAttributes : allFPAs) {
                numBuckets += fixedPartitionAttributes.getNumBuckets();
            }
            if (numBuckets <= this.pr.getTotalNumberOfBuckets()) continue;
            throw new IllegalStateException(String.format("For region %s,sum of num-buckets %s for different primary partitions should not be greater than total-num-buckets %s.", this.pr.getName(), numBuckets, this.pr.getTotalNumberOfBuckets()));
        }
    }

    private void validateFixedPartitionAttributesAgainstRedundantCopies() {
        for (FixedPartitionAttributesImpl fpa : this.pr.getFixedPartitionAttributesImpl()) {
            List<FixedPartitionAttributesImpl> allSameFPAs = this.pr.getRegionAdvisor().adviseSameFPAs(fpa);
            allSameFPAs.add(fpa);
            if (allSameFPAs.isEmpty()) continue;
            int numSecondaries = 0;
            for (FixedPartitionAttributes fixedPartitionAttributes : allSameFPAs) {
                if (fpa.getNumBuckets() != fixedPartitionAttributes.getNumBuckets()) {
                    throw new IllegalStateException(String.format("For region %s,for partition %s, num-buckets are not same (%s, %s)across nodes.", this.pr.getName(), fpa.getPartitionName(), fpa.getNumBuckets(), fixedPartitionAttributes.getNumBuckets()));
                }
                if (fixedPartitionAttributes.isPrimary() || ++numSecondaries <= this.pr.getRedundantCopies()) continue;
                throw new IllegalStateException(String.format("For region %s, number of secondary partitions %s of a partition %s should never exceed number of redundant copies %s.", this.pr.getName(), numSecondaries, fpa.getPartitionName(), this.pr.getRedundantCopies()));
            }
        }
    }

    private void validatePrimaryFixedPartitionAttributes() {
        List<FixedPartitionAttributesImpl> remotePrimaryFPAs = this.pr.getRegionAdvisor().adviseRemotePrimaryFPAs();
        for (FixedPartitionAttributes fixedPartitionAttributes : this.pr.getFixedPartitionAttributesImpl()) {
            if (!fixedPartitionAttributes.isPrimary() || !remotePrimaryFPAs.contains(fixedPartitionAttributes)) continue;
            throw new DuplicatePrimaryPartitionException(String.format("For region %s, same partition name %s can not be defined as primary on more than one node.", this.pr.getName(), fixedPartitionAttributes.getPartitionName()));
        }
    }

    public void validateFixedPABetweenDataStores(PartitionRegionConfig prconf) {
        boolean isDataStore = this.pr.localMaxMemory > 0;
        boolean isFixedPR = this.pr.fixedPAttrs != null;
        Set<Node> nodes = prconf.getNodes();
        for (Node n : nodes) {
            if (isFixedPR) {
                if (n.getPRType() != 2 && n.getPRType() != 3) continue;
                Object[] prms = new Object[]{this.pr.getName()};
                throw new IllegalStateException(String.format("Region %s uses fixed partitioning but at least one datastore node (localMaxMemory > 0) has no fixed partitions. Please make sure that each datastore creating this region is configured with at least one fixed partition.", prms));
            }
            if (!isDataStore || n.getPRType() != 4 && n.getPRType() != 5) continue;
            Object[] prms = new Object[]{this.pr.getName()};
            throw new IllegalStateException(String.format("Region %s uses fixed partitioning but at least one datastore node (localMaxMemory > 0) has no fixed partitions. Please make sure that each datastore creating this region is configured with at least one fixed partition.", prms));
        }
    }
}

