/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.internal.cache.CacheServerAdvisor;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.ServerFactory;
import org.apache.geode.internal.cache.tier.sockets.AcceptorBuilder;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.statistics.StatisticsClock;

class ServerBuilder
implements ServerFactory {
    private final InternalCache cache;
    private final SecurityService securityService;
    private final StatisticsClock statisticsClock;
    private boolean sendResourceEvents = true;
    private boolean includeMemberGroups = true;
    private SocketCreatorType socketCreatorType = SocketCreatorType.SERVER;
    private Supplier<SocketCreator> socketCreatorSupplier = this.socketCreatorType.getSupplier();
    private CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider = CacheClientNotifier.singletonProvider();
    private ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider = ClientHealthMonitor.singletonProvider();
    private Function<DistributionAdvisee, CacheServerAdvisor> cacheServerAdvisorProvider = CacheServerAdvisor::createCacheServerAdvisor;
    private List<GatewayTransportFilter> gatewayTransportFilters = Collections.emptyList();

    ServerBuilder(InternalCache cache, SecurityService securityService, StatisticsClock statisticsClock) {
        this.cache = cache;
        this.securityService = securityService;
        this.statisticsClock = statisticsClock;
    }

    ServerBuilder forGatewayReceiver(GatewayReceiver gatewayReceiver) {
        this.sendResourceEvents = false;
        this.includeMemberGroups = false;
        this.socketCreatorType = SocketCreatorType.GATEWAY;
        this.socketCreatorSupplier = SocketCreatorType.GATEWAY.getSupplier();
        this.gatewayTransportFilters = gatewayReceiver.getGatewayTransportFilters();
        return this;
    }

    @VisibleForTesting
    ServerBuilder setSocketCreatorSupplier(Supplier<SocketCreator> socketCreatorSupplier) {
        this.socketCreatorSupplier = socketCreatorSupplier;
        return this;
    }

    @VisibleForTesting
    ServerBuilder setCacheClientNotifierProvider(CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider) {
        this.cacheClientNotifierProvider = cacheClientNotifierProvider;
        return this;
    }

    @VisibleForTesting
    ServerBuilder setClientHealthMonitorProvider(ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider) {
        this.clientHealthMonitorProvider = clientHealthMonitorProvider;
        return this;
    }

    @VisibleForTesting
    ServerBuilder setCacheServerAdvisorProvider(Function<DistributionAdvisee, CacheServerAdvisor> cacheServerAdvisorProvider) {
        this.cacheServerAdvisorProvider = cacheServerAdvisorProvider;
        return this;
    }

    @Override
    public InternalCacheServer createServer() {
        AcceptorBuilder acceptorBuilder = new AcceptorBuilder();
        acceptorBuilder.setIsGatewayReceiver(this.socketCreatorType.isGateway());
        acceptorBuilder.setGatewayTransportFilters(this.gatewayTransportFilters);
        return new CacheServerImpl(this.cache, this.securityService, this.statisticsClock, acceptorBuilder, this.sendResourceEvents, this.includeMemberGroups, this.socketCreatorSupplier, this.cacheClientNotifierProvider, this.clientHealthMonitorProvider, this.cacheServerAdvisorProvider);
    }

    @VisibleForTesting
    boolean isSendResourceEvents() {
        return this.sendResourceEvents;
    }

    @VisibleForTesting
    boolean isIncludeMemberGroups() {
        return this.includeMemberGroups;
    }

    @VisibleForTesting
    Supplier<SocketCreator> getSocketCreatorSupplier() {
        return this.socketCreatorSupplier;
    }

    @VisibleForTesting
    CacheClientNotifier.CacheClientNotifierProvider getCacheClientNotifierProvider() {
        return this.cacheClientNotifierProvider;
    }

    @VisibleForTesting
    ClientHealthMonitor.ClientHealthMonitorProvider getClientHealthMonitorProvider() {
        return this.clientHealthMonitorProvider;
    }

    @VisibleForTesting
    Function<DistributionAdvisee, CacheServerAdvisor> getCacheServerAdvisorProvider() {
        return this.cacheServerAdvisorProvider;
    }

    @VisibleForTesting
    List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    static enum SocketCreatorType {
        SERVER(() -> SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.SERVER)),
        GATEWAY(() -> SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.GATEWAY));

        private final Supplier<SocketCreator> supplier;

        private SocketCreatorType(Supplier<SocketCreator> supplier) {
            this.supplier = supplier;
        }

        Supplier<SocketCreator> getSupplier() {
            return this.supplier;
        }

        boolean isGateway() {
            return this == GATEWAY;
        }
    }
}

