/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.management.Notification;
import javax.management.openmbean.CompositeData;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class TenuredHeapConsumptionMonitor {
    private static final Logger logger = LogService.getLogger();
    private final BiConsumer<String, Throwable> infoLogger;
    private final Function<CompositeData, MemoryNotificationInfo> memoryNotificationInfoFactory;

    TenuredHeapConsumptionMonitor() {
        this((arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1), MemoryNotificationInfo::from);
    }

    @VisibleForTesting
    TenuredHeapConsumptionMonitor(BiConsumer<String, Throwable> infoLogger, Function<CompositeData, MemoryNotificationInfo> memoryNotificationInfoFactory) {
        this.infoLogger = infoLogger;
        this.memoryNotificationInfoFactory = memoryNotificationInfoFactory;
    }

    void checkTenuredHeapConsumption(Notification notification) {
        try {
            String type = notification.getType();
            if (type.equals("java.management.memory.threshold.exceeded") || type.equals("java.management.memory.collection.threshold.exceeded")) {
                CompositeData compositeData = (CompositeData)notification.getUserData();
                MemoryNotificationInfo info = this.memoryNotificationInfoFactory.apply(compositeData);
                MemoryUsage usage = info.getUsage();
                long usedBytes = usage.getUsed();
                this.infoLogger.accept("A tenured heap garbage collection has occurred.  New tenured heap consumption: " + usedBytes, null);
            }
        }
        catch (Exception e) {
            this.infoLogger.accept("An Exception occurred while attempting to log tenured heap consumption", e);
        }
    }
}

