/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryOffHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinLRURegionEntryOffHeapIntKey
extends VMThinLRURegionEntryOffHeap {
    private static final AtomicLongFieldUpdater<VMThinLRURegionEntryOffHeapIntKey> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinLRURegionEntryOffHeapIntKey.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile long offHeapAddress;
    private static final AtomicLongFieldUpdater<VMThinLRURegionEntryOffHeapIntKey> OFF_HEAP_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinLRURegionEntryOffHeapIntKey.class, "offHeapAddress");
    private final int key;
    private EvictionNode nextEvictionNode;
    private EvictionNode previousEvictionNode;
    private int size;

    public VMThinLRURegionEntryOffHeapIntKey(RegionEntryContext context, int key, Object value) {
        super(context, value);
        this.key = key;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object value) {
        OffHeapRegionEntryHelper.setValue(this, value);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return OFF_HEAP_ADDRESS_UPDATER.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddress, long newAddress) {
        return OFF_HEAP_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    @Override
    public void setDelayedDiskId(DiskRecoveryStore diskRecoveryStore) {
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController) {
        return this.updateEntrySize(evictionController, this.getValue());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean isRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed(RegionEntryContext context) {
        if (!this.isRecentlyUsed()) {
            this.setBits(0x1000000000000000L);
            context.incRecentlyUsed();
        }
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean isEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNext(EvictionNode nextEvictionNode) {
        this.nextEvictionNode = nextEvictionNode;
    }

    @Override
    public EvictionNode next() {
        return this.nextEvictionNode;
    }

    @Override
    public void setPrevious(EvictionNode previousEvictionNode) {
        this.previousEvictionNode = previousEvictionNode;
    }

    @Override
    public EvictionNode previous() {
        return this.previousEvictionNode;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof Integer) {
            return (Integer)key == this.key;
        }
        return false;
    }
}

